/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.ZNRecordRow;
import org.apache.log4j.Logger;

public class CriteriaEvaluator {
    private static Logger logger = Logger.getLogger(CriteriaEvaluator.class);

    public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixManager manager) {
        List properties;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet selected = Sets.newHashSet();
        if (recipientCriteria.getDataSource() == Criteria.DataSource.EXTERNALVIEW) {
            properties = accessor.getChildValues(keyBuilder.externalViews());
        } else if (recipientCriteria.getDataSource() == Criteria.DataSource.IDEALSTATES) {
            properties = accessor.getChildValues(keyBuilder.idealStates());
        } else {
            return Collections.emptyList();
        }
        List<ZNRecordRow> allRows = ZNRecordRow.flatten(HelixProperty.convertToList(properties));
        Set<String> liveParticipants = accessor.getChildValuesMap(keyBuilder.liveInstances()).keySet();
        ArrayList result = Lists.newArrayList();
        for (ZNRecordRow row : allRows) {
            if (!this.rowMatches(recipientCriteria, row) || !liveParticipants.contains(row.getMapSubKey())) continue;
            result.add(row);
        }
        for (ZNRecordRow row : result) {
            HashMap<String, String> resultRow = new HashMap<String, String>();
            resultRow.put("instanceName", !recipientCriteria.getInstanceName().equals("") ? row.getMapSubKey() : "");
            resultRow.put("resourceName", !recipientCriteria.getResource().equals("") ? row.getRecordId() : "");
            resultRow.put("partitionName", !recipientCriteria.getPartition().equals("") ? row.getMapKey() : "");
            resultRow.put("partitionState", !recipientCriteria.getPartitionState().equals("") ? row.getMapValue() : "");
            selected.add(resultRow);
        }
        logger.info((Object)("Query returned " + selected.size() + " rows"));
        return Lists.newArrayList((Iterable)selected);
    }

    private boolean rowMatches(Criteria criteria, ZNRecordRow row) {
        String instanceName = this.normalizePattern(criteria.getInstanceName());
        String resourceName = this.normalizePattern(criteria.getResource());
        String partitionName = this.normalizePattern(criteria.getPartition());
        String partitionState = this.normalizePattern(criteria.getPartitionState());
        return this.stringMatches(instanceName, row.getMapSubKey()) && this.stringMatches(resourceName, row.getRecordId()) && this.stringMatches(partitionName, row.getMapKey()) && this.stringMatches(partitionState, row.getMapValue());
    }

    private String normalizePattern(String pattern) {
        if (pattern == null || pattern.equals("") || pattern.equals("*")) {
            pattern = "%";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(ch) != -1) {
                builder.append("\\");
            }
            builder.append(ch);
        }
        pattern = builder.toString().toLowerCase().replace("_", ".").replace("%", ".*?");
        return pattern;
    }

    private boolean stringMatches(String pattern, String value) {
        Pattern p = Pattern.compile(pattern, 34);
        return p.matcher(value).matches();
    }
}

