/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.lang.reflect.Modifier;
import java.util.Map;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDataModelOracleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDataModelOracleUtils.class);

    public static void loadExternalDependencies(DataModel dataModel, ProjectDataModelOracle projectDataModelOracle, ClassLoader classLoader) throws ModelDriverException {
        String[] factTypes = DataModelOracleUtilities.getFactTypes((ProjectDataModelOracle)projectDataModelOracle);
        ObjectSource source = null;
        if (factTypes != null && factTypes.length > 0) {
            for (int i = 0; i < factTypes.length; ++i) {
                source = ProjectDataModelOracleUtils.factSource(projectDataModelOracle, factTypes[i]);
                if (source == null || !ObjectSource.DEPENDENCY.equals((Object)source)) continue;
                ProjectDataModelOracleUtils.addFactType(dataModel, projectDataModelOracle, factTypes[i], source, classLoader);
            }
        }
    }

    private static void addFactType(DataModel dataModel, ProjectDataModelOracle oracleDataModel, String factType, ObjectSource source, ClassLoader classLoader) throws ModelDriverException {
        String packageName = NamingUtils.extractPackageName(factType);
        String className = NamingUtils.extractClassName(factType);
        String superClass = DataModelOracleUtilities.getSuperType((ProjectDataModelOracle)oracleDataModel, (String)factType);
        logger.debug("Adding factType: " + factType + ", to dataModel: " + dataModel + ", from oracleDataModel: " + oracleDataModel);
        ClassMetadata classMetadata = ProjectDataModelOracleUtils.readClassMetadata(factType, classLoader);
        if (!(classMetadata == null || classMetadata.isMemberClass() || classMetadata.isAnonymousClass() || classMetadata.isLocalClass())) {
            Visibility visibility = DriverUtils.buildVisibility(classMetadata.getModifiers());
            DataObject dataObject = dataModel.addDataObject(factType, visibility, Modifier.isAbstract(classMetadata.getModifiers()), Modifier.isFinal(classMetadata.getModifiers()), source);
            dataObject.setSuperClassName(superClass);
            Map fields = oracleDataModel.getProjectModelFields();
            if (fields != null) {
                ModelField[] factFields = (ModelField[])fields.get(factType);
                Map typeFieldsAnnotations = DataModelOracleUtilities.getTypeFieldsAnnotations((ProjectDataModelOracle)oracleDataModel, (String)factType);
                Integer naturalOrder = 0;
                if (factFields != null && factFields.length > 0) {
                    for (int j = 0; j < factFields.length; ++j) {
                        ModelField field = factFields[j];
                        if (!ProjectDataModelOracleUtils.isLoadableField(field)) continue;
                        if (field.getType().equals("Collection")) {
                            ObjectProperty property;
                            String bag = DataModelOracleUtilities.getFieldClassName((ProjectDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                            String itemsClass = DataModelOracleUtilities.getParametricFieldType((ProjectDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                            if (itemsClass == null) {
                                property = dataObject.addProperty(field.getName(), bag);
                                continue;
                            }
                            property = dataObject.addProperty(field.getName(), itemsClass, true, bag);
                            continue;
                        }
                        ObjectProperty objectProperty = dataObject.addProperty(field.getName(), field.getClassName());
                    }
                }
            } else {
                logger.debug("No fields for factTye: " + factType);
            }
        }
    }

    private static ClassMetadata readClassMetadata(String factType, ClassLoader classLoader) {
        try {
            Class<?> _class = classLoader.loadClass(factType);
            return new ClassMetadata(_class.getModifiers(), _class.isMemberClass(), _class.isLocalClass(), _class.isAnonymousClass());
        }
        catch (ClassNotFoundException e) {
            logger.error("It was not possible to read class metadata for class: " + factType);
            return null;
        }
    }

    private static ObjectSource factSource(ProjectDataModelOracle oracleDataModel, String factType) {
        TypeSource oracleType = DataModelOracleUtilities.getTypeSource((ProjectDataModelOracle)oracleDataModel, (String)factType);
        if (TypeSource.JAVA_PROJECT.equals((Object)oracleType)) {
            return ObjectSource.INTERNAL;
        }
        if (TypeSource.JAVA_DEPENDENCY.equals((Object)oracleType)) {
            return ObjectSource.DEPENDENCY;
        }
        return null;
    }

    private static boolean isLoadableField(ModelField field) {
        return field.getOrigin().equals((Object)ModelField.FIELD_ORIGIN.DECLARED);
    }

    static class ClassMetadata {
        int modifiers;
        boolean memberClass;
        boolean localClass;
        boolean anonymousClass;

        public ClassMetadata(int modifiers, boolean memberClass, boolean localClass, boolean anonymousClass) {
            this.modifiers = modifiers;
            this.memberClass = memberClass;
            this.localClass = localClass;
            this.anonymousClass = anonymousClass;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean isMemberClass() {
            return this.memberClass;
        }

        public void setMemberClass(boolean memberClass) {
            this.memberClass = memberClass;
        }

        public boolean isLocalClass() {
            return this.localClass;
        }

        public void setLocalClass(boolean localClass) {
            this.localClass = localClass;
        }

        public boolean isAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(boolean anonymousClass) {
            this.anonymousClass = anonymousClass;
        }
    }
}

