/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.guvnor.m2repo.backend.server.helpers.FormData;
import org.guvnor.m2repo.backend.server.helpers.PomModelResolver;
import org.guvnor.m2repo.utils.FileNameUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPostHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpPostHelper.class);
    @Inject
    private ExtendedM2RepoService m2RepoService;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData formData = this.extractFormData(request);
        String result = this.upload(formData);
        response.getWriter().write(result);
    }

    private FormData extractFormData(HttpServletRequest request) throws IOException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        FormData data = new FormData();
        GAV emptyGAV = new GAV();
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (!item.isFormField()) {
                    data.setFile(item);
                }
                if (item.isFormField() && item.getFieldName().equals("groupId")) {
                    emptyGAV.setGroupId(item.getString());
                    continue;
                }
                if (item.isFormField() && item.getFieldName().equals("artifactId")) {
                    emptyGAV.setArtifactId(item.getString());
                    continue;
                }
                if (!item.isFormField() || !item.getFieldName().equals("version")) continue;
                emptyGAV.setVersion(item.getString());
            }
            if (this.isNullOrEmpty(emptyGAV.getGroupId()) || this.isNullOrEmpty(emptyGAV.getArtifactId()) || this.isNullOrEmpty(emptyGAV.getVersion())) {
                data.setGav(null);
            } else {
                data.setGav(emptyGAV);
            }
            return data;
        }
        catch (FileUploadException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String upload(FormData formData) throws IOException {
        FileItem fileItem = formData.getFile();
        if (fileItem == null) {
            throw new IOException("No file selected.");
        }
        String fileName = fileItem.getName();
        if (this.isNullOrEmpty(fileName)) {
            throw new IOException("No file selected.");
        }
        if (FileNameUtilities.isJar((String)fileName) || FileNameUtilities.isKJar((String)fileName)) {
            return this.uploadJar(formData);
        }
        if (FileNameUtilities.isPom((String)fileName)) {
            return this.uploadPom(formData);
        }
        throw new IOException("Unsupported file type selected.");
    }

    private String uploadJar(FormData formData) throws IOException {
        GAV gav = formData.getGav();
        InputStream jarStream = null;
        try {
            String pomModel;
            jarStream = formData.getFile().getInputStream();
            if (gav == null) {
                String version;
                String artifactId;
                String groupId;
                if (!jarStream.markSupported()) {
                    jarStream = new BufferedInputStream(jarStream);
                }
                jarStream.mark(jarStream.available());
                pomModel = PomModelResolver.resolveFromJar(jarStream);
                if (pomModel != null) {
                    groupId = pomModel.getReleaseId().getGroupId();
                    artifactId = pomModel.getReleaseId().getArtifactId();
                    version = pomModel.getReleaseId().getVersion();
                    if (this.isNullOrEmpty(groupId) || this.isNullOrEmpty(artifactId) || this.isNullOrEmpty(version)) {
                        String string = "MISSING_POM";
                        return string;
                    }
                } else {
                    String string = "MISSING_POM";
                    return string;
                }
                gav = new GAV(groupId, artifactId, version);
                jarStream.reset();
            }
            this.m2RepoService.deployJar(jarStream, gav);
            pomModel = "OK";
            return pomModel;
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
            throw ExceptionUtilities.handleException((Exception)ioe);
        }
        finally {
            if (jarStream != null) {
                jarStream.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String uploadPom(FormData formData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static class ReusableInputStream
    extends BufferedInputStream {
        public ReusableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }

        void doClose() throws IOException {
            super.close();
        }
    }
}

