/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.util.PackageImportHelper;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.AttachmentAssetImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.FactModelImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.GuidedDecisionTableImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.GuidedEditorImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.GuidedScoreCardImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.PlainTextAssetImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.PlainTextAssetWithPackagePropertyImporter;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.TestScenarioImporter;
import org.drools.workbench.jcr2vfsmigration.xml.format.ModulesXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlAssetsFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.Modules;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.AttachmentAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.BusinessRuleAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.GuidedDecisionTableAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.PlainTextAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAssets;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ApplicationScoped
public class ModuleAssetImporter {
    @Inject
    private Paths paths;
    @Inject
    private FileManager fileManager;
    @Inject
    private MigrationPathManager migrationPathManager;
    @Inject
    private PackageImportHelper packageImportHelper;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FactModelImporter factModelImporter;
    @Inject
    private ProjectService projectService;
    @Inject
    private PlainTextAssetImporter plainTextAssetImporter;
    @Inject
    private PlainTextAssetWithPackagePropertyImporter plainTextAssetWithPackagePropertyImporter;
    @Inject
    private GuidedScoreCardImporter guidedScoreCardImporter;
    @Inject
    private GuidedEditorImporter guidedEditorImporter;
    @Inject
    private GuidedDecisionTableImporter guidedDecisionTableImporter;
    @Inject
    private TestScenarioImporter testScenarioImporter;
    @Inject
    private AttachmentAssetImporter attachmentAssetImporter;
    private ModulesXmlFormat modulesXmlFormat = new ModulesXmlFormat();
    private XmlAssetsFormat xmlAssetsFormat = new XmlAssetsFormat();

    public void importAll() {
        System.out.println("  Module import started");
        Document xml = null;
        try {
            File modulesXmlFile = this.fileManager.getModulesExportFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xml = db.parse(modulesXmlFile);
            NodeList children = xml.getChildNodes();
            if (children.getLength() > 1) {
                throw new Exception("Wrong modules.xml format");
            }
            Modules modules = this.modulesXmlFormat.parse(children.item(0));
            Iterator moduleIterator = modules.getModules().iterator();
            while (moduleIterator.hasNext()) {
                this.importModule((Module)moduleIterator.next());
            }
            this.importModule(modules.getGlobalModule());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("  Module import ended");
    }

    private void importModule(Module module) {
        String normalizedModuleName = module.getNormalizedPackageName();
        String[] nameSplit = normalizedModuleName.split("\\.");
        StringBuilder groupIdBuilder = new StringBuilder();
        groupIdBuilder.append(nameSplit[0]);
        for (int i = 1; i < nameSplit.length - 1; ++i) {
            groupIdBuilder.append(".");
            groupIdBuilder.append(nameSplit[i]);
        }
        String groupId = groupIdBuilder.toString();
        String artifactId = nameSplit[nameSplit.length - 1];
        GAV gav = new GAV(groupId, artifactId, "0.0.1");
        POM pom = new POM(gav);
        pom.setName(normalizedModuleName);
        org.uberfire.backend.vfs.Path modulePath = this.migrationPathManager.generateRootPath();
        try {
            this.projectService.newProject(this.makeRepository(modulePath), pom, "http://localhost");
        }
        catch (GAVAlreadyExistsException gae) {
            System.out.println("Project's GAV [" + pom.getGav().toString() + "] already exists at [" + this.toString(gae.getRepositories()) + "]");
        }
        this.importAssets(module);
        String globals = module.getGlobalsString();
        if (globals == null || "".equals(globals)) {
            return;
        }
        org.uberfire.backend.vfs.Path path = this.migrationPathManager.generatePathForGlobal(module);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        String contentWithImport = this.packageImportHelper.assertPackageImportDRL(globals, module.getPackageHeaderInfo(), path);
        String contentWithPackage = this.packageImportHelper.assertPackageName(contentWithImport, null);
        this.ioService.write(nioPath, contentWithPackage, (Map)null, new OpenOption[]{new CommentedOption(module.getLastContributor(), null, module.getCheckinComment(), module.getLastModified())});
    }

    private String toString(Set<MavenRepositoryMetadata> repositories) {
        StringBuilder sb = new StringBuilder();
        for (MavenRepositoryMetadata md : repositories) {
            sb.append(md.getId()).append(" : ").append(md.getUrl()).append(" : ").append(md.getSource()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    private void importAssets(Module module) {
        System.out.println("  Assert import for module " + module.getName() + " started");
        Document xml = null;
        try {
            File assetsXmlFile = this.fileManager.getAssetExportFile(module.getAssetExportFileName());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xml = db.parse(assetsXmlFile);
            NodeList rootNodeList = xml.getChildNodes();
            if (rootNodeList.getLength() > 1) {
                throw new Exception("Wrong asset file xml format");
            }
            Node assetsNode = rootNodeList.item(0);
            XmlAssets xmlAssets = this.xmlAssetsFormat.parse(assetsNode);
            for (XmlAsset xmlAsset : xmlAssets.getAssets()) {
                if (xmlAsset == null) {
                    System.out.println("    WARNING: skipping null asset in import");
                    continue;
                }
                System.out.printf("    Importing asset '%s.%s'.\n", xmlAsset.getName(), xmlAsset.getAssetType());
                this.importAssetHistory(module, xmlAsset);
                this.importAsset(module, xmlAsset, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("  Assert import for module " + module.getName() + " ended");
    }

    private org.uberfire.backend.vfs.Path importAsset(Module module, XmlAsset xmlAsset, org.uberfire.backend.vfs.Path previousVersionPath) {
        switch (xmlAsset.getAssetType()) {
            case DRL_MODEL: {
                return this.factModelImporter.importAsset(module, (DataModelAsset)xmlAsset, previousVersionPath);
            }
            case ENUMERATION: 
            case DSL: 
            case DSL_TEMPLATE_RULE: 
            case RULE_TEMPLATE: 
            case FORM_DEFINITION: 
            case SPRING_CONTEXT: 
            case SERVICE_CONFIG: 
            case WORKITEM_DEFINITION: 
            case CHANGE_SET: 
            case RULE_FLOW_RF: 
            case BPMN_PROCESS: 
            case BPMN2_PROCESS: 
            case FTL: 
            case JSON: 
            case FW: {
                return this.plainTextAssetImporter.importAsset(module, (PlainTextAsset)xmlAsset, previousVersionPath);
            }
            case DRL: 
            case FUNCTION: {
                return this.plainTextAssetWithPackagePropertyImporter.importAsset(module, (PlainTextAsset)xmlAsset, previousVersionPath);
            }
            case DECISION_SPREADSHEET_XLS: 
            case SCORECARD_SPREADSHEET_XLS: 
            case PNG: 
            case GIF: 
            case JPG: 
            case PDF: 
            case DOC: 
            case ODT: {
                return this.attachmentAssetImporter.importAsset(module, (AttachmentAsset)xmlAsset, previousVersionPath);
            }
            case SCORECARD_GUIDED: {
                return this.guidedScoreCardImporter.importAsset(module, (PlainTextAsset)xmlAsset, previousVersionPath);
            }
            case BUSINESS_RULE: {
                return this.guidedEditorImporter.importAsset(module, (BusinessRuleAsset)xmlAsset, previousVersionPath);
            }
            case DECISION_TABLE_GUIDED: {
                return this.guidedDecisionTableImporter.importAsset(module, (GuidedDecisionTableAsset)xmlAsset, previousVersionPath);
            }
            case TEST_SCENARIO: {
                return this.testScenarioImporter.importAsset(module, (PlainTextAsset)xmlAsset, previousVersionPath);
            }
        }
        return this.attachmentAssetImporter.importAsset(module, (AttachmentAsset)xmlAsset, previousVersionPath);
    }

    private void importAssetHistory(Module module, XmlAsset xmlAsset) {
        org.uberfire.backend.vfs.Path previousVersionPath = null;
        XmlAssets history = xmlAsset.getAssetHistory();
        if (history == null || history.getAssets().size() == 0) {
            return;
        }
        for (XmlAsset hAsset : history.getAssets()) {
            previousVersionPath = this.importAsset(module, hAsset, previousVersionPath);
        }
    }

    private Repository makeRepository(final org.uberfire.backend.vfs.Path repositoryRoot) {
        return new GitRepository(){

            public org.uberfire.backend.vfs.Path getRoot() {
                return repositoryRoot;
            }
        };
    }
}

