/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.events.TemplateVariablesChangedEvent;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;

public class ActionSetFieldWidget
extends RuleModellerWidget {
    private final ActionSetField model;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletions;
    private String variableClass;
    private boolean readOnly;
    private boolean isFactTypeKnown;

    public ActionSetFieldWidget(RuleModeller mod, EventBus eventBus, ActionSetField set, Boolean readOnly) {
        super(mod, eventBus);
        this.model = set;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        if (completions.isGlobalVariable(set.variable)) {
            this.fieldCompletions = completions.getFieldCompletionsForGlobalVariable(set.variable);
            this.variableClass = completions.getGlobalVariable(set.variable);
        } else {
            String type = mod.getModel().getLHSBindingType(set.variable);
            if (type != null) {
                this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, type);
                this.variableClass = type;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRHSBoundFact(set.variable);
                if (patternRhs != null) {
                    this.fieldCompletions = completions.getFieldCompletions(FieldAccessorsAndMutators.MUTATOR, patternRhs.factType);
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                }
            }
        }
        if (this.variableClass == null) {
            readOnly = true;
            ErrorPopup.showMessage((String)Constants.INSTANCE.CouldNotFindTheTypeForVariable0(set.variable));
        }
        this.isFactTypeKnown = completions.containsFactType(this.variableClass);
        this.readOnly = readOnly == null ? !this.isFactTypeKnown : readOnly;
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        for (int i = 0; i < this.model.fieldValues.length; ++i) {
            ActionFieldValue val = this.model.fieldValues[i];
            this.layout.setWidget(i, 0, this.getSetterLabel());
            this.layout.setWidget(i, 1, this.fieldSelector(val));
            this.layout.setWidget(i, 2, this.valueEditor(val));
            final int idx = i;
            Image remove = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
            remove.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)Constants.INSTANCE.RemoveThisItem())) {
                        ActionSetFieldWidget.this.model.removeField(idx);
                        ActionSetFieldWidget.this.setModified(true);
                        ActionSetFieldWidget.this.getModeller().refreshWidget();
                        TemplateVariablesChangedEvent tvce = new TemplateVariablesChangedEvent(ActionSetFieldWidget.this.getModeller().getModel());
                        ActionSetFieldWidget.this.getEventBus().fireEventFromSource((GwtEvent)tvce, (Object)ActionSetFieldWidget.this.getModeller().getModel());
                    }
                }
            });
            if (this.readOnly) continue;
            this.layout.setWidget(i, 3, (Widget)remove);
        }
        if (this.model.fieldValues.length == 0) {
            HorizontalPanel h = new HorizontalPanel();
            h.add(this.getSetterLabel());
            if (!this.readOnly) {
                Image image = GuvnorImages.INSTANCE.Edit();
                image.setAltText(Constants.INSTANCE.AddFirstNewField());
                image.setTitle(Constants.INSTANCE.AddFirstNewField());
                image.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent sender) {
                        ActionSetFieldWidget.this.showAddFieldPopup(sender);
                    }
                });
                h.add((Widget)image);
            }
            this.layout.setWidget(0, 0, (Widget)h);
        }
    }

    private Widget getSetterLabel() {
        String type;
        ClickHandler clk = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionSetFieldWidget.this.showAddFieldPopup(event);
            }
        };
        String modifyType = "set";
        if (this.model instanceof ActionUpdateField) {
            modifyType = "modify";
        }
        String descFact = (type = this.getModeller().getModel().getLHSBindingType(this.model.variable)) != null ? type + " <b>[" + this.model.variable + "]</b>" : this.model.variable;
        String sl = Constants.INSTANCE.setterLabel(HumanReadable.getActionDisplayName(modifyType), descFact);
        return new ClickableLabel(sl, clk, !this.readOnly);
    }

    protected void showAddFieldPopup(ClickEvent w) {
        final SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        final FormStylePopup popup = new FormStylePopup(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.AddAField());
        final ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletions.length; ++i) {
            box.addItem(this.fieldCompletions[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(Constants.INSTANCE.AddField(), (Widget)box);
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fieldName = box.getItemText(box.getSelectedIndex());
                String fieldType = completions.getFieldType(ActionSetFieldWidget.this.variableClass, fieldName);
                ActionSetFieldWidget.this.model.addFieldValue(new ActionFieldValue(fieldName, "", fieldType));
                ActionSetFieldWidget.this.setModified(true);
                ActionSetFieldWidget.this.getModeller().refreshWidget();
                popup.hide();
            }
        });
        popup.show();
    }

    private Widget valueEditor(ActionFieldValue val) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String type = "";
        if (completions.isGlobalVariable(this.model.variable)) {
            type = completions.getGlobalVariable(this.model.variable);
        } else {
            type = this.getModeller().getModel().getLHSBindingType(this.model.variable);
            if (type == null && !this.readOnly) {
                type = this.getModeller().getModel().getRHSBoundFact((String)this.model.variable).factType;
            }
        }
        DropDownData enums = completions.getEnums(type, val.field, (FieldNature[])this.model.fieldValues);
        ActionValueEditor actionValueEditor = new ActionValueEditor(val, enums, this.getModeller(), this.getEventBus(), val.type, this.readOnly);
        actionValueEditor.setOnChangeCommand(new Command(){

            public void execute() {
                ActionSetFieldWidget.this.setModified(true);
            }
        });
        return actionValueEditor;
    }

    private Widget fieldSelector(ActionFieldValue val) {
        return new SmallLabel(val.field);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }
}

