/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

abstract class TestScenarioButton
extends ImageButton {
    protected final Scenario scenario;
    protected final ScenarioWidget parent;
    protected final SuggestionCompletionEngine suggestionCompletionEngine;
    protected final ExecutionTrace previousEx;

    public TestScenarioButton(Image img, String tooltip, ExecutionTrace previousEx, Scenario scenario, ScenarioWidget scenarioWidget) {
        super(img, tooltip);
        this.previousEx = previousEx;
        this.scenario = scenario;
        this.parent = scenarioWidget;
        this.suggestionCompletionEngine = scenarioWidget.suggestionCompletionEngine;
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TestScenarioButtonPopup pop = TestScenarioButton.this.getPopUp();
                pop.show();
            }
        });
    }

    protected abstract TestScenarioButtonPopup getPopUp();

    protected abstract class TestScenarioButtonPopup
    extends FormStylePopup {
        public TestScenarioButtonPopup(Image image, String text) {
            super(image, text);
        }

        protected abstract class ListBoxBasePanel
        extends BasePanel<ListBox> {
            public ListBoxBasePanel(List<String> listItems) {
                this.fillWidget(listItems);
            }

            public ListBoxBasePanel(String[] listItems) {
                ArrayList<String> list = new ArrayList<String>();
                for (String string : listItems) {
                    list.add(string);
                }
                this.fillWidget(list);
            }

            protected void fillWidget(List<String> listItems) {
                for (String item : listItems) {
                    ((ListBox)this.valueWidget).addItem(item);
                }
            }

            @Override
            public ListBox getWidget() {
                return new ListBox();
            }
        }

        protected abstract class BasePanel<T extends Widget>
        extends HorizontalPanel {
            protected final T valueWidget;
            protected final Button add = new Button(Constants.INSTANCE.Add());

            public BasePanel() {
                this.valueWidget = this.getWidget();
                this.addAddButtonClickHandler();
                this.initWidgets();
            }

            protected void initWidgets() {
                this.add((Widget)this.valueWidget);
                this.add((Widget)this.add);
            }

            protected void addAddButtonClickHandler() {
                this.add.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        TestScenarioButton.this.scenario.insertBetween((Fixture)TestScenarioButton.this.previousEx, BasePanel.this.getFixture());
                        TestScenarioButton.this.parent.renderEditor();
                        TestScenarioButtonPopup.this.hide();
                    }
                });
            }

            public abstract T getWidget();

            public abstract Fixture getFixture();
        }
    }
}

