/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.context;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.context.ProjectContextChangeHandle;
import org.guvnor.common.services.project.context.ProjectContextChangeHandler;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.UpdatedOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;

@ApplicationScoped
public class ProjectContext {
    private OrganizationalUnit activeOrganizationalUnit;
    private Repository activeRepository;
    private String activeBranch;
    private Project activeProject;
    private Package activePackage;
    private Map<ProjectContextChangeHandle, ProjectContextChangeHandler> changeHandlers = new HashMap<ProjectContextChangeHandle, ProjectContextChangeHandler>();
    private Event<ProjectContextChangeEvent> contextChangeEvent;

    public ProjectContext() {
    }

    @Inject
    public ProjectContext(Event<ProjectContextChangeEvent> contextChangeEvent) {
        this.contextChangeEvent = contextChangeEvent;
    }

    public void onRepositoryRemoved(@Observes RepositoryRemovedEvent event) {
        if (event.getRepository().equals(this.activeRepository)) {
            this.contextChangeEvent.fire((Object)new ProjectContextChangeEvent(this.activeOrganizationalUnit));
        }
    }

    public void onOrganizationalUnitUpdated(@Observes UpdatedOrganizationalUnitEvent event) {
        this.setActiveOrganizationalUnit(event.getOrganizationalUnit());
    }

    public void onProjectContextChanged(@Observes ProjectContextChangeEvent event) {
        this.setActiveOrganizationalUnit(event.getOrganizationalUnit());
        this.setActiveRepository(event.getRepository());
        this.setActiveBranch(event.getBranch());
        this.setActiveProject(event.getProject());
        this.setActivePackage(event.getPackage());
        for (ProjectContextChangeHandler handler : this.changeHandlers.values()) {
            handler.onChange();
        }
    }

    public void setActiveOrganizationalUnit(OrganizationalUnit activeOrganizationalUnit) {
        this.activeOrganizationalUnit = activeOrganizationalUnit;
    }

    public OrganizationalUnit getActiveOrganizationalUnit() {
        return this.activeOrganizationalUnit;
    }

    public void setActiveRepository(Repository activeRepository) {
        this.activeRepository = activeRepository;
    }

    public String getActiveBranch() {
        return this.activeBranch;
    }

    public void setActiveBranch(String activeBranch) {
        this.activeBranch = activeBranch;
    }

    public Repository getActiveRepository() {
        return this.activeRepository;
    }

    public Project getActiveProject() {
        return this.activeProject;
    }

    public void setActiveProject(Project activeProject) {
        this.activeProject = activeProject;
    }

    public Package getActivePackage() {
        return this.activePackage;
    }

    public void setActivePackage(Package activePackage) {
        this.activePackage = activePackage;
    }

    public ProjectContextChangeHandle addChangeHandler(ProjectContextChangeHandler changeHandler) {
        ProjectContextChangeHandle handle = new ProjectContextChangeHandle();
        this.changeHandlers.put(handle, changeHandler);
        return handle;
    }

    public void removeChangeHandler(ProjectContextChangeHandle projectContextChangeHandle) {
        this.changeHandlers.remove(projectContextChangeHandle);
    }
}

