/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.FormContentModel;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.UserSecurityContext;

public class FormEditor
extends DirtyableComposite
implements SaveEventListener,
EditorWidget {
    private String modelUUID;
    private Asset asset;
    private Frame frame;
    private String[] username = new String[]{null};
    private final RepositoryServiceAsync repoService;

    public FormEditor(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus bus) {
        this.asset = asset;
        this.modelUUID = asset.getUuid();
        clientFactory.getSecurityService().getCurrentUser(new AsyncCallback<UserSecurityContext>(){

            public void onSuccess(UserSecurityContext result) {
                ((FormEditor)FormEditor.this).username[0] = result.getUserName();
            }

            public void onFailure(Throwable caught) {
            }
        });
        this.repoService = clientFactory.getRepositoryService();
        this.initWidgets();
    }

    private void initWidgets() {
        String name = "/" + ApplicationPreferences.getFormBuilderContext() + "/embed?uuid=" + this.modelUUID + "&profile=" + ApplicationPreferences.getFormBuilderProfile();
        if (this.username[0] != null) {
            name = name + "&username=" + this.username[0];
        }
        this.frame = new Frame(name);
        this.frame.getElement().setAttribute("domain", Document.get().getDomain());
        this.frame.setWidth("100%");
        this.frame.setHeight("580px");
        this.initWidget((Widget)this.frame);
        this.setWidth("100%");
        this.setHeight("580px");
    }

    private final native String callSave(IFrameElement var1);

    @Override
    public void onSave(SaveCommand saveCommand) {
        try {
            String json = this.callSave((IFrameElement)this.frame.getElement());
            if (json == null || "".equals(json.trim())) {
                Window.alert((String)"Warning: form is empty from guvnor perspective.");
            }
            if (this.asset.getContent() == null) {
                this.asset.setContent(new FormContentModel());
            }
            ((FormContentModel)this.asset.getContent()).setJson(json);
        }
        catch (Exception e) {
            GWT.log((String)"JSNI method callSave() threw an exception:", (Throwable)e);
            Window.alert((String)("JSNI method callSave() threw an exception: " + e));
        }
        saveCommand.save();
    }

    @Override
    public void onAfterSave() {
        String json = ((FormContentModel)this.asset.getContent()).getJson();
        this.exportFormToFtl(json);
    }

    private void exportFormToFtl(String jsonForm) {
        String url = ApplicationPreferences.getFormBuilderURL() + "/" + ApplicationPreferences.getFormBuilderContext() + "/exportTemplate?uuid=" + this.modelUUID + "&profile=jbpm";
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
        builder.setCallback(new RequestCallback(){

            public void onResponseReceived(Request request, Response response) {
                if (response.getStatusCode() == 500) {
                    Window.alert((String)"there was a problem with the template creation. Please check the server logs");
                }
            }

            public void onError(Request request, Throwable exception) {
                GWT.log((String)"template creation threw an exception:", (Throwable)exception);
                Window.alert((String)("template creation threw an exception: " + exception));
            }
        });
        try {
            builder.send();
        }
        catch (RequestException e) {
            GWT.log((String)"template creator invoke threw an exception:", (Throwable)e);
            Window.alert((String)("template creator invoke threw an exception: " + (Object)((Object)e)));
        }
    }
}

