/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.builder.AssemblerBase;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.DSLLoader;
import org.drools.guvnor.server.builder.DeclaredTypesSorter;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.lang.descr.PackageDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepositoryException;

abstract class PackageAssemblerBase
extends AssemblerBase {
    protected BRMSPackageBuilder builder;
    protected StringBuilder src;

    PackageAssemblerBase() {
    }

    public void createBuilder() {
        this.builder = new BRMSPackageBuilder(this.moduleItem);
    }

    @Override
    public void compile() {
    }

    @Override
    public byte[] getCompiledBinary() {
        return null;
    }

    @Override
    public String getBinaryExtension() {
        return "pkg";
    }

    @Override
    public String getCompiledSource() {
        return null;
    }

    protected void buildAsset(AssetItem asset) {
        ContentHandler contentHandler = ContentManager.getHandler(asset.getFormat());
        if (contentHandler instanceof ICompilable && !asset.getDisabled()) {
            try {
                this.compile(asset, (ICompilable)((Object)contentHandler));
            }
            catch (DroolsParserException e) {
                this.errorLogger.addError(asset, e.getMessage());
                throw new RulesRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                this.errorLogger.addError(asset, e.getMessage());
            }
        }
    }

    private void compile(AssetItem asset, ICompilable contentHandler) throws DroolsParserException, IOException {
        contentHandler.compile(this.builder, asset, this.errorLogger);
        if (this.builder.hasErrors()) {
            this.logErrors(asset);
        }
    }

    protected boolean setUpPackage() {
        this.builder.addPackage(new PackageDescr(this.moduleItem.getName()));
        String packageHeader = DroolsHeader.getDroolsHeader(this.moduleItem);
        this.loadPackageHeaderToBuilder(DroolsHeader.getPackageHeaderImports(packageHeader));
        this.loadDeclaredTypesToBuilder();
        this.loadPackageHeaderToBuilder(DroolsHeader.getPackageHeaderGlobals(packageHeader));
        this.loadPackageHeaderToBuilder(DroolsHeader.getPackageHeaderMiscellaneous(packageHeader));
        if (this.doesPackageBuilderHaveAnyErrors()) {
            return false;
        }
        this.loadDSLFiles();
        this.loadFunctionsToBuilder();
        return !this.errorLogger.hasErrors();
    }

    private boolean doesPackageBuilderHaveAnyErrors() {
        if (this.builder.hasErrors()) {
            this.recordBuilderErrors(this.moduleItem.getFormat(), this.moduleItem.getName(), this.moduleItem.getUUID(), true, false);
            return true;
        }
        return false;
    }

    protected void loadDSLFiles() {
        this.builder.setDSLFiles(DSLLoader.loadDSLMappingFiles(this.getAssetItemIterator("dsl"), new BRMSPackageBuilder.DSLErrorEvent(){

            @Override
            public void recordError(AssetItem asset, String message) {
                PackageAssemblerBase.this.errorLogger.addError(asset, message);
            }
        }));
    }

    protected void loadFunctionsToSource() {
        Iterator<AssetItem> assetItemIterator = this.getAssetItemIterator("function");
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            if (assetItem.isArchived() || assetItem.getDisabled()) continue;
            this.src.append(assetItem.getContent()).append("\n\n");
        }
    }

    protected void loadFunctionsToBuilder() {
        Iterator<AssetItem> assetItemIterator = this.getAssetItemIterator("function");
        StringBuilder stringBuilder = new StringBuilder();
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            if (assetItem.getDisabled()) continue;
            stringBuilder.append(assetItem.getContent());
        }
        try {
            this.addDrl(stringBuilder.toString());
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        catch (DroolsParserException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        if (this.builder.hasErrors()) {
            this.searchTheFunctionWithAnError();
        }
    }

    private void searchTheFunctionWithAnError() {
        this.builder.clearErrors();
        Iterator<AssetItem> functionsIterator = this.getAssetItemIterator("function");
        while (functionsIterator.hasNext()) {
            AssetItem function = functionsIterator.next();
            if (function.getDisabled()) continue;
            try {
                this.addDrl(function.getContent());
            }
            catch (IOException e) {
                this.errorLogger.addError(function, "IOException: " + e.getMessage());
            }
            catch (DroolsParserException e) {
                this.errorLogger.addError(this.moduleItem, "Parser exception: " + e.getMessage());
            }
            if (!this.builder.hasErrors()) continue;
            this.logErrors(function);
        }
    }

    protected void loadPackageHeaderToBuilder(String drl) {
        try {
            this.addDrl(drl);
        }
        catch (IOException e) {
            this.errorLogger.addError(this.moduleItem, "IOException: " + e.getMessage());
        }
        catch (DroolsParserException e) {
            this.errorLogger.addError(this.moduleItem, "Parser exception: " + e.getMessage());
        }
    }

    protected void loadHeaderToSource() {
        this.src.append("package ").append(this.moduleItem.getName()).append("\n\n");
        String packageHeader = DroolsHeader.getDroolsHeader(this.moduleItem);
        this.src.append(DroolsHeader.getPackageHeaderImports(packageHeader)).append("\n");
        this.loadDeclaredTypesToSource();
        this.src.append(DroolsHeader.getPackageHeaderGlobals(packageHeader)).append("\n");
        this.src.append(DroolsHeader.getPackageHeaderMiscellaneous(packageHeader)).append("\n");
    }

    protected void loadDeclaredTypesToSource() {
        ArrayList<AssetItem> assets = new ArrayList<AssetItem>();
        DeclaredTypesSorter sorter = new DeclaredTypesSorter();
        Iterator<AssetItem> assetItemIterator = this.getAssetItemIterator("model.drl");
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            if (assetItem.isArchived() || assetItem.getDisabled()) continue;
            assets.add(assetItem);
        }
        List<DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation> sortedAssets = sorter.sort(assets);
        for (DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation dt : sortedAssets) {
            this.src.append(dt.getDrl()).append("\n\n");
        }
    }

    protected void loadDeclaredTypesToBuilder() {
        ArrayList<AssetItem> assets = new ArrayList<AssetItem>();
        DeclaredTypesSorter sorter = new DeclaredTypesSorter();
        Iterator<AssetItem> assetItemIterator = this.getAssetItemIterator("model.drl");
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = assetItemIterator.next();
            if (assetItem.getDisabled()) continue;
            assets.add(assetItem);
        }
        List<DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation> sortedAssets = sorter.sort(assets);
        for (DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation dt : sortedAssets) {
            try {
                this.addDrl(dt.getDrl());
            }
            catch (DroolsParserException dpe) {
                this.errorLogger.addError(dt.getOwningAssetItem(), "Parser exception: " + dpe.getMessage());
            }
            catch (IOException dpe) {
                this.errorLogger.addError(dt.getOwningAssetItem(), "IOException: " + dpe.getMessage());
            }
        }
    }

    private boolean isEmpty(String content) {
        return content == null || content.trim().length() == 0;
    }

    @Override
    public boolean isModuleConfigurationInError() {
        return this.errorLogger.hasErrors() && this.errorLogger.getErrors().get(0).isModuleItem();
    }

    private void addDrl(String drl) throws IOException, DroolsParserException {
        if (this.isEmpty(drl)) {
            return;
        }
        this.builder.addPackageFromDrl(new StringReader(drl));
    }

    private void recordBuilderErrors(String format, String name, String uuid, boolean isPackageItem, boolean isAssetItem) {
        for (DroolsError droolsError : this.builder.getErrors().getErrors()) {
            this.errorLogger.addError(droolsError.getMessage(), format, name, uuid, isPackageItem, isAssetItem);
        }
        this.builder.clearErrors();
    }

    private void logErrors(AssetItem asset) {
        this.recordBuilderErrors(asset.getFormat(), asset.getName(), asset.getUUID(), false, true);
    }
}

