/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.HashMap;
import java.util.Map;

enum AssetEditorConfigElement {
    UNKNOWN(null),
    ASSET_EDITORS("asseteditors"),
    ASSET_EDITOR("asseteditor"),
    FORMAT("format"),
    CLASS("class"),
    TITLE("title"),
    ICON("icon");

    private final String name;
    private static final Map<String, AssetEditorConfigElement> MAP;

    private AssetEditorConfigElement(String name) {
        this.name = name;
    }

    static AssetEditorConfigElement forName(String localName) {
        AssetEditorConfigElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, AssetEditorConfigElement> map = new HashMap<String, AssetEditorConfigElement>();
        for (AssetEditorConfigElement element : AssetEditorConfigElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

