/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.Set;
import org.kie.workbench.common.services.refactoring.model.index.terms.IndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

class TermsCheck {
    TermsCheck() {
    }

    static void checkTermsMatch(Set<ValueIndexTerm> queryTerms, Set<IndexTerm> namedQueryTerms) {
        for (IndexTerm indexTerm : namedQueryTerms) {
            if (TermsCheck.checkValueTermsContainsRequiredTerm(queryTerms, indexTerm)) continue;
            throw new IllegalArgumentException("Expected IndexTerm '" + indexTerm.getTerm() + "' was not found.");
        }
        for (ValueIndexTerm valueIndexTerm : queryTerms) {
            if (TermsCheck.requiredTermsContainsValueTerm(namedQueryTerms, valueIndexTerm)) continue;
        }
    }

    static boolean checkValueTermsContainsRequiredTerm(Set<ValueIndexTerm> providedTerms, IndexTerm requiredTerm) {
        for (ValueIndexTerm valueTerm : providedTerms) {
            if (!valueTerm.getTerm().equals(requiredTerm.getTerm())) continue;
            return true;
        }
        return false;
    }

    static boolean requiredTermsContainsValueTerm(Set<IndexTerm> requiredTerms, ValueIndexTerm providedTerm) {
        for (IndexTerm valueTerm : requiredTerms) {
            if (!valueTerm.getTerm().equals(providedTerm.getTerm())) continue;
            return true;
        }
        return false;
    }
}

