/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.session;

import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.seam.security.events.SessionInvalidatedEvent;
import org.jboss.seam.security.session.Session;
import org.jboss.seam.security.session.SessionImpl;
import org.jboss.seam.security.session.SessionManager;
import org.jboss.seam.security.session.SessionStore;
import org.jboss.solder.servlet.event.Destroyed;
import org.jboss.solder.servlet.event.Initialized;

public class SessionManagerImpl
implements SessionManager {
    @Inject
    private SessionStore sessionStore;
    @Inject
    private BeanManager beanManager;

    public void register(Session session) {
        this.sessionStore.persist(session);
    }

    public Session unregister(String id) {
        Session session = this.sessionStore.findById(id);
        if (session != null) {
            this.sessionStore.remove(session);
        }
        return session;
    }

    public void invalidateSession(String sessionId) {
        Session session = this.sessionStore.findById(sessionId);
        if (session != null) {
            session.invalidate();
            this.sessionStore.persist(session);
        }
    }

    public boolean isSessionValid(String sessionId) {
        Session session = this.sessionStore.findById(sessionId);
        if (session != null) {
            return session.isValid();
        }
        return false;
    }

    void sessionInit(@Observes @Initialized HttpSession httpSession, HttpServletRequest request) throws UnknownHostException {
        SessionImpl session = new SessionImpl(httpSession, InetAddress.getByName(request.getRemoteAddr()));
        this.register(session);
    }

    void sessionDestroyed(@Observes @Destroyed HttpSession session) {
        this.unregister(session.getId());
    }

    void requestInit(@Observes @Initialized HttpServletRequest request) {
        Session session;
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (session = this.sessionStore.findById(httpSession.getId())) != null) {
            if (!session.isValid()) {
                httpSession.invalidate();
                this.beanManager.fireEvent((Object)new SessionInvalidatedEvent(session), new Annotation[0]);
            } else {
                session.updateSessionValues((Object)httpSession);
                this.sessionStore.persist(session);
            }
        }
    }
}

