/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.events.NewPackageEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.project.ProjectFactory;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectServiceCore;
import org.guvnor.common.services.workingset.client.model.WorkingSetSettings;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

public abstract class AbstractProjectService<T extends Project>
implements ProjectServiceCore<T>,
ProjectFactory<T> {
    protected IOService ioService;
    protected POMService pomService;
    private ConfigurationService configurationService;
    private ConfigurationFactory configurationFactory;
    protected Event<NewProjectEvent> newProjectEvent;
    protected Event<NewPackageEvent> newPackageEvent;
    private Event<RenameProjectEvent> renameProjectEvent;
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache;
    private AuthorizationManager authorizationManager;
    private BackwardCompatibleUtil backward;
    protected CommentedOptionFactory commentedOptionFactory;
    protected ResourceResolver resourceResolver;
    protected SessionInfo sessionInfo;

    protected AbstractProjectService() {
    }

    public AbstractProjectService(IOService ioService, POMService pomService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<NewProjectEvent> newProjectEvent, Event<NewPackageEvent> newPackageEvent, Event<RenameProjectEvent> renameProjectEvent, Event<InvalidateDMOProjectCacheEvent> invalidateDMOCache, SessionInfo sessionInfo, AuthorizationManager authorizationManager, BackwardCompatibleUtil backward, CommentedOptionFactory commentedOptionFactory, ResourceResolver resourceResolver) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.configurationService = configurationService;
        this.configurationFactory = configurationFactory;
        this.newProjectEvent = newProjectEvent;
        this.newPackageEvent = newPackageEvent;
        this.renameProjectEvent = renameProjectEvent;
        this.invalidateDMOCache = invalidateDMOCache;
        this.authorizationManager = authorizationManager;
        this.backward = backward;
        this.commentedOptionFactory = commentedOptionFactory;
        this.resourceResolver = resourceResolver;
        this.sessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public WorkingSetSettings loadWorkingSetConfig(org.uberfire.backend.vfs.Path project) {
        return new WorkingSetSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Project> getProjects(Repository repository, String branch) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        org.uberfire.backend.vfs.Path repositoryRoot = repository.getBranchRoot(branch);
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot));
        try {
            for (Path nioRepositoryPath : nioRepositoryPaths) {
                org.uberfire.backend.vfs.Path projectPath;
                Object project;
                if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = this.resourceResolver.resolveProject(projectPath = Paths.convert((Path)nioRepositoryPath))) == null || !this.authorizationManager.authorize(project, this.sessionInfo.getIdentity())) continue;
                POM projectPom = (POM)this.pomService.load(project.getPomXMLPath());
                project.setPom(projectPom);
                authorizedProjects.add((Project)project);
            }
        }
        finally {
            nioRepositoryPaths.close();
        }
        return authorizedProjects;
    }

    public Package newPackage(Package parentPackage, String packageName) {
        try {
            Package newPackage = this.resourceResolver.newPackage(parentPackage, packageName, true);
            this.newPackageEvent.fire((Object)new NewPackageEvent(newPackage));
            return newPackage;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void addGroup(Project project, String group) {
        ConfigGroup thisProjectConfig = this.resourceResolver.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            thisProjectConfig = this.configurationFactory.newConfigGroup(ConfigType.PROJECT, project.getRootPath().toURI(), "Project '" + project.getProjectName() + "' configuration");
            thisProjectConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            this.configurationService.addConfiguration(thisProjectConfig);
        }
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisProjectConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).add(group);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    public void removeGroup(Project project, String group) {
        ConfigGroup thisProjectConfig = this.resourceResolver.findProjectConfig(project.getRootPath());
        if (thisProjectConfig == null) {
            throw new IllegalArgumentException("Project " + project.getProjectName() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisProjectConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).remove(group);
        this.configurationService.updateConfiguration(thisProjectConfig);
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newProjectPath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newProjectPath.equals(projectDirectory)) {
                return pathToPomXML;
            }
            if (this.ioService.exists(newProjectPath)) {
                throw new FileAlreadyExistsException(newProjectPath.toString());
            }
            org.uberfire.backend.vfs.Path oldProjectDir = Paths.convert((Path)projectDirectory);
            Object oldProject = this.resourceResolver.resolveProject(oldProjectDir);
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newProjectPath.resolve("pom.xml"));
            try {
                this.ioService.startBatch(newProjectPath.getFileSystem());
                this.ioService.move(projectDirectory, newProjectPath, new CopyOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
                this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            Object newProject = this.resourceResolver.resolveProject(Paths.convert((Path)newProjectPath));
            this.invalidateDMOCache.fire((Object)new InvalidateDMOProjectCacheEvent(this.sessionInfo, oldProject, oldProjectDir));
            this.renameProjectEvent.fire((Object)new RenameProjectEvent(oldProject, newProject));
            return newPathToPomXML;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path pathToPomXML, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Object project2Delete = this.resourceResolver.resolveProject(Paths.convert((Path)projectDirectory));
            Path parentPom = projectDirectory.getParent().resolve("pom.xml");
            POM parent = null;
            if (this.ioService.exists(parentPom)) {
                parent = (POM)this.pomService.load(Paths.convert((Path)parentPom));
            }
            this.ioService.delete(projectDirectory, new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES, this.commentedOptionFactory.makeCommentedOption(comment)});
            if (parent != null) {
                parent.setPackaging("pom");
                parent.getModules().remove(project2Delete.getProjectName());
                this.pomService.save(Paths.convert((Path)parentPom), (Object)parent, null, "Removing child module " + project2Delete.getProjectName());
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void copy(org.uberfire.backend.vfs.Path pathToPomXML, String newName, String comment) {
        try {
            Path projectDirectory = Paths.convert((org.uberfire.backend.vfs.Path)pathToPomXML).getParent();
            Path newProjectPath = projectDirectory.resolveSibling(newName);
            POM content = (POM)this.pomService.load(pathToPomXML);
            if (newProjectPath.equals(projectDirectory)) {
                return;
            }
            if (this.ioService.exists(newProjectPath)) {
                throw new FileAlreadyExistsException(newProjectPath.toString());
            }
            content.setName(newName);
            org.uberfire.backend.vfs.Path newPathToPomXML = Paths.convert((Path)newProjectPath.resolve("pom.xml"));
            try {
                this.ioService.startBatch(newProjectPath.getFileSystem());
                this.ioService.copy(projectDirectory, newProjectPath, new CopyOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
                this.pomService.save(newPathToPomXML, (Object)content, null, comment);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            Object newProject = this.resourceResolver.resolveProject(Paths.convert((Path)newProjectPath));
            this.newProjectEvent.fire((Object)new NewProjectEvent(newProject, this.commentedOptionFactory.getSafeSessionId(), this.commentedOptionFactory.getSafeIdentityName()));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

