/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.guvnor.common.services.project.backend.server.MavenLocalRepositoryUtils;
import org.guvnor.common.services.project.backend.server.MavenRepositorySystemSessionWrapper;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.scanner.Aether;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class ProjectRepositoryResolverImpl
implements ProjectRepositoryResolver {
    private static final Logger log = LoggerFactory.getLogger(ProjectRepositoryResolverImpl.class);
    boolean isCheckConflictingGAVDisabled = false;
    private IOService ioService;
    private POMContentHandler pomContentHandler = new POMContentHandler();

    public ProjectRepositoryResolverImpl() {
        this.isCheckConflictingGAVDisabled = Boolean.parseBoolean(System.getProperty("org.guvnor.project.gav.check.disabled", "false"));
    }

    @Inject
    public ProjectRepositoryResolverImpl(@Named(value="ioStrategy") IOService ioService) {
        this();
        this.ioService = ioService;
    }

    public Set<MavenRepositoryMetadata> getRemoteRepositoriesMetaData() {
        HashSet<MavenRepositoryMetadata> repositories = new HashSet<MavenRepositoryMetadata>();
        Aether aether = Aether.getAether();
        Map<MavenRepositorySource, Collection<RemoteRepository>> remoteRepositories = this.getRemoteRepositories();
        repositories.add(this.makeRepositoryMetaData((org.eclipse.aether.repository.ArtifactRepository)aether.getSession().getLocalRepository(), MavenRepositorySource.LOCAL));
        if (remoteRepositories.isEmpty()) {
            return repositories;
        }
        for (Map.Entry<MavenRepositorySource, Collection<RemoteRepository>> e : remoteRepositories.entrySet()) {
            repositories.addAll(this.makeRepositoriesMetaData(e.getValue(), e.getKey()));
        }
        return repositories;
    }

    public Set<MavenRepositoryMetadata> getRemoteRepositoriesMetaData(Project project) {
        if (project == null) {
            return Collections.emptySet();
        }
        HashSet<MavenRepositoryMetadata> repositories = new HashSet<MavenRepositoryMetadata>();
        try {
            org.uberfire.backend.vfs.Path pomXMLPath = project.getPomXMLPath();
            Path nioPomXMLPath = Paths.convert((org.uberfire.backend.vfs.Path)pomXMLPath);
            String pomXML = this.ioService.readAllString(nioPomXMLPath);
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXML.getBytes(Charset.forName("UTF-8")));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            Aether aether = new Aether(mavenProject);
            Map<MavenRepositorySource, Collection<RemoteRepository>> remoteRepositories = this.getRemoteRepositories(mavenProject);
            repositories.add(this.makeRepositoryMetaData((org.eclipse.aether.repository.ArtifactRepository)aether.getSession().getLocalRepository(), MavenRepositorySource.LOCAL));
            if (remoteRepositories.isEmpty()) {
                return repositories;
            }
            for (Map.Entry<MavenRepositorySource, Collection<RemoteRepository>> e : remoteRepositories.entrySet()) {
                repositories.addAll(this.makeRepositoriesMetaData(e.getValue(), e.getKey()));
            }
        }
        catch (IllegalArgumentException iae) {
            log.error("Unable to get Remote Repositories for Project '%s'. Returning empty Collection. ", (Object)project.getProjectName(), (Object)iae);
        }
        catch (NoSuchFileException nsfe) {
            log.error("Unable to get Remote Repositories for Project '%s'. Returning empty Collection. ", (Object)project.getProjectName(), (Object)nsfe);
        }
        catch (IOException ioe) {
            log.error("Unable to get Remote Repositories for Project '%s'. Returning empty Collection. ", (Object)project.getProjectName(), (Object)ioe);
        }
        return repositories;
    }

    private Set<MavenRepositoryMetadata> makeRepositoriesMetaData(Collection<? extends org.eclipse.aether.repository.ArtifactRepository> repositories, MavenRepositorySource source) {
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        for (org.eclipse.aether.repository.ArtifactRepository artifactRepository : repositories) {
            MavenRepositoryMetadata md = this.makeRepositoryMetaData(artifactRepository, source);
            if (md == null) continue;
            metadata.add(md);
        }
        return metadata;
    }

    private MavenRepositoryMetadata makeRepositoryMetaData(org.eclipse.aether.repository.ArtifactRepository repository, MavenRepositorySource source) {
        if (repository instanceof LocalRepository) {
            LocalRepository localRepository = (LocalRepository)repository;
            return new MavenRepositoryMetadata(localRepository.getId(), MavenSettings.getSettings().getLocalRepository(), source);
        }
        if (repository instanceof RemoteRepository) {
            RemoteRepository remoteRepository = (RemoteRepository)repository;
            return new MavenRepositoryMetadata(remoteRepository.getId(), remoteRepository.getUrl(), source);
        }
        return null;
    }

    public Set<MavenRepositoryMetadata> getRepositoriesResolvingArtifact(GAV gav, MavenRepositoryMetadata ... filter) {
        if (this.isCheckConflictingGAVDisabled) {
            return Collections.EMPTY_SET;
        }
        HashSet<MavenRepositoryMetadata> repositoriesResolvingArtifact = new HashSet<MavenRepositoryMetadata>();
        try {
            String pomXML = this.pomContentHandler.toString(new POM(gav));
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXML.getBytes(Charset.forName("UTF-8")));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            repositoriesResolvingArtifact.addAll(this.getRepositoriesResolvingArtifact(gav, mavenProject));
            if (filter != null && filter.length > 0) {
                repositoriesResolvingArtifact.retainAll(Arrays.asList(filter));
            }
        }
        catch (java.io.IOException ioe) {
            log.error("Unable to get Remote Repositories for Project '" + gav.toString() + "'. Returning empty Collection. ", (Throwable)ioe);
        }
        return repositoriesResolvingArtifact;
    }

    public Set<MavenRepositoryMetadata> getRepositoriesResolvingArtifact(GAV gav, Project project, MavenRepositoryMetadata ... filter) {
        if (this.isCheckConflictingGAVDisabled) {
            return Collections.EMPTY_SET;
        }
        HashSet<MavenRepositoryMetadata> repositoriesResolvingArtifact = new HashSet<MavenRepositoryMetadata>();
        try {
            org.uberfire.backend.vfs.Path pomXMLPath = project.getPomXMLPath();
            Path nioPomXMLPath = Paths.convert((org.uberfire.backend.vfs.Path)pomXMLPath);
            String pomXML = this.ioService.readAllString(nioPomXMLPath);
            ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXML.getBytes(Charset.forName("UTF-8")));
            MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
            repositoriesResolvingArtifact.addAll(this.getRepositoriesResolvingArtifact(gav, mavenProject));
            if (filter != null && filter.length > 0) {
                repositoriesResolvingArtifact.retainAll(Arrays.asList(filter));
            }
        }
        catch (IllegalArgumentException iae) {
            log.error("Unable to get Remote Repositories for Project '" + project.getProjectName() + "'. Returning empty Collection. ", (Throwable)iae);
        }
        catch (NoSuchFileException nsfe) {
            log.error("Unable to get Remote Repositories for Project '" + project.getProjectName() + "'. Returning empty Collection. ", (Throwable)nsfe);
        }
        catch (IOException ioe) {
            log.error("Unable to get Remote Repositories for Project '" + project.getProjectName() + "'. Returning empty Collection. ", (Throwable)ioe);
        }
        return repositoriesResolvingArtifact;
    }

    public Set<MavenRepositoryMetadata> getRepositoriesResolvingArtifact(String pomXML, MavenRepositoryMetadata ... filter) {
        if (this.isCheckConflictingGAVDisabled) {
            return Collections.EMPTY_SET;
        }
        ByteArrayInputStream pomStream = new ByteArrayInputStream(pomXML.getBytes(Charset.forName("UTF-8")));
        MavenProject mavenProject = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        GAV gav = new GAV(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        HashSet<MavenRepositoryMetadata> repositoriesResolvingArtifact = new HashSet<MavenRepositoryMetadata>();
        repositoriesResolvingArtifact.addAll(this.getRepositoriesResolvingArtifact(gav, mavenProject));
        if (filter != null && filter.length > 0) {
            repositoriesResolvingArtifact.retainAll(Arrays.asList(filter));
        }
        return repositoriesResolvingArtifact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<MavenRepositoryMetadata> getRepositoriesResolvingArtifact(GAV gav, MavenProject mavenProject) {
        ArtifactResult result = null;
        ArtifactRequest artifactRequest = null;
        String artifactName = gav.toString();
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        Aether aether = new Aether(mavenProject);
        HashSet<MavenRepositoryMetadata> repositoriesResolvingArtifact = new HashSet<MavenRepositoryMetadata>();
        Map<MavenRepositorySource, Collection<RemoteRepository>> repositories = this.getRemoteRepositories(mavenProject);
        artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        try {
            MavenRepositoryMetadata artifactRepositoryMetaData;
            result = aether.getSystem().resolveArtifact(aether.getSession(), artifactRequest);
            if (result != null && result.isResolved() && (artifactRepositoryMetaData = this.makeRepositoryMetaData(result.getRepository(), MavenRepositorySource.LOCAL)) != null) {
                repositoriesResolvingArtifact.add(artifactRepositoryMetaData);
            }
        }
        catch (ArtifactResolutionException artifactRepositoryMetaData) {
            // empty catch block
        }
        try {
            Iterator<Map.Entry<MavenRepositorySource, Collection<RemoteRepository>>> i$ = repositories.entrySet().iterator();
            block8: while (true) {
                if (!i$.hasNext()) return repositoriesResolvingArtifact;
                Map.Entry<MavenRepositorySource, Collection<RemoteRepository>> e = i$.next();
                Iterator<RemoteRepository> i$2 = e.getValue().iterator();
                while (true) {
                    if (!i$2.hasNext()) continue block8;
                    org.eclipse.aether.repository.ArtifactRepository artifactRepository = (org.eclipse.aether.repository.ArtifactRepository)i$2.next();
                    artifactRequest = new ArtifactRequest();
                    artifactRequest.setArtifact((Artifact)artifact);
                    File tempLocalRepositoryBasePath = null;
                    try {
                        MavenRepositoryMetadata artifactRepositoryMetaData;
                        artifactRequest.addRepository((RemoteRepository)artifactRepository);
                        tempLocalRepositoryBasePath = MavenLocalRepositoryUtils.getRepositoryPath(gav);
                        result = aether.getSystem().resolveArtifact((RepositorySystemSession)new MavenRepositorySystemSessionWrapper(tempLocalRepositoryBasePath.toString(), aether.getSession()), artifactRequest);
                        if (result != null && result.isResolved() && (artifactRepositoryMetaData = this.makeRepositoryMetaData(result.getRepository(), e.getKey())) != null) {
                            repositoriesResolvingArtifact.add(artifactRepositoryMetaData);
                        }
                    }
                    catch (ArtifactResolutionException artifactResolutionException) {
                        MavenLocalRepositoryUtils.tearDownMavenRepository(tempLocalRepositoryBasePath);
                        continue;
                        catch (Throwable throwable) {
                            MavenLocalRepositoryUtils.tearDownMavenRepository(tempLocalRepositoryBasePath);
                            throw throwable;
                        }
                    }
                    MavenLocalRepositoryUtils.tearDownMavenRepository(tempLocalRepositoryBasePath);
                }
                break;
            }
        }
        catch (java.io.IOException ioe) {
            log.error("Error resolving '" + gav.toString() + "' against Repositories. Returning empty Collection. ", (Throwable)ioe);
        }
        return repositoriesResolvingArtifact;
    }

    private Map<MavenRepositorySource, Collection<RemoteRepository>> getRemoteRepositories() {
        HashMap<MavenRepositorySource, Collection<RemoteRepository>> repositories = new HashMap<MavenRepositorySource, Collection<RemoteRepository>>();
        HashSet settingsRepositories = new HashSet(MavenSettings.getMavenRepositoryConfiguration().getRemoteRepositoriesForRequest());
        if (settingsRepositories != null) {
            repositories.put(MavenRepositorySource.SETTINGS, settingsRepositories);
        }
        return repositories;
    }

    private Map<MavenRepositorySource, Collection<RemoteRepository>> getRemoteRepositories(MavenProject mavenProject) {
        ArtifactRepository distributionManagementRepository;
        HashMap<MavenRepositorySource, Collection<RemoteRepository>> repositories = new HashMap<MavenRepositorySource, Collection<RemoteRepository>>();
        repositories.putAll(this.getRemoteRepositories());
        HashSet<RemoteRepository> projectRepositories = new HashSet<RemoteRepository>(mavenProject.getRemoteProjectRepositories());
        if (projectRepositories != null) {
            Collection settingsRepositories = (Collection)repositories.get(MavenRepositorySource.SETTINGS);
            this.removeProjectRepositoriesThatAreInSettings(projectRepositories, settingsRepositories);
            repositories.put(MavenRepositorySource.PROJECT, projectRepositories);
        }
        if ((distributionManagementRepository = mavenProject.getDistributionManagementArtifactRepository()) != null) {
            repositories.put(MavenRepositorySource.DISTRIBUTION_MANAGEMENT, (Collection<RemoteRepository>)new HashSet<RemoteRepository>(){
                {
                    this.add(ProjectRepositoryResolverImpl.this.convertToArtifactRepository(distributionManagementRepository));
                }
            });
        }
        return repositories;
    }

    private void removeProjectRepositoriesThatAreInSettings(Collection<RemoteRepository> projectRepositories, Collection<RemoteRepository> settingsRepositories) {
        HashSet<RemoteRepository> projectRepositoriesToRemove = new HashSet<RemoteRepository>();
        for (RemoteRepository projectRepository : projectRepositories) {
            for (RemoteRepository settingsRepository : settingsRepositories) {
                if (!projectRepository.getId().equals(settingsRepository.getId()) || !projectRepository.getUrl().equals(settingsRepository.getUrl())) continue;
                projectRepositoriesToRemove.add(projectRepository);
            }
        }
        projectRepositories.removeAll(projectRepositoriesToRemove);
    }

    private RemoteRepository convertToArtifactRepository(ArtifactRepository artifactRepository) {
        MavenEmbedder mavenEmbedder = MavenProjectLoader.newMavenEmbedder((boolean)MavenSettings.getSettings().isOffline());
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(artifactRepository.getId(), artifactRepository.getLayout().getId(), artifactRepository.getUrl()).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn"));
        Settings settings = MavenSettings.getSettings();
        Server server = settings.getServer(artifactRepository.getId());
        if (server != null) {
            Authentication authentication = mavenEmbedder.getMavenSession().getRepositorySession().getAuthenticationSelector().getAuthentication(remoteRepoBuilder.build());
            remoteRepoBuilder.setAuthentication(authentication);
        }
        return remoteRepoBuilder.build();
    }
}

