/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Session;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.ClusterSession;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogRecord
extends ClusterRecord {
    static final char DATE_IDENTIFIER = 'D';
    static final char NODE_IDENTIFIER = 'N';
    static final char PROPERTY_IDENTIFIER = 'P';
    static final char EVENT_IDENTIFIER = 'E';
    static final char USER_DATA_IDENTIFIER = 'U';
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int DELETED = 3;
    private ChangeLog changes;
    private long timestamp = System.currentTimeMillis();
    private List<EventState> events;
    private String userData;
    private int identifier;
    private ClusterSession lastSession;

    public ChangeLogRecord(ChangeLog changes, List<EventState> events, Record record, String workspace, long timestamp, String userData) {
        super(record, workspace);
        this.changes = changes;
        this.events = events;
        this.timestamp = timestamp;
        this.userData = userData;
    }

    ChangeLogRecord(int identifier, Record record, String workspace) {
        super(record, workspace);
        this.identifier = identifier;
        this.changes = new ChangeLog();
        this.events = new ArrayList<EventState>();
    }

    @Override
    protected void doRead() throws JournalException {
        int identifier = this.identifier;
        while (identifier != 0) {
            switch (identifier) {
                case 68: {
                    this.readTimestampRecord();
                    break;
                }
                case 85: {
                    this.readUserDataRecord();
                    break;
                }
                case 78: {
                    this.readNodeRecord();
                    break;
                }
                case 80: {
                    this.readPropertyRecord();
                    break;
                }
                case 69: {
                    this.readEventRecord();
                    break;
                }
                default: {
                    String msg = "Unknown identifier: " + identifier;
                    throw new JournalException(msg);
                }
            }
            identifier = this.record.readChar();
        }
    }

    @Override
    protected void readEndMarker() throws JournalException {
    }

    private void readTimestampRecord() throws JournalException {
        this.timestamp = this.record.readLong();
    }

    private void readUserDataRecord() throws JournalException {
        this.userData = this.record.readString();
    }

    private void readNodeRecord() throws JournalException {
        byte operation = this.record.readByte();
        NodeState state = new NodeState(this.record.readNodeId(), null, null, 4, false);
        this.apply(operation, state);
    }

    private void readPropertyRecord() throws JournalException {
        byte operation = this.record.readByte();
        PropertyState state = new PropertyState(this.record.readPropertyId(), 4, false);
        this.apply(operation, state);
    }

    private void apply(int operation, ItemState state) throws JournalException {
        switch (operation) {
            case 1: {
                state.setStatus(1);
                this.changes.added(state);
                break;
            }
            case 3: {
                state.setStatus(3);
                this.changes.deleted(state);
                break;
            }
            case 2: {
                state.setStatus(2);
                this.changes.modified(state);
                break;
            }
            default: {
                String msg = "Unknown item operation: " + operation;
                throw new JournalException(msg);
            }
        }
    }

    private void readEventRecord() throws JournalException {
        byte type = this.record.readByte();
        NodeId parentId = this.record.readNodeId();
        Path parentPath = this.record.readPath();
        NodeId childId = this.record.readNodeId();
        Path childRelPath = this.record.readPathElement();
        Name ntName = this.record.readQName();
        HashSet<Name> mixins = new HashSet<Name>();
        int mixinCount = this.record.readInt();
        for (int i = 0; i < mixinCount; ++i) {
            mixins.add(this.record.readQName());
        }
        String userId = this.record.readString();
        HashMap<String, InternalValue> info = null;
        if (type == 32) {
            info = new HashMap<String, InternalValue>();
            int infoSize = this.record.readInt();
            for (int i = 0; i < infoSize; ++i) {
                String key = this.record.readString();
                int propType = this.record.readInt();
                InternalValue value = propType == 0 ? null : InternalValue.valueOf(this.record.readString(), propType);
                info.put(key, value);
            }
        }
        EventState es = this.createEventState(type, parentId, parentPath, childId, childRelPath, ntName, mixins, userId);
        if (info != null) {
            es.setInfo(info);
        }
        this.events.add(es);
    }

    private EventState createEventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path childRelPath, Name ntName, Set<Name> mixins, String userId) {
        switch (type) {
            case 1: {
                return EventState.childNodeAdded(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 32: {
                return EventState.nodeMoved(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 2: {
                return EventState.childNodeRemoved(parentId, parentPath, childId, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 4: {
                return EventState.propertyAdded(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 16: {
                return EventState.propertyChanged(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
            case 8: {
                return EventState.propertyRemoved(parentId, parentPath, childRelPath, ntName, mixins, this.getOrCreateSession(userId), true);
            }
        }
        String msg = "Unexpected event type: " + type;
        throw new IllegalArgumentException(msg);
    }

    private Session getOrCreateSession(String userId) {
        if (this.lastSession == null || !this.lastSession.isUserId(userId)) {
            this.lastSession = new ClusterSession(userId);
        }
        return this.lastSession;
    }

    @Override
    protected void doWrite() throws JournalException {
        this.writeTimestampRecord();
        this.writeUserDataRecord();
        for (ItemState state : this.changes.deletedStates()) {
            if (state.isNode()) {
                this.writeNodeRecord(3, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(3, (PropertyState)state);
        }
        for (ItemState state : this.changes.modifiedStates()) {
            if (state.isNode()) {
                this.writeNodeRecord(2, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(2, (PropertyState)state);
        }
        for (ItemState state : this.changes.addedStates()) {
            if (state.isNode()) {
                this.writeNodeRecord(1, (NodeState)state);
                continue;
            }
            this.writePropertyRecord(1, (PropertyState)state);
        }
        for (EventState event : this.events) {
            this.writeEventRecord(event);
        }
    }

    private void writeTimestampRecord() throws JournalException {
        this.record.writeChar('D');
        this.record.writeLong(this.timestamp);
    }

    private void writeUserDataRecord() throws JournalException {
        if (this.userData != null) {
            this.record.writeChar('U');
            this.record.writeString(this.userData);
        }
    }

    private void writeNodeRecord(int operation, NodeState state) throws JournalException {
        this.record.writeChar('N');
        this.record.writeByte(operation);
        this.record.writeNodeId(state.getNodeId());
    }

    private void writePropertyRecord(int operation, PropertyState state) throws JournalException {
        this.record.writeChar('P');
        this.record.writeByte(operation);
        this.record.writePropertyId(state.getPropertyId());
    }

    private void writeEventRecord(EventState event) throws JournalException {
        this.record.writeChar('E');
        this.record.writeByte(event.getType());
        this.record.writeNodeId(event.getParentId());
        this.record.writePath(event.getParentPath());
        this.record.writeNodeId(event.getChildId());
        this.record.writePathElement(event.getChildRelPath());
        this.record.writeQName(event.getNodeType());
        Set<Name> mixins = event.getMixinNames();
        this.record.writeInt(mixins.size());
        Iterator<Name> iter = mixins.iterator();
        while (iter.hasNext()) {
            this.record.writeQName(iter.next());
        }
        this.record.writeString(event.getUserId());
        if (event.getType() == 32) {
            Map<String, InternalValue> info = event.getInfo();
            this.record.writeInt(info.size());
            for (Map.Entry<String, InternalValue> entry : info.entrySet()) {
                String key = entry.getKey();
                InternalValue value = entry.getValue();
                this.record.writeString(key);
                if (value == null) {
                    this.record.writeInt(0);
                    continue;
                }
                this.record.writeInt(value.getType());
                this.record.writeString(value.toString());
            }
        }
    }

    @Override
    public void process(ClusterRecordProcessor processor) {
        processor.process(this);
    }

    public ChangeLog getChanges() {
        return this.changes;
    }

    public List<EventState> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUserData() {
        return this.userData;
    }
}

