/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.jcr.PropertyType;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.AbstractPersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.DOMWalker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class XMLPersistenceManager
extends AbstractPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(XMLPersistenceManager.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String NODE_ELEMENT = "node";
    private static final String UUID_ATTRIBUTE = "uuid";
    private static final String NODETYPE_ATTRIBUTE = "nodeType";
    private static final String PARENTUUID_ATTRIBUTE = "parentUUID";
    private static final String MODCOUNT_ATTRIBUTE = "modCount";
    private static final String MIXINTYPES_ELEMENT = "mixinTypes";
    private static final String MIXINTYPE_ELEMENT = "mixinType";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MULTIVALUED_ATTRIBUTE = "multiValued";
    private static final String VALUES_ELEMENT = "values";
    private static final String VALUE_ELEMENT = "value";
    private static final String NODES_ELEMENT = "nodes";
    private static final String NODEREFERENCES_ELEMENT = "references";
    private static final String TARGETID_ATTRIBUTE = "targetId";
    private static final String NODEREFERENCE_ELEMENT = "reference";
    private static final String PROPERTYID_ATTRIBUTE = "propertyId";
    private static final String NODEFILENAME = ".node.xml";
    private static final String NODEREFSFILENAME = ".references.xml";
    private boolean initialized = false;
    private FileSystem itemStateFS;
    private FileSystem blobFS;
    private BLOBStore blobStore;
    private String nodePathTemplate = "xxxx/xxxx/xxxxxxxxxxxxxxxxxxxxxxxx";
    private final NameFactory factory = NameFactoryImpl.getInstance();

    public String getNodePathTemplate() {
        return this.nodePathTemplate;
    }

    public void setNodePathTemplate(String template) {
        this.nodePathTemplate = template;
    }

    private String buildNodeFolderPath(NodeId id) {
        StringBuffer sb = new StringBuffer();
        char[] chars = id.toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < this.nodePathTemplate.length(); ++i) {
            char ch = this.nodePathTemplate.charAt(i);
            if (ch == 'x' && cnt < chars.length && (ch = chars[cnt++]) == '-') {
                ch = chars[cnt++];
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String buildPropFilePath(PropertyId id) {
        String fileName;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(id.getName().getNamespaceURI().getBytes());
            md5.update(id.getName().getLocalName().getBytes());
            byte[] bytes = md5.digest();
            char[] chars = new char[32];
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                chars[j++] = HEXDIGITS[bytes[i] >> 4 & 0xF];
                chars[j++] = HEXDIGITS[bytes[i] & 0xF];
            }
            fileName = new String(chars) + ".xml";
        }
        catch (NoSuchAlgorithmException nsae) {
            String msg = "MD5 not available";
            log.error(msg, (Throwable)nsae);
            throw new InternalError(msg + nsae);
        }
        return this.buildNodeFolderPath(id.getParentId()) + "/" + fileName;
    }

    private String buildNodeFilePath(NodeId id) {
        return this.buildNodeFolderPath(id) + "/" + NODEFILENAME;
    }

    private String buildNodeReferencesFilePath(NodeId id) {
        return this.buildNodeFolderPath(id) + "/" + NODEREFSFILENAME;
    }

    private void readState(DOMWalker walker, NodeState state) throws ItemStateException {
        if (!walker.getName().equals(NODE_ELEMENT)) {
            String msg = "invalid serialization format (unexpected element: " + walker.getName() + ")";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        if (!state.getNodeId().toString().equals(walker.getAttribute(UUID_ATTRIBUTE))) {
            String msg = "invalid serialized state: uuid mismatch";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        String ntName = walker.getAttribute(NODETYPE_ATTRIBUTE);
        if (!this.factory.create(ntName).equals(state.getNodeTypeName())) {
            String msg = "invalid serialized state: nodetype mismatch";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        String parentUUID = walker.getAttribute(PARENTUUID_ATTRIBUTE);
        if (parentUUID.length() > 0) {
            state.setParentId(NodeId.valueOf(parentUUID));
        }
        String modCount = walker.getAttribute(MODCOUNT_ATTRIBUTE);
        state.setModCount(Short.parseShort(modCount));
        if (walker.enterElement(MIXINTYPES_ELEMENT)) {
            HashSet<Name> mixins = new HashSet<Name>();
            while (walker.iterateElements(MIXINTYPE_ELEMENT)) {
                mixins.add(this.factory.create(walker.getAttribute(NAME_ATTRIBUTE)));
            }
            if (mixins.size() > 0) {
                state.setMixinTypeNames(mixins);
            }
            walker.leaveElement();
        }
        if (walker.enterElement(PROPERTIES_ELEMENT)) {
            while (walker.iterateElements(PROPERTY_ELEMENT)) {
                String propName = walker.getAttribute(NAME_ATTRIBUTE);
                state.addPropertyName(this.factory.create(propName));
            }
            walker.leaveElement();
        }
        if (walker.enterElement(NODES_ELEMENT)) {
            while (walker.iterateElements(NODE_ELEMENT)) {
                String childName = walker.getAttribute(NAME_ATTRIBUTE);
                String childUUID = walker.getAttribute(UUID_ATTRIBUTE);
                state.addChildNodeEntry(this.factory.create(childName), NodeId.valueOf(childUUID));
            }
            walker.leaveElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readState(DOMWalker walker, PropertyState state) throws ItemStateException {
        int type;
        if (!walker.getName().equals(PROPERTY_ELEMENT)) {
            String msg = "invalid serialization format (unexpected element: " + walker.getName() + ")";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        if (!state.getName().equals(this.factory.create(walker.getAttribute(NAME_ATTRIBUTE)))) {
            String msg = "invalid serialized state: name mismatch";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        NodeId parentId = NodeId.valueOf(walker.getAttribute(PARENTUUID_ATTRIBUTE));
        if (!parentId.equals(state.getParentId())) {
            String msg = "invalid serialized state: parentUUID mismatch";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        String typeName = walker.getAttribute(TYPE_ATTRIBUTE);
        try {
            type = PropertyType.valueFromName((String)typeName);
        }
        catch (IllegalArgumentException iae) {
            throw new ItemStateException("unexpected property-type: " + typeName, iae);
        }
        state.setType(type);
        String multiValued = walker.getAttribute(MULTIVALUED_ATTRIBUTE);
        state.setMultiValued(Boolean.parseBoolean(multiValued));
        String modCount = walker.getAttribute(MODCOUNT_ATTRIBUTE);
        state.setModCount(Short.parseShort(modCount));
        ArrayList<InternalValue> values = new ArrayList<InternalValue>();
        if (walker.enterElement(VALUES_ELEMENT)) {
            while (walker.iterateElements(VALUE_ELEMENT)) {
                String content = walker.getContent();
                if (1 == type) {
                    values.add(InternalValue.valueOf(content, type));
                    continue;
                }
                if (content.length() > 0) {
                    if (type == 2) {
                        try {
                            if (this.blobStore instanceof ResourceBasedBLOBStore) {
                                FileSystemResource fsRes = ((ResourceBasedBLOBStore)this.blobStore).getResource(content);
                                values.add(InternalValue.create(fsRes));
                                continue;
                            }
                            InputStream in = this.blobStore.get(content);
                            try {
                                values.add(InternalValue.create(in));
                                continue;
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)in);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            String msg = "error while reading serialized binary value";
                            log.debug(msg);
                            throw new ItemStateException(msg, e);
                        }
                    }
                    values.add(InternalValue.valueOf(content, type));
                    continue;
                }
                log.warn(state.getPropertyId() + ": ignoring empty value of type " + PropertyType.nameFromValue((int)type));
            }
            walker.leaveElement();
        }
        state.setValues(values.toArray(new InternalValue[values.size()]));
    }

    private void readState(DOMWalker walker, NodeReferences refs) throws ItemStateException {
        if (!walker.getName().equals(NODEREFERENCES_ELEMENT)) {
            String msg = "invalid serialization format (unexpected element: " + walker.getName() + ")";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        if (!refs.getTargetId().equals(NodeId.valueOf(walker.getAttribute(TARGETID_ATTRIBUTE)))) {
            String msg = "invalid serialized state: targetId  mismatch";
            log.debug(msg);
            throw new ItemStateException(msg);
        }
        refs.clearAllReferences();
        while (walker.iterateElements(NODEREFERENCE_ELEMENT)) {
            refs.addReference(PropertyId.valueOf(walker.getAttribute(PROPERTYID_ATTRIBUTE)));
        }
    }

    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.itemStateFS = new BasedFileSystem(context.getFileSystem(), "/data");
        LocalFileSystem blobFS = new LocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        this.blobFS = blobFS;
        this.blobStore = new FileSystemBLOBStore(blobFS);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.blobFS.close();
            this.blobFS = null;
            this.blobStore = null;
        }
        finally {
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        Exception e;
        block8: {
            NodeState nodeState;
            if (!this.initialized) {
                throw new IllegalStateException("not initialized");
            }
            e = null;
            String nodeFilePath = this.buildNodeFilePath(id);
            if (!this.itemStateFS.isFile(nodeFilePath)) {
                throw new NoSuchItemStateException(id.toString());
            }
            InputStream in = this.itemStateFS.getInputStream(nodeFilePath);
            try {
                DOMWalker walker = new DOMWalker(in);
                String ntName = walker.getAttribute(NODETYPE_ATTRIBUTE);
                NodeState state = this.createNew(id);
                state.setNodeTypeName(this.factory.create(ntName));
                this.readState(walker, state);
                nodeState = state;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    e = ioe;
                    break block8;
                }
                catch (FileSystemException fse) {
                    e = fse;
                }
            }
            in.close();
            return nodeState;
        }
        String msg = "failed to read node state: " + id;
        log.debug(msg);
        throw new ItemStateException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        Exception e;
        block8: {
            PropertyState propertyState;
            if (!this.initialized) {
                throw new IllegalStateException("not initialized");
            }
            e = null;
            String propFilePath = this.buildPropFilePath(id);
            if (!this.itemStateFS.isFile(propFilePath)) {
                throw new NoSuchItemStateException(id.toString());
            }
            InputStream in = this.itemStateFS.getInputStream(propFilePath);
            try {
                DOMWalker walker = new DOMWalker(in);
                PropertyState state = this.createNew(id);
                this.readState(walker, state);
                propertyState = state;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    e = ioe;
                    break block8;
                }
                catch (FileSystemException fse) {
                    e = fse;
                }
            }
            in.close();
            return propertyState;
        }
        String msg = "failed to read property state: " + id.toString();
        log.debug(msg);
        throw new ItemStateException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        NodeId id = state.getNodeId();
        String nodeFilePath = this.buildNodeFilePath(id);
        FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
        try {
            nodeFile.makeParentDirs();
            OutputStream os = nodeFile.getOutputStream();
            Writer writer = null;
            try {
                String encoding = DEFAULT_ENCODING;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(os, encoding));
                }
                catch (UnsupportedEncodingException e) {
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    encoding = osw.getEncoding();
                    writer = new BufferedWriter(osw);
                }
                String parentId = state.getParentId() == null ? "" : state.getParentId().toString();
                String encodedNodeType = Text.encodeIllegalXMLCharacters((String)state.getNodeTypeName().toString());
                writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
                writer.write("<node uuid=\"" + id + "\" " + PARENTUUID_ATTRIBUTE + "=\"" + parentId + "\" " + MODCOUNT_ATTRIBUTE + "=\"" + state.getModCount() + "\" " + NODETYPE_ATTRIBUTE + "=\"" + encodedNodeType + "\">\n");
                writer.write("\t<mixinTypes>\n");
                for (Name mixin : state.getMixinTypeNames()) {
                    writer.write("\t\t<mixinType name=\"" + Text.encodeIllegalXMLCharacters((String)mixin.toString()) + "\"/>\n");
                }
                writer.write("\t</mixinTypes>\n");
                writer.write("\t<properties>\n");
                for (Name propName : state.getPropertyNames()) {
                    writer.write("\t\t<property name=\"" + Text.encodeIllegalXMLCharacters((String)propName.toString()) + "\">\n");
                    writer.write("\t\t</property>\n");
                }
                writer.write("\t</properties>\n");
                writer.write("\t<nodes>\n");
                for (ChildNodeEntry entry : state.getChildNodeEntries()) {
                    writer.write("\t\t<node name=\"" + Text.encodeIllegalXMLCharacters((String)entry.getName().toString()) + "\" " + UUID_ATTRIBUTE + "=\"" + entry.getId() + "\">\n");
                    writer.write("\t\t</node>\n");
                }
                writer.write("\t</nodes>\n");
                writer.write("</node>\n");
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String propFilePath = this.buildPropFilePath(state.getPropertyId());
        FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
        try {
            propFile.makeParentDirs();
            OutputStream os = propFile.getOutputStream();
            Writer writer = null;
            try {
                String typeName;
                String encoding = DEFAULT_ENCODING;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(os, encoding));
                }
                catch (UnsupportedEncodingException e) {
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    encoding = osw.getEncoding();
                    writer = new BufferedWriter(osw);
                }
                int type = state.getType();
                try {
                    typeName = PropertyType.nameFromValue((int)type);
                }
                catch (IllegalArgumentException iae) {
                    throw new ItemStateException("unexpected property-type ordinal: " + type, iae);
                }
                writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
                writer.write("<property name=\"" + Text.encodeIllegalXMLCharacters((String)state.getName().toString()) + "\" " + PARENTUUID_ATTRIBUTE + "=\"" + state.getParentId() + "\" " + MULTIVALUED_ATTRIBUTE + "=\"" + Boolean.toString(state.isMultiValued()) + "\" " + MODCOUNT_ATTRIBUTE + "=\"" + state.getModCount() + "\" " + TYPE_ATTRIBUTE + "=\"" + typeName + "\">\n");
                writer.write("\t<values>\n");
                InternalValue[] values = state.getValues();
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        writer.write("\t\t<value>");
                        InternalValue val = values[i];
                        if (val != null) {
                            if (type == 2) {
                                InputStream in = val.getStream();
                                String blobId = this.blobStore.createId(state.getPropertyId(), i);
                                try {
                                    this.blobStore.put(blobId, in, val.getLength());
                                }
                                finally {
                                    IOUtils.closeQuietly((InputStream)in);
                                }
                                writer.write(blobId);
                                if (this.blobStore instanceof ResourceBasedBLOBStore) {
                                    FileSystemResource fsRes = ((ResourceBasedBLOBStore)this.blobStore).getResource(blobId);
                                    values[i] = InternalValue.create(fsRes);
                                } else {
                                    in = this.blobStore.get(blobId);
                                    try {
                                        values[i] = InternalValue.create(in);
                                    }
                                    finally {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException e) {}
                                    }
                                }
                                val.discard();
                            } else {
                                writer.write(Text.encodeIllegalXMLCharacters((String)val.toString()));
                            }
                        }
                        writer.write("</value>\n");
                    }
                }
                writer.write("\t</values>\n");
                writer.write("</property>\n");
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to store property state: " + state.getParentId() + "/" + state.getName();
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        NodeId id = state.getNodeId();
        String nodeFilePath = this.buildNodeFilePath(id);
        FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
        try {
            if (nodeFile.exists()) {
                nodeFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete node state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    protected void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null) continue;
                val.deleteBinaryResource();
            }
        }
        String propFilePath = this.buildPropFilePath(state.getPropertyId());
        FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
        try {
            if (propFile.exists()) {
                propFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete property state: " + state.getParentId() + "/" + state.getName();
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NodeReferences loadReferencesTo(NodeId id) throws NoSuchItemStateException, ItemStateException {
        Exception e;
        block8: {
            NodeReferences nodeReferences;
            if (!this.initialized) {
                throw new IllegalStateException("not initialized");
            }
            e = null;
            String refsFilePath = this.buildNodeReferencesFilePath(id);
            if (!this.itemStateFS.isFile(refsFilePath)) {
                throw new NoSuchItemStateException(id.toString());
            }
            InputStream in = this.itemStateFS.getInputStream(refsFilePath);
            try {
                DOMWalker walker = new DOMWalker(in);
                NodeReferences refs = new NodeReferences(id);
                this.readState(walker, refs);
                nodeReferences = refs;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    e = ioe;
                    break block8;
                }
                catch (FileSystemException fse) {
                    e = fse;
                }
            }
            in.close();
            return nodeReferences;
        }
        String msg = "failed to load references: " + id;
        log.debug(msg);
        throw new ItemStateException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String refsFilePath = this.buildNodeReferencesFilePath(refs.getTargetId());
        FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
        try {
            refsFile.makeParentDirs();
            OutputStream os = refsFile.getOutputStream();
            BufferedWriter writer = null;
            try {
                String encoding = DEFAULT_ENCODING;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(os, encoding));
                }
                catch (UnsupportedEncodingException e) {
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    encoding = osw.getEncoding();
                    writer = new BufferedWriter(osw);
                }
                writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
                writer.write("<references targetId=\"" + refs.getTargetId() + "\">\n");
                for (PropertyId propId : refs.getReferences()) {
                    writer.write("\t<reference propertyId=\"" + propId + "\"/>\n");
                }
                writer.write("</references>\n");
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            String msg = "failed to store " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String refsFilePath = this.buildNodeReferencesFilePath(refs.getTargetId());
        FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
        try {
            if (refsFile.exists()) {
                refsFile.delete(true);
            }
        }
        catch (FileSystemException fse) {
            String msg = "failed to delete " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    public synchronized boolean exists(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String nodeFilePath = this.buildNodeFilePath(id);
            FileSystemResource nodeFile = new FileSystemResource(this.itemStateFS, nodeFilePath);
            return nodeFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of item state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }

    public synchronized boolean exists(PropertyId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String propFilePath = this.buildPropFilePath(id);
            FileSystemResource propFile = new FileSystemResource(this.itemStateFS, propFilePath);
            return propFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of item state: " + id;
            log.error(msg, (Throwable)fse);
            throw new ItemStateException(msg, fse);
        }
    }

    public synchronized boolean existsReferencesTo(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            String refsFilePath = this.buildNodeReferencesFilePath(id);
            FileSystemResource refsFile = new FileSystemResource(this.itemStateFS, refsFilePath);
            return refsFile.exists();
        }
        catch (FileSystemException fse) {
            String msg = "failed to check existence of references: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, fse);
        }
    }
}

