/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.backend.builder.LRUBuilderCache;
import org.kie.workbench.common.services.datamodel.backend.server.cache.ProjectDataModelOracleBuilderProvider;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
@Named(value="ProjectDataModelOracleCache")
public class LRUProjectDataModelOracleCache
extends LRUCache<KieProject, ProjectDataModelOracle> {
    private ProjectDataModelOracleBuilderProvider builderProvider;
    private KieProjectService projectService;
    private LRUBuilderCache cache;

    public LRUProjectDataModelOracleCache() {
    }

    @Inject
    public LRUProjectDataModelOracleCache(ProjectDataModelOracleBuilderProvider builderProvider, KieProjectService projectService, LRUBuilderCache cache) {
        this.builderProvider = builderProvider;
        this.projectService = projectService;
        this.cache = cache;
    }

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Path resourcePath = event.getResourcePath();
        KieProject project = (KieProject)this.projectService.resolveProject(resourcePath);
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized ProjectDataModelOracle assertProjectDataModelOracle(KieProject project) {
        ProjectDataModelOracle projectOracle = (ProjectDataModelOracle)this.getEntry(project);
        if (projectOracle == null) {
            projectOracle = this.makeProjectOracle(project);
            this.setEntry(project, projectOracle);
        }
        return projectOracle;
    }

    private ProjectDataModelOracle makeProjectOracle(KieProject project) {
        return this.builderProvider.newBuilder(project, this.cache.assertBuilder((Project)project)).build();
    }
}

