/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.model;

import java.io.Serializable;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class SocialPaged
implements Serializable {
    private SocialPaged lastQuery;
    private Direction direction;
    private int pageSize;
    private String lastFileReaded;
    private int lastFileIndex;
    private int freshIndex;
    private boolean canIGoForward;
    private boolean canIGoBackward;
    private int numberOfEventsOnFile;

    public SocialPaged() {
    }

    public SocialPaged(int pageSize) {
        this.pageSize = pageSize;
        this.freshIndex = 0;
        this.lastFileReaded = "";
        this.lastFileIndex = 0;
        this.numberOfEventsOnFile = -1;
        this.canIGoForward = false;
        this.canIGoBackward = false;
        this.direction = Direction.FORWARD;
    }

    public SocialPaged(SocialPaged socialPaged) {
        if (socialPaged.lastQuery != null) {
            this.lastQuery = new SocialPaged(socialPaged.lastQuery);
        }
        this.direction = socialPaged.direction;
        this.pageSize = socialPaged.pageSize;
        this.lastFileReaded = socialPaged.lastFileReaded;
        this.lastFileIndex = socialPaged.lastFileIndex;
        this.freshIndex = socialPaged.freshIndex;
        this.canIGoForward = socialPaged.canIGoForward;
        this.canIGoBackward = socialPaged.canIGoBackward;
        this.numberOfEventsOnFile = socialPaged.numberOfEventsOnFile;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void updateFreshIndex() {
        ++this.freshIndex;
    }

    public void updateLastFileIndex() {
        ++this.lastFileIndex;
    }

    public int freshIndex() {
        return this.freshIndex;
    }

    public int lastFileIndex() {
        return this.lastFileIndex;
    }

    public String lastFileReaded() {
        return this.lastFileReaded;
    }

    public boolean firstFileRead() {
        return this.lastFileReaded.isEmpty();
    }

    public void setLastFileReaded(String lastFileReaded) {
        this.lastFileReaded = lastFileReaded;
    }

    public boolean isANewQuery() {
        return this.lastFileReaded.isEmpty();
    }

    public String getNextFileToRead() {
        Integer lastFile = Integer.valueOf(this.lastFileReaded);
        Integer nextFile = lastFile - 1;
        this.lastFileReaded = nextFile.toString();
        this.lastFileIndex = 0;
        return nextFile.toString();
    }

    public boolean canIGoForward() {
        return this.canIGoForward;
    }

    public void setCanIGoForward(boolean canIGoForward) {
        this.canIGoForward = canIGoForward;
    }

    public boolean canIGoBackward() {
        SocialPaged socialPaged = this.getLastQuery();
        return socialPaged != null && socialPaged.getLastQuery() != null;
    }

    public void forward() {
        this.direction = Direction.FORWARD;
    }

    public void backward() {
        this.direction = Direction.BACKWARD;
    }

    public boolean isBackward() {
        return this.direction == Direction.BACKWARD;
    }

    public void setLastQuery(SocialPaged socialPaged) {
        this.lastQuery = socialPaged;
    }

    public SocialPaged getLastQuery() {
        return this.lastQuery;
    }

    public SocialPaged goBackToLastQuery() {
        SocialPaged socialPaged = this.getLastQuery();
        if (socialPaged.getLastQuery() != null) {
            socialPaged = socialPaged.getLastQuery();
        }
        return socialPaged;
    }

    public boolean isLastEventFromLastFile() {
        return this.lastFileReaded.equalsIgnoreCase("0") && this.lastFileIndex == this.numberOfEventsOnFile;
    }

    public void setNumberOfEventsOnFile(Integer numberOfEventsOnFile) {
        this.numberOfEventsOnFile = numberOfEventsOnFile;
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

