/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.drools.ChoiceList;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;

public class DSLRuleEditor
extends DirtyableComposite {
    private TextArea text;
    private final RuleContentText data;
    private DSLSentence[] conditions;
    private DSLSentence[] actions;

    public DSLRuleEditor(Asset asset, RuleViewer viewer) {
        this(asset);
    }

    public DSLRuleEditor(Asset asset) {
        RuleContentText cont;
        this.data = cont = (RuleContentText)asset.getContent();
        this.text = new TextArea();
        this.text.setWidth("100%");
        this.text.setVisibleLines(16);
        this.text.setText(this.data.content);
        SuggestionCompletionEngine eng = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.getMetaData().getModuleName());
        this.actions = eng.actionDSLSentences;
        this.conditions = eng.conditionDSLSentences;
        this.text.setStyleName("dsl-text-Editor");
        FlexTable layout = new FlexTable();
        layout.setWidget(0, 0, (Widget)this.text);
        this.text.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((DSLRuleEditor)DSLRuleEditor.this).data.content = DSLRuleEditor.this.text.getText();
                DSLRuleEditor.this.makeDirty();
            }
        });
        this.text.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 32 && event.getNativeKeyCode() == 17) {
                    DSLRuleEditor.this.showInTextOptions();
                }
                if (event.getNativeKeyCode() == 9) {
                    int nextPos = DSLRuleEditor.this.text.getCursorPos() + 1;
                    DSLRuleEditor.this.text.cancelKey();
                    DSLRuleEditor.this.insertText("\t");
                    DSLRuleEditor.this.text.setCursorPos(nextPos);
                }
            }
        });
        VerticalPanel vert = new VerticalPanel();
        Image lhsOptions = DroolsGuvnorImages.INSTANCE.NewDSLPattern();
        lhsOptions.setTitle(Constants.INSTANCE.AddANewCondition());
        lhsOptions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DSLRuleEditor.this.showSuggestions(DSLRuleEditor.this.conditions);
            }
        });
        Image rhsOptions = DroolsGuvnorImages.INSTANCE.NewDSLAction();
        rhsOptions.setTitle(Constants.INSTANCE.AddAnAction());
        rhsOptions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DSLRuleEditor.this.showSuggestions(DSLRuleEditor.this.actions);
            }
        });
        vert.add((Widget)lhsOptions);
        vert.add((Widget)rhsOptions);
        layout.setWidget(0, 1, (Widget)vert);
        layout.getCellFormatter().setWidth(0, 0, "95%");
        layout.getFlexCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_TOP);
        layout.getCellFormatter().setWidth(0, 1, "5%");
        layout.getFlexCellFormatter().setAlignment(0, 1, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        layout.setWidth("100%");
        layout.setHeight("100%");
        this.initWidget((Widget)layout);
    }

    protected void showInTextOptions() {
        String prev = this.text.getText().substring(0, this.text.getCursorPos());
        if (prev.indexOf("then") > -1) {
            this.showSuggestions(this.actions);
        } else {
            this.showSuggestions(this.conditions);
        }
    }

    private void showSuggestions(DSLSentence[] items) {
        ChoiceList choice = new ChoiceList(items, this);
        choice.setPopupPosition(this.text.getAbsoluteLeft() + 20, this.text.getAbsoluteTop() + 20);
        choice.show();
    }

    void insertText(String ins) {
        int i = this.text.getCursorPos();
        String left = this.text.getText().substring(0, i);
        String right = this.text.getText().substring(i, this.text.getText().length());
        this.text.setText(left + ins + right);
        this.data.content = this.text.getText();
    }
}

