/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CustomFormPopUp;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.DatePickerLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLComplexVariableValue;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.DSLVariableValue;

public class DSLSentenceWidget
extends RuleModellerWidget {
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final List<DSLDropDown> dropDownWidgets = new ArrayList<DSLDropDown>();
    private final DSLSentence sentence;
    private final VerticalPanel layout;
    private HorizontalPanel currentRow;
    private boolean readOnly;

    public DSLSentenceWidget(RuleModeller modeller, EventBus eventBus, DSLSentence sentence, Boolean readOnly) {
        super(modeller, eventBus);
        this.sentence = sentence;
        this.readOnly = readOnly == null ? false : readOnly;
        this.layout = new VerticalPanel();
        this.currentRow = new HorizontalPanel();
        this.layout.add((Widget)this.currentRow);
        this.layout.setCellWidth((Widget)this.currentRow, "100%");
        this.layout.setWidth("100%");
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.init();
    }

    private void init() {
        this.makeWidgets(this.sentence);
        this.initWidget((Widget)this.layout);
    }

    public void makeWidgets(DSLSentence sentence) {
        String dslDefinition = sentence.getDefinition();
        List dslValues = sentence.getValues();
        int index = 0;
        int startVariable = dslDefinition.indexOf("{");
        ArrayList<Widget> lineWidgets = new ArrayList<Widget>();
        boolean firstOneIsBracket = dslDefinition.indexOf("{") == 0;
        String startLabel = "";
        if (startVariable > 0) {
            startLabel = dslDefinition.substring(0, startVariable);
        } else if (!firstOneIsBracket) {
            startLabel = dslDefinition;
        }
        Widget label = this.getLabel(startLabel);
        lineWidgets.add(label);
        while (startVariable > 0 || firstOneIsBracket) {
            firstOneIsBracket = false;
            int endVariable = this.getIndexForEndOfVariable(dslDefinition, startVariable);
            String currVariable = dslDefinition.substring(startVariable + 1, endVariable);
            DSLVariableValue value = (DSLVariableValue)dslValues.get(index);
            Widget varWidget = this.processVariable(currVariable, value);
            lineWidgets.add(varWidget);
            ++index;
            startVariable = dslDefinition.indexOf("{", endVariable);
            String lbl = startVariable > 0 ? dslDefinition.substring(endVariable + 1, startVariable) : dslDefinition.substring(endVariable + 1, dslDefinition.length());
            if (lbl.indexOf("\\n") > -1) {
                String[] lines = lbl.split("\\\\n");
                for (int i = 0; i < lines.length; ++i) {
                    lineWidgets.add(new NewLine());
                    lineWidgets.add(this.getLabel(lines[i]));
                }
                continue;
            }
            Widget currLabel = this.getLabel(lbl);
            lineWidgets.add(currLabel);
        }
        for (Widget widg : lineWidgets) {
            this.addWidget(widg);
        }
        this.updateEnumDropDowns();
    }

    private int getIndexForEndOfVariable(String dsl, int start) {
        int end = -1;
        int bracketCount = 0;
        if (start > dsl.length()) {
            return end;
        }
        for (int i = start; i < dsl.length(); ++i) {
            char c = dsl.charAt(i);
            if (c == '{') {
                ++bracketCount;
            }
            if (c != '}' || --bracketCount != 0) continue;
            end = i;
            return end;
        }
        return -1;
    }

    public Widget processVariable(String currVariable, DSLVariableValue value) {
        Widget result = null;
        if (currVariable.contains(":")) {
            if (currVariable.contains(":ENUM:")) {
                result = this.getEnumDropdown(currVariable, value);
            } else if (currVariable.contains(":DATE:")) {
                result = this.getDateSelector(currVariable, value);
            } else if (currVariable.contains(":BOOLEAN:")) {
                result = this.getCheckbox(currVariable, value);
            } else if (currVariable.contains(":CF:")) {
                result = this.getCustomFormEditor(currVariable, value);
            } else {
                String regex = currVariable.substring(currVariable.indexOf(":") + 1, currVariable.length());
                result = this.getBox(value, regex);
            }
        } else {
            result = this.getBox(value, "");
        }
        return result;
    }

    public Widget getEnumDropdown(String variableDef, DSLVariableValue value) {
        DSLDropDown resultWidget = new DSLDropDown(variableDef, value);
        this.dropDownWidgets.add(resultWidget);
        return resultWidget;
    }

    public Widget getBox(DSLVariableValue variableDef, String regex) {
        return this.getBox(variableDef, regex, false);
    }

    public Widget getBox(DSLVariableValue variableDef, String regex, boolean readonly) {
        FieldEditor currentBox = new FieldEditor();
        currentBox.setVisibleLength(variableDef.getValue().length() + 1);
        currentBox.setValue(variableDef);
        currentBox.setRestriction(regex);
        currentBox.box.setEnabled(!readonly);
        return currentBox;
    }

    public Widget getCheckbox(String variableDef, DSLVariableValue value) {
        return new DSLCheckBox(variableDef, value);
    }

    public Widget getCustomFormEditor(String variableDef, DSLVariableValue value) {
        int lastIndex = variableDef.lastIndexOf(":");
        String factAndField = variableDef.substring(lastIndex + 1, variableDef.length());
        int dotIndex = factAndField.indexOf(".");
        String pkg = this.getModeller().getAsset().getMetaData().getModuleName();
        String factType = factAndField.substring(0, dotIndex);
        String field = factAndField.substring(dotIndex + 1, factAndField.length());
        CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(pkg, factType, field);
        boolean editorReadOnly = this.readOnly;
        if (!editorReadOnly) {
            boolean bl = editorReadOnly = !this.getModeller().getSuggestionCompletions().containsFactType(factType);
        }
        if (customFormConfiguration != null) {
            return new DSLCustomFormButton(variableDef, value, customFormConfiguration, editorReadOnly);
        }
        return this.getBox(value, "", editorReadOnly);
    }

    public Widget getDateSelector(String variableDef, DSLVariableValue value) {
        String[] parts = variableDef.split(":DATE:");
        return new DSLDateSelector(value, parts[1]);
    }

    public Widget getLabel(String labelDef) {
        SmallLabel label = new SmallLabel();
        label.setText(labelDef.trim());
        return label;
    }

    private void addWidget(Widget currentBox) {
        if (currentBox instanceof NewLine) {
            this.currentRow = new HorizontalPanel();
            this.layout.add((Widget)this.currentRow);
            this.layout.setCellWidth((Widget)this.currentRow, "100%");
        } else {
            this.currentRow.add(currentBox);
        }
        this.widgets.add(currentBox);
    }

    protected void updateSentence() {
        int iVariable = 0;
        for (Widget wid : this.widgets) {
            if (!(wid instanceof DSLVariableEditor)) continue;
            this.sentence.getValues().set(iVariable++, ((DSLVariableEditor)wid).getSelectedValue());
        }
        this.setModified(true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isFactTypeKnown() {
        return true;
    }

    private void updateEnumDropDowns() {
        this.updateSentence();
        for (DSLDropDown dd : this.dropDownWidgets) {
            dd.refreshDropDownData();
            this.updateSentence();
        }
    }

    class DSLDateSelector
    extends Composite
    implements DSLVariableEditor {
        DatePickerLabel resultWidget = null;

        public DSLDateSelector(DSLVariableValue selectedDate, String dateFormat) {
            this.resultWidget = new DatePickerLabel(selectedDate.getValue(), dateFormat);
            this.resultWidget.addValueChanged(new ValueChanged(){

                public void valueChanged(String newValue) {
                    DSLSentenceWidget.this.updateSentence();
                    DSLSentenceWidget.this.makeDirty();
                }
            });
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.resultWidget);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            return new DSLVariableValue(this.resultWidget.getDateString());
        }
    }

    class DSLCheckBox
    extends Composite
    implements DSLVariableEditor {
        ListBox resultWidget = new ListBox();

        public DSLCheckBox(String variableDef, DSLVariableValue value) {
            this.resultWidget.addItem("true");
            this.resultWidget.addItem("false");
            if (value.getValue().equalsIgnoreCase("true")) {
                this.resultWidget.setSelectedIndex(0);
            } else {
                this.resultWidget.setSelectedIndex(1);
            }
            this.resultWidget.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    DSLSentenceWidget.this.updateSentence();
                    DSLSentenceWidget.this.makeDirty();
                }
            });
            this.resultWidget.setVisible(true);
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.resultWidget);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            String value = this.resultWidget.getSelectedIndex() == 0 ? "true" : "false";
            return new DSLVariableValue(value);
        }
    }

    class DSLCustomFormButton
    extends DirtyableComposite
    implements DSLVariableEditor {
        private DSLVariableValue selectedValue;
        private CustomFormConfiguration customFormConfiguration;
        private Button btnCustomForm;

        public DSLCustomFormButton(String variableDef, DSLVariableValue value, CustomFormConfiguration customFormConfiguration, boolean readonly) {
            this.customFormConfiguration = customFormConfiguration;
            this.selectedValue = value;
            this.btnCustomForm = new Button(this.selectedValue.getValue());
            this.btnCustomForm.setEnabled(!readonly);
            if (!readonly) {
                this.btnCustomForm.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final CustomFormPopUp customFormPopUp = new CustomFormPopUp(DroolsGuvnorImages.INSTANCE.Wizard(), Constants.INSTANCE.FieldValue(), DSLCustomFormButton.this.customFormConfiguration);
                        customFormPopUp.addOkButtonHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                String id = customFormPopUp.getFormId();
                                String value = customFormPopUp.getFormValue();
                                DSLCustomFormButton.this.btnCustomForm.setText(value);
                                DSLCustomFormButton.this.selectedValue = (DSLVariableValue)new DSLComplexVariableValue(id, value);
                                DSLSentenceWidget.this.updateSentence();
                                DSLCustomFormButton.this.makeDirty();
                                customFormPopUp.hide();
                            }
                        });
                        if (DSLCustomFormButton.this.selectedValue instanceof DSLComplexVariableValue) {
                            DSLComplexVariableValue complexSelectedValue = (DSLComplexVariableValue)DSLCustomFormButton.this.selectedValue;
                            customFormPopUp.show(complexSelectedValue.getId(), complexSelectedValue.getValue());
                        } else {
                            customFormPopUp.show("", DSLCustomFormButton.this.selectedValue.getValue());
                        }
                    }
                });
            }
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.btnCustomForm);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            return this.selectedValue;
        }
    }

    class DSLDropDown
    extends DirtyableComposite
    implements DSLVariableEditor {
        final SuggestionCompletionEngine completions;
        EnumDropDown resultWidget;
        String factType;
        String factField;
        DSLVariableValue selectedValue;

        public DSLDropDown(String variableDef, DSLVariableValue value) {
            this.completions = DSLSentenceWidget.this.getModeller().getSuggestionCompletions();
            this.resultWidget = null;
            int lastIndex = variableDef.lastIndexOf(":");
            String factAndField = variableDef.substring(lastIndex + 1, variableDef.length());
            int dotIndex = factAndField.indexOf(".");
            this.factType = factAndField.substring(0, dotIndex);
            this.factField = factAndField.substring(dotIndex + 1, factAndField.length());
            this.selectedValue = value;
            DropDownValueChanged handler = new DropDownValueChanged(){

                public void valueChanged(String newText, String newValue) {
                    DSLDropDown.this.makeDirty();
                    DSLDropDown.this.selectedValue = new DSLVariableValue(newValue);
                    DSLSentenceWidget.this.updateEnumDropDowns();
                }
            };
            DropDownData dropDownData = this.getDropDownData();
            this.resultWidget = new EnumDropDown(value.getValue(), handler, dropDownData);
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.resultWidget);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            int selectedIndex = this.resultWidget.getSelectedIndex();
            if (selectedIndex != -1) {
                return new DSLVariableValue(this.resultWidget.getValue(selectedIndex));
            }
            return new DSLVariableValue("");
        }

        public void refreshDropDownData() {
            this.resultWidget.setDropDownData(this.selectedValue.getValue(), this.getDropDownData());
        }

        private DropDownData getDropDownData() {
            DropDownData dropDownData = this.completions.getEnums(this.factType, this.factField, DSLSentenceWidget.this.sentence.getEnumFieldValueMap());
            return dropDownData;
        }
    }

    class FieldEditor
    extends DirtyableComposite
    implements DSLVariableEditor {
        private TextBox box = new TextBox();
        private String oldValue = "";
        private DSLVariableValue oldVariableValue;
        private String regex = "";

        public FieldEditor() {
            this.box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    TextBox otherBox = (TextBox)event.getSource();
                    if (!FieldEditor.this.regex.equals("") && !otherBox.getText().matches(FieldEditor.this.regex)) {
                        Window.alert((String)Constants.INSTANCE.TheValue0IsNotValidForThisField(otherBox.getText()));
                        FieldEditor.this.box.setText(FieldEditor.this.oldValue);
                    } else {
                        FieldEditor.this.oldValue = otherBox.getText();
                        DSLSentenceWidget.this.updateSentence();
                        FieldEditor.this.makeDirty();
                    }
                }
            });
            HorizontalPanel hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;"));
            hp.add((Widget)this.box);
            hp.add((Widget)new HTML("&nbsp;"));
            this.initWidget((Widget)hp);
        }

        public void setRestriction(String regex) {
            this.regex = regex;
        }

        public void setValue(DSLVariableValue value) {
            this.oldVariableValue = value;
            this.box.setText(value.getValue());
        }

        public void setVisibleLength(int l) {
            this.box.setVisibleLength(l);
        }

        @Override
        public DSLVariableValue getSelectedValue() {
            if (this.oldVariableValue instanceof DSLComplexVariableValue) {
                return new DSLComplexVariableValue(((DSLComplexVariableValue)this.oldVariableValue).getId(), this.box.getText());
            }
            return new DSLVariableValue(this.box.getText());
        }
    }

    static interface DSLVariableEditor {
        public DSLVariableValue getSelectedValue();
    }

    class NewLine
    extends Widget {
        NewLine() {
        }
    }
}

