/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.analysis.action.ActionDetector;
import org.drools.guvnor.client.decisiontable.analysis.action.ActionDetectorKey;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetector;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetectorKey;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;

public class RowDetector {
    private long rowIndex;
    private Map<ConditionDetectorKey, ConditionDetector> conditionDetectorMap = new LinkedHashMap<ConditionDetectorKey, ConditionDetector>();
    private Map<ActionDetectorKey, ActionDetector> actionDetectorMap = new LinkedHashMap<ActionDetectorKey, ActionDetector>();

    public RowDetector(long rowIndex) {
        this.rowIndex = rowIndex;
    }

    public long getRowIndex() {
        return this.rowIndex;
    }

    public ConditionDetector getConditionDetector(ConditionDetectorKey key) {
        return this.conditionDetectorMap.get(key);
    }

    public void putOrMergeConditionDetector(ConditionDetector conditionDetector) {
        ConditionDetectorKey key = conditionDetector.getKey();
        ConditionDetector originalConditionDetector = this.conditionDetectorMap.get(key);
        ConditionDetector mergedConditionDetector = originalConditionDetector == null ? conditionDetector : originalConditionDetector.merge(conditionDetector);
        this.conditionDetectorMap.put(key, mergedConditionDetector);
    }

    public ActionDetector getActionDetector(ActionDetectorKey key) {
        return this.actionDetectorMap.get(key);
    }

    public void putOrMergeActionDetector(ActionDetector actionDetector) {
        ActionDetectorKey key = actionDetector.getKey();
        ActionDetector originalActionDetector = this.actionDetectorMap.get(key);
        ActionDetector mergedActionDetector = originalActionDetector == null ? actionDetector : originalActionDetector.merge(actionDetector);
        this.actionDetectorMap.put(key, mergedActionDetector);
    }

    public Analysis buildAnalysis(List<RowDetector> rowDetectorList) {
        Analysis analysis = new Analysis();
        this.detectImpossibleMatch(analysis);
        this.detectMultipleValuesForOneAction(analysis);
        for (RowDetector otherRowDetector : rowDetectorList) {
            if (this == otherRowDetector) continue;
            this.detectConflict(analysis, otherRowDetector);
        }
        return analysis;
    }

    private void detectImpossibleMatch(Analysis analysis) {
        for (Map.Entry<ConditionDetectorKey, ConditionDetector> entry : this.conditionDetectorMap.entrySet()) {
            ConditionDetectorKey key = entry.getKey();
            ConditionDetector conditionDetector = entry.getValue();
            if (!conditionDetector.isImpossibleMatch()) continue;
            analysis.addImpossibleMatch("Impossible match on " + key.getFactField());
        }
    }

    private void detectMultipleValuesForOneAction(Analysis analysis) {
        for (Map.Entry<ActionDetectorKey, ActionDetector> entry : this.actionDetectorMap.entrySet()) {
            ActionDetectorKey key = entry.getKey();
            ActionDetector actionDetector = entry.getValue();
            if (!actionDetector.isMultipleValuesForOneAction()) continue;
            analysis.addMultipleValuesForOneAction("Multiple values for one action.");
        }
    }

    private void detectConflict(Analysis analysis, RowDetector otherRowDetector) {
        boolean overlappingCondition = true;
        boolean hasUnrecognizedCondition = false;
        for (Map.Entry<ConditionDetectorKey, ConditionDetector> entry : this.conditionDetectorMap.entrySet()) {
            ConditionDetectorKey key = entry.getKey();
            ConditionDetector conditionDetector = entry.getValue();
            ConditionDetector otherConditionDetector = otherRowDetector.getConditionDetector(key);
            if (otherConditionDetector == null) continue;
            ConditionDetector mergedConditionDetector = conditionDetector.merge(otherConditionDetector);
            if (mergedConditionDetector.isImpossibleMatch()) {
                overlappingCondition = false;
            }
            if (!mergedConditionDetector.hasUnrecognizedConstraint()) continue;
            hasUnrecognizedCondition = true;
        }
        if (overlappingCondition) {
            boolean multipleValuesForOneAction = false;
            boolean duplicatedAction = false;
            for (Map.Entry<ActionDetectorKey, ActionDetector> entry : this.actionDetectorMap.entrySet()) {
                ActionDetectorKey key = entry.getKey();
                ActionDetector actionDetector = entry.getValue();
                ActionDetector otherActionDetector = otherRowDetector.getActionDetector(key);
                if (otherActionDetector == null) continue;
                ActionDetector mergedActionDetector = actionDetector.merge(otherActionDetector);
                if (mergedActionDetector.isMultipleValuesForOneAction()) {
                    multipleValuesForOneAction = true;
                }
                if (!mergedActionDetector.isDuplicated()) continue;
                duplicatedAction = true;
            }
            if (multipleValuesForOneAction) {
                if (!hasUnrecognizedCondition) {
                    analysis.addConflictingMatch("Conflicting match with row " + (otherRowDetector.getRowIndex() + 1L));
                } else {
                    System.out.println("Possible conflicting match with row " + (otherRowDetector.getRowIndex() + 1L));
                }
            } else if (duplicatedAction) {
                if (!hasUnrecognizedCondition) {
                    analysis.addDuplicatedMatch("Duplicated match with row " + (otherRowDetector.getRowIndex() + 1L));
                } else {
                    System.out.println("Possible duplicated match with row " + (otherRowDetector.getRowIndex() + 1L));
                }
            }
        }
    }
}

