/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import org.drools.guvnor.client.common.NumericTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericEditCell
extends AbstractPopupEditCell<BigDecimal, BigDecimal> {
    private final TextBox textBox = new NumericTextBox();

    public PopupNumericEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupNumericEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, BigDecimal value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toPlainString()));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        BigDecimal number = null;
        if (text.length() > 0) {
            try {
                number = new BigDecimal(text);
            }
            catch (NumberFormatException e) {
                number = new BigDecimal(0);
            }
        }
        this.setValue(this.lastContext, this.lastParent, number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, BigDecimal value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toPlainString()));
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupNumericEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupNumericEditCell.this.offsetX, parent.getAbsoluteTop() + PopupNumericEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupNumericEditCell.this.textBox.getValue();
                        PopupNumericEditCell.this.textBox.setFocus(true);
                        PopupNumericEditCell.this.textBox.setCursorPos(text.length());
                        PopupNumericEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

