/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.explorer.navigation.qa.VerifierResultWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.VerificationServiceAsync;

public class VerifierScreen
extends Composite {
    private final VerticalPanel layout = new VerticalPanel();
    private final String packageUUID;

    public VerifierScreen(String packageUUID, String packageName) {
        this.packageUUID = packageUUID;
        PrettyFormLayout pf = new PrettyFormLayout();
        VerticalPanel vert = new VerticalPanel();
        String m = Constants.INSTANCE.AnalysingPackage(packageName);
        vert.add((Widget)new HTML(m));
        Button run = new Button(Constants.INSTANCE.RunAnalysis());
        run.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                VerifierScreen.this.runAnalysis();
            }
        });
        vert.add((Widget)run);
        pf.addHeader(GuvnorImages.INSTANCE.Analyze(), (Widget)vert);
        this.layout.add((Widget)pf);
        this.layout.add((Widget)new Label());
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
    }

    private void runAnalysis() {
        LoadingPopup.showMessage((String)Constants.INSTANCE.AnalysingPackageRunning());
        VerificationServiceAsync verificationService = (VerificationServiceAsync)GWT.create(VerificationService.class);
        verificationService.analysePackage(this.packageUUID, (AsyncCallback<AnalysisReport>)new GenericCallback<AnalysisReport>(){

            public void onSuccess(AnalysisReport rep) {
                VerifierResultWidget w = new VerifierResultWidget(rep, true);
                w.setWidth("100%");
                VerifierScreen.this.layout.remove(1);
                VerifierScreen.this.layout.add((Widget)w);
                LoadingPopup.close();
            }
        });
    }
}

