/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.NewAssetWithContentConfiguration;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.widgets.drools.wizards.assets.NewAssetWizardContext;
import org.drools.guvnor.client.widgets.wizards.AbstractWizard;
import org.drools.guvnor.client.widgets.wizards.WizardActivityView;
import org.drools.guvnor.client.widgets.wizards.WizardContext;
import org.drools.guvnor.shared.api.PortableObject;

public abstract class AbstractNewAssetWizard<T extends PortableObject>
extends AbstractWizard<NewAssetWizardContext> {
    public AbstractNewAssetWizard(ClientFactory clientFactory, EventBus eventBus, NewAssetWizardContext context, WizardActivityView.Presenter presenter) {
        super(clientFactory, eventBus, (WizardContext)context, presenter);
    }

    protected void save(NewAssetWithContentConfiguration<? extends PortableObject> config, T content) {
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.createNewRule(config, this.createCreateAssetCallback(content));
    }

    protected GenericCallback<String> createCreateAssetCallback(T content) {
        GenericCallback<String> cb = new GenericCallback<String>(){

            public void onSuccess(String uuid) {
                AbstractNewAssetWizard.this.presenter.hideSavingIndicator();
                if (uuid == null) {
                    AbstractNewAssetWizard.this.presenter.showUnspecifiedCheckinError();
                    return;
                }
                if (uuid.startsWith("DUPLICATE")) {
                    AbstractNewAssetWizard.this.presenter.showDuplicateAssetNameError();
                    return;
                }
                if (uuid.startsWith("ERR")) {
                    AbstractNewAssetWizard.this.presenter.showCheckinError(uuid.substring(5));
                    return;
                }
                AbstractNewAssetWizard.this.presenter.hide();
                AbstractNewAssetWizard.this.openEditor(uuid);
            }
        };
        return cb;
    }

    protected void openEditor(String uuid) {
        this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(uuid));
    }
}

