/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class RepositoryEnvironmentConfigurations {
    private Map<String, Object> configurationMap = new HashMap<String, Object>();

    public Map<String, Object> getConfigurationMap() {
        return this.configurationMap;
    }

    public List<RepositoryEnvironmentConfiguration> getConfigurationList() {
        ArrayList<RepositoryEnvironmentConfiguration> list = new ArrayList<RepositoryEnvironmentConfiguration>();
        for (Map.Entry<String, Object> entry : this.configurationMap.entrySet()) {
            list.add(new RepositoryEnvironmentConfiguration(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    public boolean containsConfiguration(String configurationName) {
        return this.configurationMap.containsKey(configurationName);
    }

    public void setManaged(boolean managed) {
        this.configurationMap.put("managed", managed);
    }

    public void setOrigin(String origin) {
        this.configurationMap.put("origin", origin);
    }

    public void setUserName(String user) {
        this.configurationMap.put("username", user);
    }

    public void setPassword(String password) {
        this.configurationMap.put("crypt:password", password);
    }

    public void setInit(boolean init) {
        this.configurationMap.put("init", init);
    }

    public Boolean isManaged() {
        return (Boolean)this.configurationMap.get("managed");
    }

    public Object getUserName() {
        return this.configurationMap.get("username");
    }

    public Object getPassword() {
        return this.configurationMap.get("crypt:password");
    }

    public Object getOrigin() {
        return this.configurationMap.get("origin");
    }
}

