/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.List;
import java.util.Map;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;

public class CurrentStateComputationStage
extends AbstractBaseStage {
    @Override
    public void process(ClusterEvent event) throws Exception {
        String instanceName;
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        if (cache == null || resourceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        CurrentStateOutput currentStateOutput = new CurrentStateOutput();
        for (LiveInstance instance : liveInstances.values()) {
            instanceName = instance.getInstanceName();
            Map<String, Message> instanceMessages = cache.getMessages(instanceName);
            for (Message message : instanceMessages.values()) {
                String resourceName;
                Resource resource;
                if (!Message.MessageType.STATE_TRANSITION.toString().equalsIgnoreCase(message.getMsgType()) || !instance.getSessionId().equals(message.getTgtSessionId()) || (resource = (Resource)resourceMap.get(resourceName = message.getResourceName())) == null) continue;
                if (!message.getBatchMessageMode()) {
                    String partitionName = message.getPartitionName();
                    Partition partition = resource.getPartition(partitionName);
                    if (partition == null) continue;
                    currentStateOutput.setPendingState(resourceName, partition, instanceName, message);
                    continue;
                }
                List<String> partitionNames = message.getPartitionNames();
                if (partitionNames.isEmpty()) continue;
                for (String partitionName : partitionNames) {
                    Partition partition = resource.getPartition(partitionName);
                    if (partition == null) continue;
                    currentStateOutput.setPendingState(resourceName, partition, instanceName, message);
                }
            }
        }
        for (LiveInstance instance : liveInstances.values()) {
            instanceName = instance.getInstanceName();
            String clientSessionId = instance.getSessionId();
            Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, clientSessionId);
            for (CurrentState currentState : currentStateMap.values()) {
                if (!instance.getSessionId().equals(currentState.getSessionId())) continue;
                String resourceName = currentState.getResourceName();
                String stateModelDefName = currentState.getStateModelDefRef();
                Resource resource = (Resource)resourceMap.get(resourceName);
                if (resource == null) continue;
                if (stateModelDefName != null) {
                    currentStateOutput.setResourceStateModelDef(resourceName, stateModelDefName);
                }
                currentStateOutput.setBucketSize(resourceName, currentState.getBucketSize());
                Map<String, String> partitionStateMap = currentState.getPartitionStateMap();
                for (String partitionName : partitionStateMap.keySet()) {
                    Partition partition = resource.getPartition(partitionName);
                    if (partition == null) continue;
                    currentStateOutput.setCurrentState(resourceName, partition, instanceName, currentState.getState(partitionName));
                    currentStateOutput.setRequestedState(resourceName, partition, instanceName, currentState.getRequestedState(partitionName));
                    currentStateOutput.setInfo(resourceName, partition, instanceName, currentState.getInfo(partitionName));
                }
            }
        }
        event.addAttribute(AttributeName.CURRENT_STATE.toString(), currentStateOutput);
    }
}

