/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LengthFilterFactory
extends TokenFilterFactory {
    int min;
    int max;
    boolean enablePositionIncrements;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String minKey = args.get(MIN_KEY);
        String maxKey = args.get(MAX_KEY);
        if (minKey == null || maxKey == null) {
            throw new IllegalArgumentException("Both min and max are mandatory");
        }
        this.min = Integer.parseInt(minKey);
        this.max = Integer.parseInt(maxKey);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
    }

    public LengthFilter create(TokenStream input) {
        return new LengthFilter(this.enablePositionIncrements, input, this.min, this.max);
    }
}

