/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;

public class DataObjectImpl
extends JavaClassImpl
implements DataObject {
    private List<ObjectProperty> properties = new ArrayList<ObjectProperty>();

    public DataObjectImpl() {
    }

    public DataObjectImpl(String packageName, String name) {
        super(packageName, name, Visibility.PUBLIC);
    }

    public DataObjectImpl(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal) {
        super(packageName, name, visibility, isAbstract, isFinal);
    }

    @Override
    public List<ObjectProperty> getProperties() {
        return this.properties;
    }

    @Override
    public ObjectProperty addProperty(String name, String className) {
        return this.addProperty(name, className, false);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, Visibility visibility, boolean isStatic, boolean isFinal) {
        return this.addProperty(name, className, false, visibility, isStatic, isFinal);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple) {
        return this.addProperty(name, className, multiple, Visibility.PUBLIC, false, false);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, String bag) {
        return this.addProperty(name, className, multiple, bag, Visibility.PUBLIC, false, false);
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, Visibility visibility, boolean isStatic, boolean isFinal) {
        return this.addProperty(new ObjectPropertyImpl(name, className, multiple, visibility, isStatic, isFinal));
    }

    @Override
    public ObjectProperty addProperty(String name, String className, boolean multiple, String bag, Visibility visibility, boolean isStatic, boolean isFinal) {
        ObjectPropertyImpl property = new ObjectPropertyImpl(name, className, multiple, bag, visibility, isStatic, isFinal);
        return this.addProperty(property);
    }

    @Override
    public ObjectProperty addProperty(ObjectProperty property) {
        if (property == null) {
            return null;
        }
        this.removeProperty(property.getName());
        this.properties.add(property);
        return property;
    }

    @Override
    public ObjectProperty removeProperty(String name) {
        ObjectProperty removedProperty = this.getProperty(name);
        if (removedProperty != null) {
            this.properties.remove(removedProperty);
        }
        return removedProperty;
    }

    @Override
    public ObjectProperty getProperty(String name) {
        if (name == null) {
            return null;
        }
        for (ObjectProperty property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public ObjectProperty getUnManagedProperty(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        for (ObjectProperty property : this.getUnmanagedProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public List<ObjectProperty> getUnmanagedProperties() {
        return new ArrayList<ObjectProperty>();
    }

    @Override
    public boolean hasProperty(String name) {
        if (name == null) {
            return false;
        }
        for (ObjectProperty property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataObjectImpl that = (DataObjectImpl)o;
        return !(this.properties == null ? that.properties != null : !this.properties.equals(that.properties));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

