/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.IdentifierDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.JavaTokenDescr;

public class ImportDescr
extends ElementDescriptor {
    public ImportDescr() {
        super(ElementDescriptor.ElementType.IMPORT);
    }

    public ImportDescr(String text, int start, int line, int position) {
        this(text, start, -1, line, position);
    }

    public ImportDescr(String text, int start, int stop) {
        this(text, start, stop, -1, -1);
    }

    public ImportDescr(String text, int start, int stop, int line, int position) {
        super(ElementDescriptor.ElementType.IMPORT, text, start, stop, line, position);
    }

    public boolean isStaticImport() {
        return this.getStaticToken() != null;
    }

    public boolean isStarImport() {
        return this.getStarToken() != null;
    }

    public JavaTokenDescr getImportToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_IMPORT);
    }

    public void setImportToken(JavaTokenDescr importToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_IMPORT);
        this.getElements().add(importToken);
    }

    public JavaTokenDescr getStaticToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_STATIC);
    }

    public void setStaticToken(JavaTokenDescr staticToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_STATIC);
        this.getElements().add(staticToken);
    }

    public void addPart(IdentifierDescr identifierDescr) {
        this.getElements().add(identifierDescr);
    }

    public List<IdentifierDescr> getParts() {
        ArrayList<IdentifierDescr> identifiers = new ArrayList<IdentifierDescr>();
        for (ElementDescriptor identifier : this.getElements().getElementsByType(ElementDescriptor.ElementType.IDENTIFIER)) {
            identifiers.add((IdentifierDescr)identifier);
        }
        return identifiers;
    }

    public void setStarToken(JavaTokenDescr starToken) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_STAR);
        this.getElements().add(starToken);
    }

    public JavaTokenDescr getStarToken() {
        return (JavaTokenDescr)this.getElements().getFirst(ElementDescriptor.ElementType.JAVA_STAR);
    }

    public JavaTokenDescr getEndSemiColon() {
        return (JavaTokenDescr)this.getElements().getLast(ElementDescriptor.ElementType.JAVA_SEMI_COLON);
    }

    public ImportDescr setEndSemiColon(JavaTokenDescr element) {
        this.getElements().removeFirst(ElementDescriptor.ElementType.JAVA_SEMI_COLON);
        this.getElements().add(element);
        return this;
    }

    public String getName(boolean includeStar) {
        StringBuilder nameBuilder = new StringBuilder();
        boolean first = true;
        for (IdentifierDescr identifier : this.getParts()) {
            if (!first) {
                nameBuilder.append(".");
            }
            nameBuilder.append(identifier.getIdentifier());
            first = false;
        }
        if (!first && includeStar && this.isStarImport()) {
            nameBuilder.append(".*");
        }
        return nameBuilder.toString();
    }
}

