/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.SecurityServiceAsync;

public class LoginWidget {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private Command loggedInEvent;
    private String userNameLoggedIn;

    public void show() {
        Image image = new Image(images.login());
        image.setAltText(ConstantsCore.INSTANCE.Login());
        final FormStylePopup pop = new FormStylePopup(image, this.constants.Login());
        final TextBox userName = new TextBox();
        pop.addAttribute(this.constants.UserName(), (Widget)userName);
        final PasswordTextBox password = new PasswordTextBox();
        pop.addAttribute(this.constants.Password(), (Widget)password);
        KeyPressHandler kph = new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (13 == event.getNativeEvent().getKeyCode()) {
                    LoginWidget.this.doLogin(userName, password, pop);
                }
            }
        };
        userName.addKeyPressHandler(kph);
        password.addKeyPressHandler(kph);
        Button b = new Button(this.constants.OK());
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoginWidget.this.doLogin(userName, password, pop);
            }
        });
        pop.addAttribute("", (Widget)b);
        pop.setAfterShow(new Command(){

            public void execute() {
                Scheduler scheduler = Scheduler.get();
                scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                    public void execute() {
                        userName.setFocus(true);
                    }
                });
            }
        });
        pop.show();
    }

    private void doLogin(final TextBox userName, PasswordTextBox password, final FormStylePopup pop) {
        LoadingPopup.showMessage(this.constants.Authenticating());
        SecurityServiceAsync.INSTANCE.login(userName.getText(), password.getText(), new GenericCallback(){

            public void onSuccess(Object o) {
                LoginWidget.this.userNameLoggedIn = userName.getText();
                LoadingPopup.close();
                Boolean success = (Boolean)o;
                if (!success.booleanValue()) {
                    Window.alert((String)LoginWidget.this.constants.IncorrectUsernameOrPassword());
                } else {
                    LoginWidget.this.loggedInEvent.execute();
                    pop.hide();
                }
            }
        });
    }

    public String getUserName() {
        return this.userNameLoggedIn;
    }

    public void setLoggedInEvent(Command loggedInEvent) {
        this.loggedInEvent = loggedInEvent;
    }
}

