/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.BusinessProcessEditor;
import org.drools.guvnor.client.asseteditor.FormEditor;
import org.drools.guvnor.client.asseteditor.GuvnorEditor;
import org.drools.guvnor.client.asseteditor.RuleViewerSettings;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Asset;

public class RuleViewer
extends GuvnorEditor {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private static RuleViewerBinder uiBinder = (RuleViewerBinder)GWT.create(RuleViewerBinder.class);
    @UiField(provided=true)
    final Widget editor;
    protected Asset asset;
    private long lastSaved = System.currentTimeMillis();

    public RuleViewer(Asset asset, ClientFactory clientFactory, EventBus eventBus) {
        this(asset, clientFactory, eventBus, null);
    }

    public RuleViewer(Asset asset, ClientFactory clientFactory, EventBus eventBus, boolean historicalReadOnly) {
        this(asset, clientFactory, eventBus, null);
    }

    public RuleViewer(Asset asset, ClientFactory clientFactory, EventBus eventBus, RuleViewerSettings ruleViewerSettings) {
        this.asset = asset;
        RuleViewerSettings ruleViewerSettings1 = ruleViewerSettings == null ? new RuleViewerSettings() : ruleViewerSettings;
        this.editor = clientFactory.getAssetEditorFactory().getAssetEditor(asset, this, clientFactory, eventBus);
        if (this.editor instanceof BusinessProcessEditor) {
            if (ruleViewerSettings1.isStandalone()) {
                this.editor.setWidth("100%");
                this.editor.setHeight("1000px");
            } else {
                this.editor.setWidth("100%");
                this.editor.setHeight("580px");
            }
        }
        if (this.editor instanceof FormEditor) {
            if (ruleViewerSettings1.isStandalone()) {
                this.editor.setWidth("100%");
                this.editor.setHeight("1000px");
            } else {
                this.editor.setWidth("100%");
                this.editor.setHeight("580px");
            }
        }
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.setWidth("100%");
        LoadingPopup.close();
    }

    public Widget getAssetEditor() {
        return this.editor;
    }

    @Override
    public boolean isDirty() {
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    static interface RuleViewerBinder
    extends UiBinder<Widget, RuleViewer> {
    }
}

