/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.ruleflow;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.ruleflow.ActionNode;
import org.drools.guvnor.client.asseteditor.ruleflow.CompositeNode;
import org.drools.guvnor.client.asseteditor.ruleflow.DefaultWorkItemNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ElementContainerNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ElementContainerTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EmailNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EndNode;
import org.drools.guvnor.client.asseteditor.ruleflow.EventNode;
import org.drools.guvnor.client.asseteditor.ruleflow.FaultNode;
import org.drools.guvnor.client.asseteditor.ruleflow.ForEachNode;
import org.drools.guvnor.client.asseteditor.ruleflow.HumanTaskNode;
import org.drools.guvnor.client.asseteditor.ruleflow.HumanTaskTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.JoinNode;
import org.drools.guvnor.client.asseteditor.ruleflow.LogNode;
import org.drools.guvnor.client.asseteditor.ruleflow.MileStoneNode;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowBaseNode;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowConnectionFactory;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowRoundPanel;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleFlowRoundedPanel;
import org.drools.guvnor.client.asseteditor.ruleflow.RuleSetNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SplitTransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.StartNode;
import org.drools.guvnor.client.asseteditor.ruleflow.SubProcessNode;
import org.drools.guvnor.client.asseteditor.ruleflow.TimerNode;
import org.drools.guvnor.client.asseteditor.ruleflow.TransferConnection;
import org.drools.guvnor.client.asseteditor.ruleflow.TransferNode;
import org.drools.guvnor.client.asseteditor.ruleflow.WorkItemNode;
import org.drools.guvnor.client.asseteditor.ruleflow.WorkItemTransferNode;
import pl.balon.gwt.diagrams.client.connection.Connection;

public class RuleFlowNodeFactory {
    public static RuleFlowBaseNode createNode(TransferNode tn) {
        RuleFlowBaseNode n;
        if (tn.getType() == TransferNode.Type.START) {
            n = new StartNode();
        } else if (tn.getType() == TransferNode.Type.HUMANTASK) {
            n = RuleFlowNodeFactory.createHumanTask((HumanTaskTransferNode)tn);
        } else if (tn.getType() == TransferNode.Type.JOIN) {
            n = new JoinNode();
        } else if (tn.getType() == TransferNode.Type.SUB_PROCESS) {
            n = new SubProcessNode();
        } else if (tn.getType() == TransferNode.Type.MILESTONE) {
            n = new MileStoneNode();
        } else if (tn.getType() == TransferNode.Type.TIMER) {
            n = new TimerNode();
        } else if (tn.getType() == TransferNode.Type.ACTION_NODE) {
            n = new ActionNode();
        } else if (tn.getType() == TransferNode.Type.WORK_ITEM) {
            n = RuleFlowNodeFactory.createWorkItemNode((WorkItemTransferNode)tn);
        } else if (tn.getType() == TransferNode.Type.RULESET) {
            n = new RuleSetNode();
        } else if (tn.getType() == TransferNode.Type.SPLIT) {
            n = RuleFlowNodeFactory.createSplit((SplitTransferNode)tn);
        } else if (tn.getType() == TransferNode.Type.FOR_EACH) {
            n = RuleFlowNodeFactory.createElementContainerNode(new ForEachNode(), (ElementContainerTransferNode)tn);
        } else if (tn.getType() == TransferNode.Type.FAULT) {
            n = new FaultNode();
        } else if (tn.getType() == TransferNode.Type.EVENT) {
            n = new EventNode();
        } else if (tn.getType() == TransferNode.Type.COMPOSITE) {
            n = RuleFlowNodeFactory.createElementContainerNode(new CompositeNode(), (ElementContainerTransferNode)tn);
        } else if (tn.getType() == TransferNode.Type.END) {
            n = new EndNode();
        } else {
            throw new IllegalArgumentException("Unkown node type " + tn);
        }
        RuleFlowNodeFactory.fillRuleFlowBaseNode(n, tn);
        return n;
    }

    private static RuleFlowBaseNode createElementContainerNode(ElementContainerNode node, ElementContainerTransferNode tn) {
        for (TransferNode subNode : tn.getContentModel().getNodes()) {
            RuleFlowBaseNode baseNode = RuleFlowNodeFactory.createNode(subNode);
            node.getNodes().put(baseNode.getId(), baseNode);
        }
        for (TransferConnection c : tn.getContentModel().getConnections()) {
            try {
                node.getConnections().add(RuleFlowConnectionFactory.createConnection(c, node.getNodes()));
            }
            catch (RuntimeException e) {}
        }
        return node;
    }

    private static RuleFlowBaseNode createWorkItemNode(WorkItemTransferNode node) {
        WorkItemNode workItemNode = null;
        workItemNode = node.getWorkName().equals("Email") ? new EmailNode() : (node.getWorkName().equals("Log") ? new LogNode() : new DefaultWorkItemNode());
        workItemNode.setAttributes(node.getParameters());
        return workItemNode;
    }

    private static RuleFlowBaseNode createSplit(SplitTransferNode tn) {
        SplitNode splitNode = new SplitNode();
        splitNode.type = tn.getSplitType();
        splitNode.constraints = tn.getConstraints();
        return splitNode;
    }

    private static RuleFlowBaseNode createHumanTask(HumanTaskTransferNode node) {
        HumanTaskNode n = new HumanTaskNode();
        n.setAttributes(node.getParameters());
        return n;
    }

    private static void fillRuleFlowBaseNode(RuleFlowBaseNode node, TransferNode tn) {
        RuleFlowNodeFactory.fillIdAndCoordinates(node, tn);
        Widget panel = node.getImagePath() == null ? RuleFlowNodeFactory.createContentWithoutImage(tn.getName(), node, tn.getWidth()) : RuleFlowNodeFactory.createContentWithImage(tn.getName(), node, tn.getWidth());
        if (node.getCorners() == RuleFlowBaseNode.Corners.ROUNDED) {
            int cornerHeight = LayoutCalculator.calculateCornerHeight(tn.getWidth());
            panel.setHeight(LayoutCalculator.calculateNodeHeight(tn.getHeight(), cornerHeight) + "px");
            RuleFlowRoundedPanel rp = new RuleFlowRoundedPanel(15, 8);
            rp.setTopAndBottomRowColor("Black");
            rp.setCornerStyleName(node.getStyle());
            rp.add(panel);
            node.add((Widget)rp);
        } else if (node.getCorners() == RuleFlowBaseNode.Corners.ROUND) {
            int cornerHeight = LayoutCalculator.calculateRoundCornerHeight(tn.getWidth());
            panel.setHeight("1px");
            RuleFlowRoundPanel rp = new RuleFlowRoundPanel(cornerHeight);
            rp.setTopAndBottomRowColor("Black");
            rp.setCornerStyleName(node.getStyle());
            rp.add(panel);
            node.add((Widget)rp);
        } else {
            panel.setHeight(tn.getHeight() + "px");
            if (node instanceof ElementContainerNode) {
                AbsolutePanel ap = new AbsolutePanel();
                ElementContainerNode fen = (ElementContainerNode)node;
                for (RuleFlowBaseNode baseNode : fen.getNodes().values()) {
                    ap.add((Widget)baseNode, baseNode.getX(), baseNode.getY());
                }
                for (Connection c : fen.getConnections()) {
                    c.appendTo(ap);
                }
                ap.add(panel);
                node.add((Widget)ap);
            } else {
                node.add(panel);
            }
        }
    }

    private static Widget createContentWithoutImage(String name, RuleFlowBaseNode node, int width) {
        Label label = new Label(name);
        label.setStyleName(node.getStyle());
        label.setWidth(width + "px");
        return label;
    }

    private static Widget createContentWithImage(String name, RuleFlowBaseNode node, int width) {
        Label label = new Label(name);
        Image image = new Image();
        image.setStyleName("ruleflow-image");
        image.setResource(node.getImagePath());
        HorizontalPanel panel = new HorizontalPanel();
        panel.setStyleName(node.getStyle());
        panel.add((Widget)image);
        panel.add((Widget)label);
        panel.setWidth(width + "px");
        return panel;
    }

    protected static void fillIdAndCoordinates(RuleFlowBaseNode node, TransferNode tn) {
        node.addClickHandler(node);
        node.setId(tn.getId());
        node.setX(tn.getX());
        node.setY(tn.getY());
    }

    protected static class LayoutCalculator {
        protected LayoutCalculator() {
        }

        static int calculateNodeHeight(int height, int cornerHeight) {
            int newHeight = 0;
            newHeight = height < 2 * cornerHeight ? height : height - 2 * cornerHeight;
            return newHeight;
        }

        static int calculateCornerHeight(int width) {
            int newWidth = 1;
            newWidth = width < 8 ? width - 4 : (width <= 20 ? 6 : 8);
            if (newWidth <= 0) {
                return 1;
            }
            return newWidth;
        }

        static int calculateRoundCornerHeight(int width) {
            if (width < 44) {
                return width / 2 - 1;
            }
            return 16;
        }
    }
}

