/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ClickableTextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.drools.guvnor.client.resources.TableImageResources;
import org.drools.guvnor.client.widgets.tables.SortDirection;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class SortableHeader<T, C extends Comparable>
extends Header<String> {
    private static final String DOWN_ARROW = SortableHeader.makeImage(TableImageResources.INSTANCE.downArrow());
    private static final String SMALL_DOWN_ARROW = SortableHeader.makeImage(TableImageResources.INSTANCE.smallDownArrow());
    private static final String UP_ARROW = SortableHeader.makeImage(TableImageResources.INSTANCE.upArrow());
    private static final String SMALL_UP_ARROW = SortableHeader.makeImage(TableImageResources.INSTANCE.smallUpArrow());
    private final SortableHeaderGroup sortableHeaderGroup;
    private String text;
    private final Column<T, C> column;
    private SortDirection sortDirection = SortDirection.NONE;
    private int sortIndex = -1;

    private static String makeImage(ImageResource resource) {
        AbstractImagePrototype prototype = AbstractImagePrototype.create((ImageResource)resource);
        return prototype.getHTML();
    }

    public SortableHeader(SortableHeaderGroup sortableHeaderGroup, String text, Column<T, C> column) {
        super((Cell)new ClickableTextCell());
        this.sortableHeaderGroup = sortableHeaderGroup;
        this.text = text;
        this.column = column;
        this.setUpdater((ValueUpdater)new ValueUpdater<String>(){

            public void update(String s) {
                SortableHeader.this.sortableHeaderGroup.headerClicked(SortableHeader.this);
            }
        });
    }

    public String getValue() {
        return this.text;
    }

    public void setValue(String text) {
        this.text = text;
    }

    public Column<T, C> getColumn() {
        return this.column;
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void render(Cell.Context context, SafeHtmlBuilder sb) {
        sb.appendHtmlConstant("<div style='position: relative; cursor: pointer; padding: 0px;'>");
        sb.appendHtmlConstant("<span style='padding-right: 10px'>");
        sb.appendEscaped(this.text);
        sb.appendHtmlConstant("</span>");
        switch (this.sortDirection) {
            case NONE: {
                break;
            }
            case ASCENDING: {
                sb.appendHtmlConstant(this.sortIndex == 0 ? UP_ARROW : SMALL_UP_ARROW);
                break;
            }
            case DESCENDING: {
                sb.appendHtmlConstant(this.sortIndex == 0 ? DOWN_ARROW : SMALL_DOWN_ARROW);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sortDirection (" + (Object)((Object)this.sortDirection) + ").");
            }
        }
        sb.appendHtmlConstant("</div>");
    }
}

