/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.InboxPageRow;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.LogPageRow;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.NewAssetConfiguration;
import org.drools.guvnor.client.rpc.NewAssetWithContentConfiguration;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.PermissionsPageRow;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.QueryMetadataPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.StatePageRequest;
import org.drools.guvnor.client.rpc.StatePageRow;
import org.drools.guvnor.client.rpc.TableConfig;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.AssetTemplateCreator;
import org.drools.guvnor.server.Backchannel;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.ModuleFilter;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryModuleOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.PageResponseBuilder;
import org.drools.guvnor.server.builder.pagerow.InboxPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.LogPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.PermissionPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QueryFullTextPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.QueryMetadataPageRowBuilder;
import org.drools.guvnor.server.builder.pagerow.StatePageRowBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.repository.UserInbox;
import org.drools.guvnor.server.ruleeditor.springcontext.SpringContextElementsManager;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.RoleTypes;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.AssetPopulator;
import org.drools.guvnor.server.util.DateUtil;
import org.drools.guvnor.server.util.HtmlCleaner;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.UserInfo;
import org.drools.repository.security.PermissionManager;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.annotations.LoggedIn;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

@ApplicationScoped
public class ServiceImplementation
implements RepositoryService {
    private static final long serialVersionUID = 510L;
    private static final LoggingHelper log = LoggingHelper.getLogger(ServiceImplementation.class);
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private ServiceSecurity serviceSecurity;
    @Inject
    private RepositoryAssetOperations repositoryAssetOperations;
    @Inject
    private RepositoryAssetService repositoryAssetService;
    @Inject
    private RepositoryModuleOperations repositoryModuleOperations;
    @Inject
    private Backchannel backchannel;
    @Inject
    private Identity identity;

    @Override
    @WebRemote
    @LoggedIn
    public String[] listWorkspaces() {
        return this.rulesRepository.listWorkspaces();
    }

    @Override
    @WebRemote
    @LoggedIn
    public void createWorkspace(String workspace) {
        this.rulesRepository.createWorkspace(workspace);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeWorkspace(String workspace) {
        this.rulesRepository.removeWorkspace(workspace);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void updateWorkspace(String workspace, String[] selectedModules, String[] unselectedModules) {
        ModuleItem module;
        for (String moduleName : selectedModules) {
            module = this.rulesRepository.loadModule(moduleName);
            module.addWorkspace(workspace);
            module.checkin("Add workspace");
        }
        for (String moduleName : unselectedModules) {
            module = this.rulesRepository.loadModule(moduleName);
            module.removeWorkspace(workspace);
            module.checkin("Remove workspace");
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public String createNewRule(String ruleName, String description, String initialCategory, String initialPackage, String format) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(initialPackage);
        log.info("USER:" + this.getCurrentUserName() + " CREATING new asset name [" + ruleName + "] in package [" + initialPackage + "]");
        try {
            ModuleItem pkg = this.rulesRepository.loadModule(initialPackage);
            AssetItem asset = pkg.addAsset(ruleName, description, initialCategory, format);
            new AssetTemplateCreator().applyPreBuiltTemplates(ruleName, format, asset);
            this.rulesRepository.save();
            this.push("categoryChange", initialCategory);
            this.push("packageChange", pkg.getName());
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating new asset" + ruleName + "] in package [" + initialPackage + "]: ", e);
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public String createNewRule(NewAssetConfiguration configuration) throws SerializationException {
        String assetName = configuration.getAssetName();
        String description = configuration.getDescription();
        String initialCategory = configuration.getInitialCategory();
        String packageName = configuration.getPackageName();
        String format = configuration.getFormat();
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        return this.createNewRule(assetName, description, initialCategory, packageName, format);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String createNewRule(NewAssetWithContentConfiguration<? extends PortableObject> configuration) throws SerializationException {
        String assetName = configuration.getAssetName();
        String description = configuration.getDescription();
        String initialCategory = configuration.getInitialCategory();
        String packageName = configuration.getPackageName();
        String format = configuration.getFormat();
        PortableObject content = configuration.getContent();
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        log.info("USER:" + this.getCurrentUserName() + " CREATING new asset name [" + assetName + "] in package [" + packageName + "]");
        try {
            ModuleItem pkg = this.rulesRepository.loadModule(packageName);
            AssetItem assetItem = pkg.addAsset(assetName, description, initialCategory, format);
            Asset asset = new AssetPopulator().populateFrom(assetItem);
            ContentHandler handler = ContentManager.getHandler(assetItem.getFormat());
            asset.setContent(content);
            handler.storeAssetContent(asset, assetItem);
            this.rulesRepository.save();
            this.push("categoryChange", initialCategory);
            this.push("packageChange", pkg.getName());
            return assetItem.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating new asset [" + assetName + "] in package [" + packageName + "]: ", e);
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public String createNewImportedRule(String sharedAssetName, String initialPackage) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(initialPackage);
        log.info("USER:" + this.rulesRepository.getSession().getUserID() + " CREATING shared asset imported from global area named [" + sharedAssetName + "] in package [" + initialPackage + "]");
        try {
            ModuleItem packageItem = this.rulesRepository.loadModule(initialPackage);
            AssetItem asset = packageItem.addAssetImportedFromGlobalArea(sharedAssetName);
            this.rulesRepository.save();
            return asset.getUUID();
        }
        catch (RulesRepositoryException e) {
            if (e.getCause() instanceof ItemExistsException) {
                return "DUPLICATE";
            }
            log.error("An error occurred creating shared asset" + sharedAssetName + "] in package [" + initialPackage + "]: ", e);
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void deleteUncheckedRule(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithAdminType();
        AssetItem asset = this.rulesRepository.loadAssetByUUID(uuid);
        ModuleItem packageItem = asset.getModule();
        packageItem.updateBinaryUpToDate(false);
        asset.remove();
        this.rulesRepository.save();
        this.push("packageChange", packageItem.getName());
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult loadRuleListForState(String stateName, int skip, int numRows, String tableConfig) throws SerializationException {
        AssetItemFilter filter = new AssetItemFilter(this.identity);
        AssetItemPageResult result = this.rulesRepository.findAssetsByState(stateName, false, skip, numRows, (RepositoryFilter)filter);
        return new TableDisplayHandler(tableConfig).loadRuleListTable(result);
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableConfig loadTableConfig(String listName) {
        TableDisplayHandler handler = new TableDisplayHandler(listName);
        return handler.loadTableConfig();
    }

    @Override
    @WebRemote
    @LoggedIn
    public TableDataResult queryMetaData(final MetaDataQuery[] qr, Date createdAfter, Date createdBefore, Date modifiedAfter, Date modifiedBefore, boolean seekArchived, int skip, int numRows) throws SerializationException {
        if (numRows == 0) {
            throw new DetailedSerializationException("Unable to return zero results (bug)", "probably have the parameters around the wrong way, sigh...");
        }
        HashMap<String, String[]> q = new HashMap<String, String[]>(){
            {
                for (MetaDataQuery aQr : qr) {
                    String vals;
                    String string = vals = aQr.valueList == null ? "" : aQr.valueList.trim();
                    if (vals.length() <= 0) continue;
                    this.put(aQr.attribute, vals.split(",\\s?"));
                }
            }
        };
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", DateUtil.isoDate(createdAfter), DateUtil.isoDate(createdBefore)), new RulesRepository.DateQuery("drools:lastModified", DateUtil.isoDate(modifiedAfter), DateUtil.isoDate(modifiedBefore))};
        AssetItemIterator it = this.rulesRepository.query((Map)q, seekArchived, dates);
        ArrayList<AssetItem> resultList = new ArrayList<AssetItem>();
        ModuleFilter packageFilter = new ModuleFilter(this.identity);
        CategoryFilter categoryFilter = new CategoryFilter(this.identity);
        while (it.hasNext()) {
            AssetItem ai = it.next();
            if (!this.checkPackagePermissionHelper(packageFilter, ai, RoleType.PACKAGE_READONLY.getName()) && !this.checkCategoryPermissionHelper(categoryFilter, ai, RoleType.ANALYST_READ.getName())) continue;
            resultList.add(ai);
        }
        return new TableDisplayHandler("searchresults").loadRuleListTable(resultList, skip, numRows);
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getModule().getUUID()), roleType);
    }

    private Module getConfigDataHelper(String uuidStr) {
        Module data = new Module();
        data.setUuid(uuidStr);
        return data;
    }

    @Override
    @WebRemote
    @LoggedIn
    public String createState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " CREATING state: [" + name + "]");
        try {
            name = HtmlCleaner.cleanHTML(name);
            String uuid = this.rulesRepository.createState(name).getNode().getUUID();
            this.rulesRepository.save();
            return uuid;
        }
        catch (RepositoryException e) {
            throw new SerializationException("Unable to create the status.");
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeState(String name) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING state: [" + name + "]");
        try {
            this.rulesRepository.loadState(name).remove();
            this.rulesRepository.save();
        }
        catch (RulesRepositoryException e) {
            throw new DetailedSerializationException("Unable to remove status. It is probably still used (even by archived items).", e.getMessage());
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void renameState(String oldName, String newName) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " RENAMING state: [" + oldName + "] to [" + newName + "]");
        this.rulesRepository.renameState(oldName, newName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] listStates() throws SerializationException {
        StateItem[] states = this.rulesRepository.listStates();
        String[] result = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = states[i].getName();
        }
        return result;
    }

    @Override
    @WebRemote
    public void clearRulesRepository() {
        this.serviceSecurity.checkSecurityIsAdmin();
        RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(this.rulesRepository.getSession());
        admin.clearRulesRepository();
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] getCustomSelectors() throws SerializationException {
        return SelectorManager.getInstance().getCustomSelectors();
    }

    @WebRemote
    @LoggedIn
    public String[] listRulesInGlobalArea() throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName("globalArea");
        return this.repositoryModuleOperations.listRulesInPackage("globalArea");
    }

    @WebRemote
    @LoggedIn
    public String[] listImagesInGlobalArea() throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName("globalArea");
        return this.repositoryModuleOperations.listImagesInModule("globalArea");
    }

    @Override
    @WebRemote
    public LogEntry[] showLog() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return LoggingHelper.getMessages();
    }

    @Override
    @WebRemote
    public PageResponse<LogPageRow> showLog(PageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        this.serviceSecurity.checkSecurityIsAdmin();
        long start = System.currentTimeMillis();
        LogEntry[] logEntries = LoggingHelper.getMessages();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List<LogPageRow> rowList = new LogPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(logEntries).build();
        PageResponse<LogPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withTotalRowSizeExact().withLastPage(rowList.size() + request.getStartRowIndex() == logEntries.length).withTotalRowSize(logEntries.length).build();
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Retrieved Log Entries in " + methodDuration + " ms.");
        return response;
    }

    @Override
    @WebRemote
    public void cleanLog() {
        this.serviceSecurity.checkSecurityIsAdmin();
        LoggingHelper.cleanLog();
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] loadDropDownExpression(String[] valuePairs, String expression) {
        HashMap<String, String> context = new HashMap<String, String>();
        for (String valuePair : valuePairs) {
            if (valuePair == null) {
                return new String[0];
            }
            String[] pair = valuePair.split("=");
            context.put(pair[0], pair[1]);
        }
        Object result = MVEL.eval((String)(expression = (String)TemplateRuntime.eval((String)expression, context)));
        if (result instanceof String[]) {
            return (String[])result;
        }
        if (result instanceof List) {
            List l = (List)result;
            String[] xs = new String[l.size()];
            for (int i = 0; i < xs.length; ++i) {
                Object el = l.get(i);
                xs[i] = el.toString();
            }
            return xs;
        }
        return null;
    }

    @Override
    @LoggedIn
    public Map<String, List<String>> listUserPermissions() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return new PermissionManager(this.rulesRepository).listUsers();
    }

    @Override
    @LoggedIn
    public PageResponse<PermissionsPageRow> listUserPermissions(PageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        this.serviceSecurity.checkSecurityIsAdmin();
        long start = System.currentTimeMillis();
        Map permissions = new PermissionManager(this.rulesRepository).listUsers();
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List<PermissionsPageRow> rowList = new PermissionPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(permissions).build();
        PageResponse<PermissionsPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(permissions.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(rowList.size() + request.getStartRowIndex() == permissions.size()).build();
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Retrieved Log Entries in " + methodDuration + " ms.");
        return response;
    }

    @Override
    @LoggedIn
    public Map<String, List<String>> retrieveUserPermissions(String userName) {
        this.serviceSecurity.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.rulesRepository);
        return pm.retrieveUserPermissions(userName);
    }

    @Override
    @LoggedIn
    public void updateUserPermissions(String userName, Map<String, List<String>> perms) {
        this.serviceSecurity.checkSecurityIsAdmin();
        PermissionManager pm = new PermissionManager(this.rulesRepository);
        log.info("Updating user permissions for userName [" + userName + "] to [" + perms + "]");
        pm.updateUserPermissions(userName, perms);
        this.rulesRepository.save();
    }

    @Override
    @Deprecated
    @LoggedIn
    public String[] listAvailablePermissionTypes() {
        this.serviceSecurity.checkSecurityIsAdmin();
        return RoleTypes.listAvailableTypes();
    }

    @Override
    @LoggedIn
    public List<String> listAvailablePermissionRoleTypes() {
        this.serviceSecurity.checkSecurityIsAdmin();
        RoleType[] roleTypes = RoleType.values();
        ArrayList<String> values = new ArrayList<String>();
        for (RoleType roleType : roleTypes) {
            values.add(roleType.getName());
        }
        return values;
    }

    @Override
    @LoggedIn
    public boolean isDoNotInstallSample() {
        try {
            return this.rulesRepository.isDoNotInstallSample();
        }
        catch (RepositoryException e) {
            return true;
        }
    }

    @Override
    @LoggedIn
    public void setDoNotInstallSample() {
        try {
            this.rulesRepository.setDoNotInstallSample();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    @LoggedIn
    public void deleteUser(String userName) {
        log.info("Removing user permissions for user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.rulesRepository);
        pm.removeUserPermissions(userName);
        this.rulesRepository.save();
    }

    @Override
    @LoggedIn
    public void createUser(String userName) {
        log.info("Creating user permissions, user name [" + userName + "]");
        PermissionManager pm = new PermissionManager(this.rulesRepository);
        pm.createUser(userName);
        this.rulesRepository.save();
    }

    @Override
    @LoggedIn
    public TableDataResult loadInbox(String inboxName) throws DetailedSerializationException {
        try {
            UserInbox ib = new UserInbox(this.rulesRepository);
            if (inboxName.equals("recentViewed")) {
                return UserInbox.toTable(ib.loadRecentOpened(), false);
            }
            if (inboxName.equals("recentEdited")) {
                return UserInbox.toTable(ib.loadRecentEdited(), false);
            }
            return UserInbox.toTable(ib.loadIncoming(), true);
        }
        catch (Exception e) {
            log.error("Unable to load Inbox: " + e.getMessage());
            throw new DetailedSerializationException("Unable to load Inbox", e.getMessage());
        }
    }

    @Override
    @LoggedIn
    public PageResponse<InboxPageRow> loadInbox(InboxPageRequest request) throws DetailedSerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        String inboxName = request.getInboxName();
        PageResponse<InboxPageRow> response = new PageResponse();
        long start = System.currentTimeMillis();
        try {
            List<UserInfo.InboxEntry> entries = new UserInbox(this.rulesRepository).loadEntries(inboxName);
            log.debug("Search time: " + (System.currentTimeMillis() - start));
            Iterator<UserInfo.InboxEntry> iterator = entries.iterator();
            List<InboxPageRow> rowList = new InboxPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(iterator).build();
            response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(entries.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(!iterator.hasNext()).build();
            long methodDuration = System.currentTimeMillis() - start;
            log.debug("Queried inbox ('" + inboxName + "') in " + methodDuration + " ms.");
        }
        catch (Exception e) {
            log.error("Unable to load Inbox: " + e.getMessage());
            throw new DetailedSerializationException("Unable to load Inbox", e.getMessage());
        }
        return response;
    }

    @Override
    public String processTemplate(String name, Map<String, Object> data) {
        try {
            Configuration configuration = new Configuration();
            configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            configuration.setTemplateUpdateDelay(0);
            Template template = new Template(name, (Reader)new InputStreamReader(ServiceImplementation.class.getResourceAsStream("/repoconfig/" + name + ".xml")), configuration);
            StringWriter stringwriter = new StringWriter();
            template.process(data, (Writer)stringwriter);
            return StringEscapeUtils.escapeXml((String)stringwriter.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Map<String, String> loadSpringContextElementData() throws DetailedSerializationException {
        try {
            return SpringContextElementsManager.getInstance().getElements();
        }
        catch (IOException ex) {
            log.error("Error loading Spring Context Elements", ex);
            throw new DetailedSerializationException("Error loading Spring Context Elements", "View server logs for more information");
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<QueryPageRow> queryFullText(QueryPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.rulesRepository.queryFullText(request.getSearchText(), request.isSearchArchived().booleanValue());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List<QueryPageRow> rowList = new QueryFullTextPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent((Iterator<AssetItem>)iterator).build();
        boolean bHasMoreRows = iterator.hasNext();
        PageResponse<QueryPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Full Text) for (" + request.getSearchText() + ") in " + methodDuration + " ms.");
        return response;
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<QueryPageRow> queryMetaData(QueryMetadataPageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        Map<String, String[]> queryMap = this.createQueryMap(request.getMetadata());
        RulesRepository.DateQuery[] dates = this.createDateQueryForRepository(request);
        long start = System.currentTimeMillis();
        AssetItemIterator iterator = this.rulesRepository.query(queryMap, request.isSearchArchived(), dates);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        List<QueryPageRow> rowList = new QueryMetadataPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent((Iterator<AssetItem>)iterator).build();
        boolean bHasMoreRows = iterator.hasNext();
        PageResponse<QueryPageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Queried repository (Metadata) in " + methodDuration + " ms.");
        return response;
    }

    private Map<String, String[]> createQueryMap(List<MetaDataQuery> metaDataQuerys) {
        HashMap<String, String[]> queryMap = new HashMap<String, String[]>();
        for (MetaDataQuery metaDataQuery : metaDataQuerys) {
            String vals = metaDataQuery.valueList == null ? "" : metaDataQuery.valueList.trim();
            if (vals.length() <= 0) continue;
            queryMap.put(metaDataQuery.attribute, vals.split(",\\s?"));
        }
        return queryMap;
    }

    private RulesRepository.DateQuery[] createDateQueryForRepository(QueryMetadataPageRequest request) {
        RulesRepository.DateQuery[] dates = new RulesRepository.DateQuery[]{new RulesRepository.DateQuery("jcr:created", DateUtil.isoDate(request.getCreatedAfter()), DateUtil.isoDate(request.getCreatedBefore())), new RulesRepository.DateQuery("drools:lastModified", DateUtil.isoDate(request.getLastModifiedAfter()), DateUtil.isoDate(request.getLastModifiedBefore()))};
        return dates;
    }

    @Override
    @WebRemote
    @LoggedIn
    public PageResponse<StatePageRow> loadRuleListForState(StatePageRequest request) throws SerializationException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        long start = System.currentTimeMillis();
        int numRowsToReturn = request.getPageSize() == null ? -1 : request.getPageSize();
        AssetItemPageResult result = this.rulesRepository.findAssetsByState(request.getStateName(), false, request.getStartRowIndex(), numRowsToReturn, (RepositoryFilter)new AssetItemFilter(this.identity));
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        boolean bHasMoreRows = result.hasNext;
        List<StatePageRow> rowList = new StatePageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(result.assets.iterator()).build();
        PageResponse<StatePageRow> response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withPageRowList(rowList).withLastPage(!bHasMoreRows).buildWithTotalRowCount(-1L);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Assest with State (" + request.getStateName() + ") in " + methodDuration + " ms.");
        return response;
    }

    private boolean checkCategoryPermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        List tempCateList = item.getCategories();
        for (CategoryItem categoryItem : tempCateList) {
            if (!filter.accept((Object)categoryItem.getName(), roleType)) continue;
            return true;
        }
        return false;
    }

    private void push(String messageType, String message) {
        this.backchannel.publish(new PushResponse(messageType, message));
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }

    @Override
    public List<PushResponse> subscribe() {
        return this.backchannel.subscribe();
    }

    @Override
    @WebRemote
    @LoggedIn
    public boolean doesAssetExistInModule(String assetName, String moduleName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(moduleName);
        try {
            ModuleItem moduleItem = this.rulesRepository.loadModule(moduleName);
            return moduleItem.containsAsset(assetName);
        }
        catch (RulesRepositoryException e) {
            log.error("An error occurred checking if asset [" + assetName + "] exists in module [" + moduleName + "]: ", e);
            throw new SerializationException(e.getMessage());
        }
    }
}

