/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;

public class AssemblyErrorLogger {
    private final List<ContentAssemblyError> errors = new ArrayList<ContentAssemblyError>();

    public void logError(ContentAssemblyError err) {
        this.errors.add(err);
    }

    public void addError(ModuleItem moduleItem, String errorReport) {
        this.errors.add(new ContentAssemblyError(errorReport, moduleItem.getFormat(), moduleItem.getName(), moduleItem.getUUID(), true, false));
    }

    public void addError(AssetItem assetItem, String errorReport) {
        this.errors.add(new ContentAssemblyError(errorReport, assetItem.getFormat(), assetItem.getName(), assetItem.getUUID(), false, true));
    }

    public void addError(String message, String format, String name, String uuid, boolean isModuleItem, boolean isAssetItem) {
        this.errors.add(new ContentAssemblyError(message, format, name, uuid, isModuleItem, isAssetItem));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ContentAssemblyError> getErrors() {
        return this.errors;
    }
}

