/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.server.builder.AssetValidationIterator;
import org.drools.guvnor.server.builder.ModuleAssemblerConfiguration;
import org.drools.guvnor.server.builder.PackageAssemblerBase;
import org.drools.guvnor.server.util.BuilderResultHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.utils.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderValidator
extends PackageAssemblerBase
implements Validator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT = "default";
    private AssetItem assetItemUnderValidation;

    @Override
    public void init(ModuleItem moduleItem, ModuleAssemblerConfiguration moduleAssemblerConfiguration) {
        this.moduleItem = moduleItem;
        this.createBuilder();
    }

    @Override
    public List<AssetItem> getAllNotToIncludeAssets() {
        return null;
    }

    public BuilderResult validateAsset(AssetItem item) {
        this.assetItemUnderValidation = item;
        this.moduleItem = item.getModule();
        this.createBuilder();
        if (this.setUpPackage()) {
            this.buildAsset(item);
        }
        return this.getResult();
    }

    public boolean validate(AssetItem item) {
        try {
            return !this.validateAsset(item).hasLines();
        }
        catch (RuntimeException re) {
            this.log.warn("Validation failed!", (Throwable)re);
            return false;
        }
    }

    public String getFormat() {
        return DEFAULT;
    }

    public BuilderResult getResult() {
        BuilderResult result = new BuilderResult();
        result.addLines(new BuilderResultHelper().generateBuilderResults(this.getErrors()));
        return result;
    }

    @Override
    protected Iterator<AssetItem> getAssetItemIterator(String ... formats) {
        AssetValidationIterator assetValidationIterator = new AssetValidationIterator(super.getAssetItemIterator(formats));
        assetValidationIterator.setAssetItemUnderValidation(this.assetItemUnderValidation);
        return assetValidationIterator;
    }
}

