/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.InboxIncomingPageRow;
import org.drools.guvnor.client.rpc.InboxPageRequest;
import org.drools.guvnor.client.rpc.InboxPageRow;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;
import org.drools.repository.UserInfo;
import org.jboss.seam.security.Identity;

public class InboxPageRowBuilder
implements PageRowBuilder<InboxPageRequest, Iterator<UserInfo.InboxEntry>> {
    private InboxPageRequest pageRequest;
    private Iterator<UserInfo.InboxEntry> iterator;
    private Identity identity;

    @Override
    public List<InboxPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        ArrayList<InboxPageRow> rowList = new ArrayList<InboxPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            UserInfo.InboxEntry ie = this.iterator.next();
            if (skipped >= startRowIndex) {
                rowList.add(this.createInboxPageRow(ie, this.pageRequest));
            }
            ++skipped;
        }
        return rowList;
    }

    private InboxPageRow createInboxPageRow(UserInfo.InboxEntry inboxEntry, InboxPageRequest request) {
        InboxPageRow row = null;
        if (request.getInboxName().equals("incoming")) {
            InboxIncomingPageRow tr = new InboxIncomingPageRow();
            tr.setUuid(inboxEntry.assetUUID);
            tr.setFormat("brl");
            tr.setNote(inboxEntry.note);
            tr.setName(inboxEntry.note);
            tr.setTimestamp(new Date(inboxEntry.timestamp));
            tr.setFrom(inboxEntry.from);
            row = tr;
        } else {
            InboxPageRow tr = new InboxPageRow();
            tr.setUuid(inboxEntry.assetUUID);
            tr.setFormat("brl");
            tr.setNote(inboxEntry.note);
            tr.setName(inboxEntry.note);
            tr.setTimestamp(new Date(inboxEntry.timestamp));
            row = tr;
        }
        return row;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public InboxPageRowBuilder withPageRequest(InboxPageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public InboxPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public InboxPageRowBuilder withContent(Iterator<UserInfo.InboxEntry> iterator) {
        this.iterator = iterator;
        return this;
    }
}

