/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.DefaultContentHandler;
import org.drools.repository.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentManager {
    private static final Logger log = LoggerFactory.getLogger(ContentManager.class);
    private static final String CONTENT_CONFIG_PROPERTIES = "/contenthandler.properties";
    private static ContentManager INSTANCE;
    private final Map<String, ContentHandler> contentHandlers = new HashMap<String, ContentHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentManager(String configPath) {
        log.debug("Loading content properties");
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(configPath);
            props.load(in);
            for (Object o : props.keySet()) {
                String contentHandler = (String)o;
                String val = props.getProperty(contentHandler);
                this.contentHandlers.put(contentHandler, this.loadContentHandlerImplementation(val));
            }
        }
        catch (IOException e) {
            try {
                log.error("UNABLE to load content handlers. Ahem, nothing will actually work. Ignore subsequent errors until this is resolved.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public Map<String, ContentHandler> getContentHandlers() {
        return this.contentHandlers;
    }

    private ContentHandler loadContentHandlerImplementation(String val) throws IOException {
        try {
            return (ContentHandler)Thread.currentThread().getContextClassLoader().loadClass(val).newInstance();
        }
        catch (InstantiationException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load content handler implementation.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ContentManager> clazz = ContentManager.class;
        synchronized (ContentManager.class) {
            INSTANCE = new ContentManager(CONTENT_CONFIG_PROPERTIES);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static ContentHandler getHandler(String format) {
        ContentHandler h = ContentManager.getInstance().getContentHandlers().get(format);
        if (h == null) {
            h = new DefaultContentHandler();
        }
        return h;
    }
}

