/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import org.apache.commons.io.IOUtils;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.VersionableItem;
import org.drools.repository.utils.AssetValidator;
import org.jboss.seam.security.Identity;

@ApplicationScoped
public class WebDAVImpl
implements IWebdavStore {
    private static final String SNAPSHOTS = "snapshots";
    private static final String PACKAGES = "packages";
    private static final String GLOBALAREA = "globalarea";
    private static final Map<String, byte[]> osxDoubleData = Collections.synchronizedMap(new WeakHashMap());
    @Inject
    @Preferred
    protected RulesRepository rulesRepository;
    @Inject
    protected Identity identity;
    @Inject
    protected AssetValidator assetValidator;

    public ITransaction begin(final Principal principal) {
        return new ITransaction(){

            public Principal getPrincipal() {
                return principal;
            }
        };
    }

    public void checkAuthentication(ITransaction arg0) {
    }

    public void commit(ITransaction iTransaction) {
        this.rulesRepository.save();
    }

    public void createFolder(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.isAdmin()) {
            if (path.length > 2) {
                throw new UnsupportedOperationException("Can't nest packages.");
            }
            if (this.rulesRepository.containsModule(path[1])) {
                ModuleItem pkg = this.loadPackageFromRepository(path[1]);
                pkg.archiveItem(false);
                pkg.checkin("restored by webdav");
            } else {
                this.rulesRepository.createModule(path[1], "from webdav");
            }
        } else {
            throw new UnsupportedOperationException("Not able to create folders here...");
        }
    }

    public void createResource(ITransaction iTransaction, String uri) {
        if (uri.endsWith(".DS_Store")) {
            return;
        }
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermission(path[1], RoleType.PACKAGE_ADMIN.getName())) {
            if (path.length > 3) {
                throw new UnsupportedOperationException("Can't do nested packages.");
            }
            String[] resource = AssetItem.getAssetNameFromFileName((String)path[2]);
            ModuleItem packageItem = this.loadPackageFromRepository(path[1]);
            if (path[2].startsWith("._")) {
                osxDoubleData.put(uri, null);
                return;
            }
            if (packageItem.containsAsset(resource[0])) {
                AssetItem lazarus = packageItem.loadAsset(resource[0]);
                lazarus.archiveItem(false);
                lazarus.checkin("restored by webdav");
            } else {
                AssetItem asset = packageItem.addAsset(resource[0], "");
                asset.updateFormat(resource[1]);
                asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
                asset.checkin("from webdav");
            }
        } else if (this.isGlobalAreas(path)) {
            String[] resource = AssetItem.getAssetNameFromFileName((String)path[1]);
            ModuleItem packageItem = this.loadGlobalAreaFromRepository();
            if (path[1].startsWith("._")) {
                osxDoubleData.put(uri, null);
                return;
            }
            if (packageItem.containsAsset(resource[0])) {
                AssetItem lazarus = packageItem.loadAsset(resource[0]);
                lazarus.archiveItem(false);
                lazarus.checkin("restored by webdav");
            } else {
                AssetItem asset = packageItem.addAsset(resource[0], "");
                asset.updateFormat(resource[1]);
                asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
                asset.checkin("from webdav");
            }
        } else {
            throw new UnsupportedOperationException("Can't add assets here.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getChildrenNames(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        ArrayList<String> result = new ArrayList<String>();
        if (path.length == 0) {
            return new String[]{PACKAGES, SNAPSHOTS, GLOBALAREA};
        }
        if (this.isPackages(path)) {
            if (path.length > 2) {
                return null;
            }
            if (path.length == 1) {
                this.listPackages(this.rulesRepository, result);
                return result.toArray(new String[result.size()]);
            } else {
                if (!this.checkPackagePermissionIfReadOnly(path)) return result.toArray(new String[result.size()]);
                this.handleReadOnlyPackages(this.rulesRepository, path, result);
            }
            return result.toArray(new String[result.size()]);
        } else if (this.isSnaphosts(path)) {
            if (path.length > 3) {
                return null;
            }
            if (path.length == 1) {
                this.listPackages(this.rulesRepository, result);
                return result.toArray(new String[result.size()]);
            } else {
                if (this.isPermission(path, 2)) {
                    return this.rulesRepository.listModuleSnapshots(path[1]);
                }
                if (!this.isPermission(path, 3)) throw new IllegalArgumentException();
                this.handleReadOnlySnapshotPackages(this.rulesRepository, path, result);
            }
            return result.toArray(new String[result.size()]);
        } else {
            if (!this.isGlobalAreas(path)) throw new UnsupportedOperationException("Not a valid path : " + path[0]);
            if (path.length > 2) {
                return null;
            }
            if (path.length != 1) return result.toArray(new String[result.size()]);
            this.handleReadOnlyGlobalAreaPackages(this.rulesRepository, path, result);
        }
        return result.toArray(new String[result.size()]);
    }

    private void handleReadOnlySnapshotPackages(RulesRepository repository, String[] path, List<String> result) {
        Iterator it = this.loadPackageSnapshotFromRepository(path).getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            this.addNameAndFormat(result, asset);
        }
    }

    private void handleReadOnlyGlobalAreaPackages(RulesRepository repository, String[] path, List<String> result) {
        Iterator it = this.loadGlobalAreaFromRepository().getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            this.addNameAndFormat(result, asset);
        }
    }

    private void handleReadOnlyPackages(RulesRepository repository, String[] path, List<String> result) {
        ModuleItem pkg = this.loadPackageFromRepository(path[1]);
        Iterator it = pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.isArchived()) continue;
            this.addNameAndFormat(result, asset);
        }
    }

    private void addNameAndFormat(List<String> result, AssetItem asset) {
        result.add(asset.getName() + "." + asset.getFormat());
    }

    private void listPackages(RulesRepository repository, List<String> result) {
        ModuleIterator it = repository.listModules();
        while (it.hasNext()) {
            ModuleItem pkg = (ModuleItem)it.next();
            String packageName = pkg.getName();
            if (pkg.isArchived() || !this.checkPackagePermission(packageName, RoleType.PACKAGE_READONLY.getName())) continue;
            result.add(packageName);
        }
    }

    public Date getCreationDate(String uri) {
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getCreationDateForPackage(this.rulesRepository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getCreationTimeForSnapshotPackage(this.rulesRepository, path);
        }
        if (this.isGlobalAreas(path)) {
            return this.getCreationTimeForGlobalAreaPackage(this.rulesRepository, path);
        }
        throw new UnsupportedOperationException();
    }

    private Date getCreationTimeForSnapshotPackage(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return new Date();
        }
        if (path.length == 3) {
            return this.loadPackageSnapshotFromRepository(path).getCreatedDate().getTime();
        }
        if (path.length == 4) {
            return this.loadAssetItemFromPackageItem(this.loadPackageSnapshotFromRepository(path), path[3]).getCreatedDate().getTime();
        }
        throw new UnsupportedOperationException();
    }

    private Date getCreationDateForPackage(RulesRepository repository, String[] path) {
        ModuleItem packageItem = this.loadPackageFromRepository(path[1]);
        if (path.length == 2) {
            return packageItem.getCreatedDate().getTime();
        }
        return this.loadAssetItemFromPackageItem(packageItem, path[2]).getCreatedDate().getTime();
    }

    private Date getCreationTimeForGlobalAreaPackage(RulesRepository repository, String[] path) {
        ModuleItem packageItem = this.loadGlobalAreaFromRepository();
        if (path.length == 2) {
            return packageItem.getCreatedDate().getTime();
        }
        return this.loadAssetItemFromPackageItem(packageItem, path[2]).getCreatedDate().getTime();
    }

    public Date getLastModified(String uri) {
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return new Date();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getLastModifiedForPackage(this.rulesRepository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getLastModifiedForSnaphotPackage(this.rulesRepository, path);
        }
        if (this.isGlobalAreas(path)) {
            return this.getLastModifiedForGlobalAreaPackage(this.rulesRepository, path);
        }
        throw new UnsupportedOperationException();
    }

    private Date getLastModifiedForSnaphotPackage(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return new Date();
        }
        if (path.length == 3) {
            return this.loadPackageSnapshotFromRepository(path).getLastModified().getTime();
        }
        if (path.length == 4) {
            ModuleItem pkg = this.loadPackageSnapshotFromRepository(path);
            return this.getLastModifiedFromPackageAssetItem(pkg, path[3]);
        }
        throw new UnsupportedOperationException();
    }

    private Date getLastModifiedForPackage(RulesRepository repository, String[] path) {
        ModuleItem pkg = this.loadPackageFromRepository(path[1]);
        if (path.length == 2) {
            return pkg.getLastModified().getTime();
        }
        return this.getLastModifiedFromPackageAssetItem(pkg, path[2]);
    }

    private Date getLastModifiedForGlobalAreaPackage(RulesRepository repository, String[] path) {
        ModuleItem pkg = this.loadGlobalAreaFromRepository();
        if (path.length == 2) {
            return pkg.getLastModified().getTime();
        }
        return this.getLastModifiedFromPackageAssetItem(pkg, path[2]);
    }

    private Date getLastModifiedFromPackageAssetItem(ModuleItem packageItem, String path) {
        return this.loadAssetItemFromPackageItem(packageItem, path).getLastModified().getTime();
    }

    public InputStream getResourceContent(ITransaction iTransaction, String uri) {
        return this.getContent(uri);
    }

    public StoredObject getStoredObject(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        if (path.length < 2) {
            return this.createStoredObject(uri);
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getStoredObjectForReadOnlyPackages(uri, this.rulesRepository, path);
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getStoredObjectForReadOnlySnapshots(uri, this.rulesRepository, path);
        }
        if (this.isGlobalAreas(path)) {
            return this.getStoredObjectForReadOnlyGlobalArea(uri, this.rulesRepository, path);
        }
        throw new UnsupportedOperationException();
    }

    private StoredObject createStoredObject(String uri) {
        StoredObject so = new StoredObject();
        so.setCreationDate(new Date());
        so.setFolder(this.isFolder(uri));
        so.setLastModified(new Date());
        so.setResourceLength(0L);
        return so;
    }

    private StoredObject getStoredObjectForReadOnlySnapshots(String uri, RulesRepository repository, String[] path) {
        if (path.length == 2) {
            StoredObject so = this.createStoredObject(uri, (VersionableItem)this.loadPackageFromRepository(path[1]), 0L);
            so.setFolder(this.isFolder(uri));
            return so;
        }
        if (path.length == 3) {
            return this.createStoredObject(uri, (VersionableItem)this.loadPackageSnapshotFromRepository(path), 0L);
        }
        if (path.length == 4) {
            AssetItem asset;
            ModuleItem pkg = this.loadPackageSnapshotFromRepository(path);
            try {
                asset = this.loadAssetItemFromPackageItem(pkg, path[3]);
            }
            catch (Exception e) {
                return null;
            }
            return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
        }
        throw new UnsupportedOperationException();
    }

    private StoredObject getStoredObjectForReadOnlyPackages(String uri, RulesRepository repository, String[] path) {
        AssetItem asset;
        ModuleItem packageItem = this.loadPackageFromRepository(path[1]);
        if (path.length == 2) {
            return this.createStoredObject(uri, (VersionableItem)packageItem, 0L);
        }
        try {
            asset = this.loadAssetItemFromPackageItem(packageItem, path[2]);
        }
        catch (Exception e) {
            return null;
        }
        return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
    }

    private StoredObject getStoredObjectForReadOnlyGlobalArea(String uri, RulesRepository repository, String[] path) {
        if (path.length == 1) {
            StoredObject so = this.createStoredObject(uri, (VersionableItem)this.loadGlobalAreaFromRepository(), 0L);
            so.setFolder(this.isFolder(uri));
            return so;
        }
        if (path.length == 2) {
            AssetItem asset;
            try {
                asset = this.loadAssetItemFromGlobalArea(path);
            }
            catch (Exception e) {
                return null;
            }
            return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
        }
        if (path.length == 3) {
            AssetItem asset;
            try {
                asset = this.loadAssetItemFromGlobalArea(path);
            }
            catch (Exception e) {
                return null;
            }
            return this.createStoredObject(uri, (VersionableItem)asset, asset.getContentLength());
        }
        throw new UnsupportedOperationException();
    }

    private StoredObject createStoredObject(String uri, VersionableItem versionableItem, long resourceLength) {
        StoredObject so = new StoredObject();
        so.setCreationDate(versionableItem.getCreatedDate().getTime());
        so.setFolder(this.isFolder(uri));
        so.setLastModified(versionableItem.getLastModified().getTime());
        so.setResourceLength(resourceLength);
        return so;
    }

    private InputStream getContent(String uri) {
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getAssetData(this.loadAssetItemFromPackage(path));
        }
        if (this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
            return this.getAssetData(this.loadAssetItemFromPackageSnaphot(path));
        }
        if (this.isGlobalAreas(path)) {
            return this.getAssetData(this.loadAssetItemFromGlobalArea(path));
        }
        throw new UnsupportedOperationException();
    }

    private InputStream getAssetData(AssetItem assetItem) {
        if (assetItem.isBinary()) {
            return assetItem.getBinaryContentAttachment();
        }
        return new ByteArrayInputStream(assetItem.getContent().getBytes());
    }

    public long getResourceLength(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        try {
            if (path.length == 3 && this.isPackages(path) && this.checkPackagePermissionIfReadOnly(path)) {
                return this.loadAssetItemFromPackage(path).getContentLength();
            }
            if (path.length == 3 && this.isGlobalAreas(path)) {
                return this.loadAssetItemFromPackage(path).getContentLength();
            }
            if (path.length == 4 && this.isSnaphosts(path) && this.checkPackagePermissionIfReadOnly(path)) {
                return this.loadAssetItemFromPackageSnaphot(path).getContentLength();
            }
            return 0L;
        }
        catch (Exception e) {
            System.err.println("Not able to get content length");
            return 0L;
        }
    }

    boolean isFolder(String uri) {
        String[] path = this.getPath(uri);
        if (path.length == 0) {
            return true;
        }
        if (path.length == 1 && (this.isPackages(path) || this.isSnaphosts(path) || this.isGlobalAreas(path))) {
            return true;
        }
        if (path.length == 2) {
            return this.rulesRepository.containsModule(path[1]);
        }
        if (path.length == 3 && this.isSnaphosts(path)) {
            return this.rulesRepository.containsModule(path[1]);
        }
        return false;
    }

    boolean isResource(String uri) {
        String[] path = this.getPath(uri);
        if (path.length < 3) {
            return false;
        }
        if (!(this.isPackages(path) || this.isSnaphosts(path) || this.isGlobalAreas(path))) {
            return false;
        }
        if (this.rulesRepository.containsModule(path[1])) {
            if (this.isPackages(path)) {
                ModuleItem pkg = this.loadPackageFromRepository(path[1]);
                if (path[2].startsWith("._")) {
                    return osxDoubleData.containsKey(uri);
                }
                return pkg.containsAsset(AssetItem.getAssetNameFromFileName((String)path[2])[0]);
            }
            if (path.length == 4) {
                return this.isAssetItemInPackage(this.rulesRepository, path);
            }
            return false;
        }
        return false;
    }

    boolean objectExists(String uri) {
        if (uri.indexOf(" copy ") > 0) {
            throw new IllegalArgumentException("OSX is not capable of copy and pasting without breaking the file extension.");
        }
        return this.internalObjectExists(uri);
    }

    private boolean internalObjectExists(String uri) {
        if (uri.endsWith(".DS_Store")) {
            return false;
        }
        String[] path = this.getPath(uri);
        if (path.length == 0 || path.length == 1 && (this.isPackages(path) || this.isSnaphosts(path) || this.isGlobalAreas(path))) {
            return true;
        }
        if (path.length == 1 || !this.rulesRepository.containsModule(path[1])) {
            return false;
        }
        if (this.isPackages(path)) {
            return this.handlePackagesInternalObjectExists(uri, this.rulesRepository, path);
        }
        if (this.isSnaphosts(path)) {
            return this.handleSnapshotsInternalObjectExists(this.rulesRepository, path);
        }
        if (this.isGlobalAreas(path)) {
            return this.handlePackagesInternalObjectExists(uri, this.rulesRepository, path);
        }
        throw new IllegalStateException();
    }

    private boolean handleSnapshotsInternalObjectExists(RulesRepository repository, String[] path) {
        if (path.length == 2) {
            return repository.containsModule(path[1]);
        }
        if (path.length == 3) {
            return repository.containsSnapshot(path[1], path[2]);
        }
        if (path.length == 4) {
            return this.isAssetItemInPackage(repository, path);
        }
        return false;
    }

    private boolean handlePackagesInternalObjectExists(String uri, RulesRepository repository, String[] path) {
        if (path.length == 2) {
            ModuleItem pkg = this.loadPackageFromRepository(path[1]);
            return !pkg.isArchived();
        }
        ModuleItem pkg = this.loadPackageFromRepository(path[1]);
        if (path[2].startsWith("._")) {
            return osxDoubleData.containsKey(uri);
        }
        String assetName = AssetItem.getAssetNameFromFileName((String)path[2])[0];
        return pkg.containsAsset(assetName) && !pkg.loadAsset(assetName).isArchived();
    }

    public void removeObject(ITransaction iTransaction, String uri) {
        String[] path = this.getPath(uri);
        if (path.length == 0 || path.length == 1) {
            throw new IllegalArgumentException();
        }
        if (this.isPackages(path) && this.checkPackagePermissionIfDeveloper(path)) {
            ModuleItem packageItem = this.loadPackageFromRepository(path[1]);
            if (path.length == 3) {
                if (path[2].startsWith("._")) {
                    osxDoubleData.remove(uri);
                    return;
                }
                AssetItem item = this.loadAssetItemFromPackageItem(packageItem, path[2]);
                item.archiveItem(true);
                item.checkin("");
            } else {
                packageItem.archiveItem(true);
                packageItem.checkin("");
            }
        } else if (this.isGlobalAreas(path)) {
            if (path.length == 2) {
                if (path[1].startsWith("._")) {
                    osxDoubleData.remove(uri);
                    return;
                }
                AssetItem item = this.loadAssetItemFromGlobalArea(path);
                item.archiveItem(true);
                item.checkin("");
            }
        } else {
            throw new IllegalArgumentException("Not allowed to remove this file.");
        }
    }

    public void rollback(ITransaction iTransaction) {
        this.rulesRepository.getSession().logout();
    }

    public long setResourceContent(ITransaction iTransaction, String uri, InputStream content, String contentType, String characterEncoding) {
        if (uri.endsWith(".DS_Store")) {
            return 0L;
        }
        String[] path = this.getPath(uri);
        if (this.isPackages(path) && this.checkPackagePermissionIfDeveloper(path)) {
            if (path.length != 3) {
                throw new IllegalArgumentException("Not a valid resource path " + uri);
            }
            if (path[2].startsWith("._")) {
                try {
                    osxDoubleData.put(uri, IOUtils.toByteArray((InputStream)content));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return 0L;
            }
            AssetItem asset = this.loadAssetItemFromPackage(path);
            if (asset.getFormat().equals("drl")) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(content));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("package ")) continue;
                        sb.append(line).append("\n");
                    }
                    asset.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
                }
                catch (Exception e) {
                    asset.updateBinaryContentAttachment(content);
                }
            } else {
                asset.updateBinaryContentAttachment(content);
            }
            asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
            asset.checkin("content from webdav");
        } else if (this.isGlobalAreas(path)) {
            if (path[1].startsWith("._")) {
                try {
                    osxDoubleData.put(uri, IOUtils.toByteArray((InputStream)content));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return 0L;
            }
            AssetItem asset = this.loadAssetItemFromGlobalArea(path);
            if (asset.getFormat().equals("drl")) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(content));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("package ")) continue;
                        sb.append(line).append("\n");
                    }
                    asset.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
                }
                catch (Exception e) {
                    asset.updateBinaryContentAttachment(content);
                }
            } else {
                asset.updateBinaryContentAttachment(content);
            }
            asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
            asset.checkin("content from webdav");
        } else {
            throw new UnsupportedOperationException("Unable to save content to this location.");
        }
        return 0L;
    }

    String[] getPath(String uri) {
        return this.getPath(uri, false);
    }

    String[] getPath(String uri, boolean usingWebdavAsRegex) {
        if (uri.equals("/")) {
            return new String[0];
        }
        if (usingWebdavAsRegex) {
            if (uri.endsWith("webdav") || uri.endsWith("webdav/")) {
                return new String[0];
            }
            if (uri.contains("webdav/")) {
                return uri.split("webdav/", 2)[1].split("/");
            }
        }
        return uri.substring(1).split("/");
    }

    private boolean isAdmin() {
        return this.identity.hasPermission((Object)new AdminType(), RoleType.ADMIN.getName());
    }

    private boolean checkPackagePermission(String packageName, String type) {
        return this.identity.hasPermission((Object)new WebDavPackageNameType(packageName), type);
    }

    private AssetItem loadAssetItemFromPackage(String[] path) {
        return this.loadAssetItemFromPackageItem(this.loadPackageFromRepository(path[1]), path[2]);
    }

    private AssetItem loadAssetItemFromPackageSnaphot(String[] path) {
        return this.loadAssetItemFromPackageItem(this.loadPackageSnapshotFromRepository(path), path[3]);
    }

    private AssetItem loadAssetItemFromGlobalArea(String[] path) {
        return this.loadAssetItemFromPackageItem(this.loadGlobalAreaFromRepository(), path[1]);
    }

    private AssetItem loadAssetItemFromPackageItem(ModuleItem pkg, String path) {
        return pkg.loadAsset(AssetItem.getAssetNameFromFileName((String)path)[0]);
    }

    private boolean isAssetItemInPackage(RulesRepository repository, String[] path) {
        return this.loadPackageSnapshotFromRepository(path).containsAsset(AssetItem.getAssetNameFromFileName((String)path[3])[0]);
    }

    private ModuleItem loadPackageFromRepository(String path) {
        return this.rulesRepository.loadModule(path);
    }

    private ModuleItem loadPackageSnapshotFromRepository(String[] path) {
        return this.rulesRepository.loadModuleSnapshot(path[1], path[2]);
    }

    private ModuleItem loadGlobalAreaFromRepository() {
        return this.rulesRepository.loadGlobalArea();
    }

    private boolean isPermission(String[] path, int pathIndex) {
        return path.length == pathIndex && this.checkPackagePermissionIfReadOnly(path);
    }

    private boolean checkPackagePermissionIfReadOnly(String[] path) {
        return this.checkPackagePermission(path[1], RoleType.PACKAGE_READONLY.getName());
    }

    private boolean checkPackagePermissionIfDeveloper(String[] path) {
        return this.checkPackagePermission(path[1], RoleType.PACKAGE_DEVELOPER.getName());
    }

    private boolean isPackages(String[] path) {
        return path[0].equals(PACKAGES);
    }

    private boolean isSnaphosts(String[] path) {
        return path[0].equals(SNAPSHOTS);
    }

    private boolean isGlobalAreas(String[] path) {
        return path[0].equals(GLOBALAREA);
    }
}

