/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.guvnor.server.builder.ModuleAssemblerManager;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.jaxrs.AssetMultipartForm;
import org.drools.guvnor.server.jaxrs.Resource;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.AssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.AtomAssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.AtomPackageMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.GuvnorDecorators;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.guvnor.server.jaxrs.jaxb.SnapshotCreationData;
import org.drools.guvnor.server.jaxrs.jaxb.Snapshots;
import org.drools.guvnor.server.jaxrs.providers.atom.Entry;
import org.drools.guvnor.server.jaxrs.providers.atom.Feed;
import org.drools.guvnor.server.jaxrs.providers.atom.Link;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleHistoryIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.jboss.seam.security.annotations.LoggedIn;

@Path(value="/packages")
@RequestScoped
@Named
@LoggedIn
@GZIP
public class PackageResource
extends Resource {
    private HttpHeaders headers;

    @Context
    public void setHttpHeaders(HttpHeaders theHeaders) {
        this.headers = theHeaders;
    }

    @GET
    @Produces(value={"application/atom+xml"})
    public Feed getPackagesAsFeed() {
        Feed f = new Feed();
        f.setTitle("Packages");
        f.setBase(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]));
        ModuleIterator iter = this.rulesRepository.listModules();
        while (iter.hasNext()) {
            ModuleItem item = iter.next();
            Entry e = new Entry();
            e.setTitle(item.getName());
            Link l = new Link();
            l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{itemName}").build(new Object[]{item.getName()}));
            e.getLinks().add(l);
            f.getEntries().add(e);
        }
        return f;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<Package> getPackagesAsJAXB() {
        ArrayList<Package> ret = new ArrayList<Package>();
        ModuleIterator iter = this.rulesRepository.listModules();
        while (iter.hasNext()) {
            ret.add(Translator.toPackage(iter.next(), this.uriInfo));
        }
        return ret;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry createPackageFromDRLAndReturnAsEntry(InputStream is, @Context UriInfo uriInfo) {
        try {
            String packageName = this.fileManagerService.importClassicDRL(is, null);
            return Translator.toPackageEntryAbdera(this.rulesRepository.loadModule(packageName), uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json", "application/xml"})
    public Package createPackageFromDRLAndReturnAsJaxB(InputStream is) {
        try {
            String packageName = this.fileManagerService.importClassicDRL(is, null);
            return Translator.toPackage(this.rulesRepository.loadModule(packageName), this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/atom+xml"})
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry createPackageFromAtom(Entry entry) {
        try {
            String checkinComment = "Initial";
            entry.getAnyOtherElement();
            AtomPackageMetadata metaData = (AtomPackageMetadata)entry.getAnyOtherJAXBObject(AtomPackageMetadata.class, new Class[0]);
            if (metaData != null) {
                checkinComment = metaData.getCheckinComment();
            }
            ModuleItem packageItem = this.rulesRepository.createModule(entry.getTitle(), entry.getSummary(), "package", null, checkinComment);
            return Translator.toPackageEntryAbdera(packageItem, this.uriInfo);
        }
        catch (JAXBException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Package createPackageFromJAXB(Package p) {
        try {
            String checkinComment = "Initial";
            if (p.getMetadata() != null && p.getMetadata().getCheckinComment() != null) {
                checkinComment = p.getMetadata().getCheckinComment();
            }
            ModuleItem packageItem = this.rulesRepository.createModule(p.getTitle(), p.getDescription(), "package", null, checkinComment);
            return Translator.toPackage(packageItem, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry getPackageAsEntry(@PathParam(value="packageName") String packageName) {
        if (!this.rulesRepository.containsModule(packageName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Package [" + packageName + "] does not exist")).build());
        }
        try {
            ModuleItem packageItem = this.rulesRepository.loadModule(packageName);
            return Translator.toPackageEntryAbdera(packageItem, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/json", "application/xml"})
    public Package getPackageAsJAXB(@PathParam(value="packageName") String packageName) {
        if (!this.rulesRepository.containsModule(packageName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Package [" + packageName + "] does not exist")).build());
        }
        try {
            ModuleItem packageItem = this.rulesRepository.loadModule(packageName);
            return Translator.toPackage(packageItem, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/source")
    @Produces(value={"text/plain"})
    public Response getPackageSource(@PathParam(value="packageName") String packageName) {
        if (!this.rulesRepository.containsModule(packageName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Package [" + packageName + "] does not exist")).build());
        }
        try {
            ModuleItem moduleItem = this.rulesRepository.loadModule(packageName);
            ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(moduleItem.getFormat(), moduleItem, null);
            String drl = moduleAssembler.getCompiledSource();
            return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + packageName)).header("Last-Modified", (Object)this.createDateFormat().format(this.convertToGmt(moduleItem.getLastModified()).getTime())).build();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getPackageBinary(@PathParam(value="packageName") String packageName) throws SerializationException {
        if (!this.rulesRepository.containsModule(packageName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Package [" + packageName + "] does not exist")).build());
        }
        try {
            ModuleItem p = this.compileModuleIfNeeded(packageName);
            byte[] result = p.getCompiledBinaryBytes();
            ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(p.getFormat(), p, null);
            String fileName = packageName + "." + moduleAssembler.getBinaryExtension();
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("Last-Modified", (Object)this.createDateFormat().format(this.convertToGmt(p.getLastModified()).getTime())).build();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private ModuleItem compileModuleIfNeeded(String packageName) throws SerializationException {
        ModuleItem p = this.rulesRepository.loadModule(packageName);
        if (p.isBinaryUpToDate()) {
            return p;
        }
        BuilderResult builderResult = this.repositoryPackageService.buildPackage(p.getUUID(), true);
        if (builderResult != null && !builderResult.getLines().isEmpty()) {
            StringBuilder errs = new StringBuilder();
            errs.append("Unable to build package name [").append(packageName).append("]\n");
            for (BuilderResultLine resultLine : builderResult.getLines()) {
                errs.append(resultLine.toString()).append("\n");
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errs.toString()).build());
        }
        return this.rulesRepository.loadModule(packageName);
    }

    @GET
    @Path(value="{packageName}/versions")
    @Produces(value={"application/atom+xml"})
    public Feed getPackageVersionsAsFeed(@PathParam(value="packageName") String packageName) throws SerializationException {
        if (!this.rulesRepository.containsModule(packageName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Package [" + packageName + "] does not exist")).build());
        }
        ModuleItem p = this.rulesRepository.loadModule(packageName);
        Feed f = new Feed();
        f.setTitle("Version history of " + p.getName());
        f.setBase(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]));
        ModuleHistoryIterator it = p.getHistory();
        while (it.hasNext()) {
            try {
                ModuleItem historicalPackage = it.next();
                if (historicalPackage.getVersionNumber() == 0L) continue;
                Entry e = new Entry();
                e.setTitle(Long.toString(historicalPackage.getVersionNumber()));
                e.setUpdated(historicalPackage.getLastModified().getTime());
                Link l = new Link();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/versions/{versionNumber}").build(new Object[]{p.getName(), Long.toString(historicalPackage.getVersionNumber())}));
                e.getLinks().add(l);
                f.getEntries().add(e);
            }
            catch (RuntimeException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return f;
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}")
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry getHistoricalPackageAsEntry(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        return Translator.toPackageEntryAbdera(this.rulesRepository.loadModule(packageName, versionNumber), this.uriInfo);
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/source")
    @Produces(value={"text/plain"})
    public Response getHistoricalPackageSource(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) {
        ModuleItem item = this.rulesRepository.loadModule(packageName, versionNumber);
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, null);
        String drl = moduleAssembler.getCompiledSource();
        return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + packageName)).header("Last-Modified", (Object)this.createDateFormat().format(this.convertToGmt(item.getLastModified()).getTime())).build();
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getHistoricalPackageBinary(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        ModuleItem p = this.rulesRepository.loadModule(packageName, versionNumber);
        byte[] result = p.getCompiledBinaryBytes();
        if (result != null) {
            ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(p.getFormat(), p, null);
            String fileName = packageName + "." + moduleAssembler.getBinaryExtension();
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).header("Last-Modified", (Object)this.createDateFormat().format(this.convertToGmt(p.getLastModified()).getTime())).build();
        }
        return Response.status((int)500).entity((Object)"This package version has no compiled binary").type("text/plain").build();
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/atom+xml"})
    public void updatePackageFromAtom(@PathParam(value="packageName") String packageName, Entry entry) {
        try {
            ModuleItem existingModuleItem = this.rulesRepository.loadModule(packageName);
            if (!existingModuleItem.getTitle().equalsIgnoreCase(entry.getTitle())) {
                this.rulesRepository.renameModule(existingModuleItem.getUUID(), entry.getTitle());
            }
            if (entry.getSummary() != null) {
                existingModuleItem.updateDescription(entry.getSummary());
            }
            if (!entry.getAuthors().isEmpty()) {
                // empty if block
            }
            String checkinComment = "";
            AtomPackageMetadata packageMetadata = (AtomPackageMetadata)entry.getAnyOtherJAXBObject(AtomPackageMetadata.class, new Class[0]);
            if (packageMetadata != null) {
                existingModuleItem.archiveItem(packageMetadata.isArchived());
                checkinComment = packageMetadata.getCheckinComment();
            }
            existingModuleItem.updateBinaryUpToDate(false);
            existingModuleItem.checkin(checkinComment);
            this.rulesRepository.save();
        }
        catch (JAXBException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updatePackageFromJAXB(@PathParam(value="packageName") String packageName, Package module) {
        try {
            ModuleItem existingModuleItem = this.rulesRepository.loadModule(packageName);
            if (!existingModuleItem.getTitle().equalsIgnoreCase(module.getTitle())) {
                this.rulesRepository.renameModule(existingModuleItem.getUUID(), module.getTitle());
            }
            existingModuleItem.updateDescription(module.getDescription());
            existingModuleItem.updateBinaryUpToDate(false);
            existingModuleItem.checkin(module.getMetadata().getCheckinComment());
            this.rulesRepository.save();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{packageName}")
    public void deletePackage(@PathParam(value="packageName") String packageName) {
        try {
            ModuleItem p = this.rulesRepository.loadModule(packageName);
            this.repositoryPackageService.removeModule(p.getUUID());
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetsAsAtom(@PathParam(value="packageName") String packageName, @QueryParam(value="format") List<String> formats) {
        try {
            Feed feed = new Feed();
            ModuleItem p = this.rulesRepository.loadModule(packageName);
            feed.setTitle(p.getTitle() + "-asset-feed");
            Iterator iter = null;
            iter = formats.isEmpty() ? p.getAssets() : p.listAssetsByFormat(formats);
            while (iter.hasNext()) {
                feed.getEntries().add(Translator.toAssetEntryAbdera((AssetItem)iter.next(), this.uriInfo));
            }
            return feed;
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXB(@PathParam(value="packageName") String packageName, @QueryParam(value="format") List<String> formats) {
        try {
            ArrayList<Asset> ret = new ArrayList<Asset>();
            ModuleItem p = this.rulesRepository.loadModule(packageName);
            Iterator iter = null;
            iter = formats.isEmpty() ? p.getAssets() : p.listAssetsByFormat(formats);
            while (iter.hasNext()) {
                ret.add(Translator.toAsset((AssetItem)iter.next(), this.uriInfo));
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry getAssetAsAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        if (!this.assetExists(packageName, assetName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Asset [" + assetName + "] of package [" + packageName + "] does not exist")).build());
        }
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            return Translator.toAssetEntryAbdera(asset, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/json", "application/xml"})
    public Asset getAssetAsJaxB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        if (!this.assetExists(packageName, assetName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Asset [" + assetName + "] of package [" + packageName + "] does not exist")).build());
        }
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            return Translator.toAsset(asset, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        if (!this.assetExists(packageName, assetName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Asset [" + assetName + "] of package [" + packageName + "] does not exist")).build());
        }
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            String fileName = null;
            String binaryContentAttachmentFileName = asset.getBinaryContentAttachmentFileName();
            fileName = binaryContentAttachmentFileName != null && !"".equals(binaryContentAttachmentFileName) ? binaryContentAttachmentFileName : asset.getName() + "." + asset.getFormat();
            return Response.ok((Object)asset.getBinaryContentAttachment()).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/source")
    @Produces(value={"text/plain"})
    public String getAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        if (!this.assetExists(packageName, assetName)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Asset [" + assetName + "] of package [" + packageName + "] does not exist")).build());
        }
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            return asset.getContent();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/snapshots")
    @Produces(value={"application/atom+xml", "application/json", "application/xml"})
    public Snapshots getPackageSnapshot(@PathParam(value="packageName") String packageName) {
        try {
            Snapshots snapshots = new Snapshots();
            snapshots.setPackageName(packageName);
            String[] theList = this.rulesRepository.listModuleSnapshots(packageName);
            snapshots.setListNames(theList);
            return snapshots;
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{packageName}/assets")
    @Consumes(value={"application/atom+xml"})
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry createAssetFromAtom(@PathParam(value="packageName") String packageName, Entry entry) {
        try {
            Object format = null;
            String[] categories = null;
            AtomAssetMetadata assetMetadata = (AtomAssetMetadata)entry.getAnyOtherJAXBObject(AtomAssetMetadata.class, new Class[0]);
            categories = assetMetadata.getCategories();
            AssetItem ai = this.rulesRepository.loadModule(packageName).addAsset(entry.getTitle(), entry.getSummary(), null, assetMetadata.getFormat());
            if (categories != null) {
                ai.updateCategoryList(categories);
            }
            if (assetMetadata != null && assetMetadata.getState() != null) {
                ai.updateState(assetMetadata.getState());
            }
            ai.getModule().updateBinaryUpToDate(false);
            this.rulesRepository.save();
            return Translator.toAssetEntryAbdera(ai, this.uriInfo);
        }
        catch (JAXBException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="{packageName}/assets")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry createAssetFromBinary(@PathParam(value="packageName") String packageName, InputStream is) {
        try {
            String assetName = this.getHttpHeader(this.headers, "slug");
            if (assetName == null) {
                throw new WebApplicationException(Response.status((int)500).entity((Object)"Slug header is missing").build());
            }
            try {
                assetName = URLDecoder.decode(assetName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("This server does not support UTF-8 encoding.", e);
            }
            String fileName = null;
            String extension = null;
            if (assetName.lastIndexOf(".") != -1) {
                fileName = assetName.substring(0, assetName.lastIndexOf("."));
                extension = assetName.substring(assetName.lastIndexOf(".") + 1);
            } else {
                fileName = assetName;
            }
            AssetItem ai = this.rulesRepository.loadModule(packageName).addAsset(fileName, "");
            ai.checkout();
            ai.updateBinaryContentAttachmentFileName(fileName);
            if (extension != null) {
                ai.updateFormat(extension);
            }
            ai.updateBinaryContentAttachment(is);
            ai.getModule().updateBinaryUpToDate(false);
            ai.updateValid(Boolean.valueOf(this.assetValidator.validate(ai)));
            ai.checkin("update binary");
            ContentHandler handler = ContentManager.getHandler(ai.getFormat());
            if (handler instanceof ICanHasAttachment) {
                try {
                    ((ICanHasAttachment)((Object)handler)).onAttachmentAdded(ai);
                }
                catch (IOException ex) {
                    Logger.getLogger(PackageResource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.rulesRepository.save();
            return Translator.toAssetEntryAbdera(ai, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/atom+xml"})
    public void updateAssetFromAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Entry assetEntry) {
        try {
            AtomAssetMetadata assetMetadata = (AtomAssetMetadata)assetEntry.getAnyOtherJAXBObject(AtomAssetMetadata.class, new Class[0]);
            AssetItem ai = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            ai.checkout();
            ai.updateTitle(assetEntry.getTitle());
            ai.updateDescription(assetEntry.getSummary());
            if (assetMetadata.getFormat() != null) {
                ai.updateFormat(assetMetadata.getFormat());
            }
            if (assetEntry.getContent().getText() != null && !"".equals(assetEntry.getContent().getText())) {
                ai.updateContent(assetEntry.getContent().getText());
            }
            if (assetMetadata.getCategories() != null && assetMetadata.getCategories().length > 0) {
                ai.updateCategoryList(assetMetadata.getCategories());
            }
            if (assetMetadata.getState() != null) {
                ai.updateState(assetMetadata.getState());
            }
            ai.updateDisabled(assetMetadata.getDisabled());
            ai.updateValid(Boolean.valueOf(this.assetValidator.validate(ai)));
            if (AssetFormats.affectsBinaryUpToDate(ai.getFormat())) {
                ModuleItem pkg = ai.getModule();
                pkg.updateBinaryUpToDate(false);
                RuleBaseCache.getInstance().remove(pkg.getUUID());
            }
            ai.checkin("Check-in (summary): " + assetEntry.getSummary());
            this.rulesRepository.save();
        }
        catch (JAXBException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updateAssetFromJAXB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Asset asset) {
        try {
            AssetItem ai = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            ai.checkout();
            ai.updateTitle(asset.getTitle());
            ai.updateDescription(asset.getDescription());
            ai.updateValid(Boolean.valueOf(this.assetValidator.validate(ai)));
            if (asset.getMetadata() != null) {
                AssetMetadata assetMetadata = asset.getMetadata();
                if (assetMetadata.getState() != null) {
                    ai.updateState(assetMetadata.getState());
                }
                if (assetMetadata.getCategories() != null) {
                    ai.updateCategoryList(assetMetadata.getCategories());
                }
                ai.updateDisabled(assetMetadata.isDisabled());
            }
            if (AssetFormats.affectsBinaryUpToDate(ai.getFormat())) {
                ModuleItem pkg = ai.getModule();
                pkg.updateBinaryUpToDate(false);
                RuleBaseCache.getInstance().remove(pkg.getUUID());
            }
            ai.checkin(asset.getMetadata().getCheckInComment());
            this.rulesRepository.save();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}/source")
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @Produces(value={"*/*"})
    public void updateAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, String content) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            asset.checkout();
            asset.updateContent(content);
            asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
            if (AssetFormats.affectsBinaryUpToDate(asset.getFormat())) {
                ModuleItem pkg = asset.getModule();
                pkg.updateBinaryUpToDate(false);
                RuleBaseCache.getInstance().remove(pkg.getUUID());
            }
            asset.checkin("Updated asset source from REST interface");
            this.rulesRepository.save();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}/binary")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"*/*"})
    public void updateAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, InputStream is) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            asset.checkout();
            asset.updateBinaryContentAttachment(is);
            asset.updateValid(Boolean.valueOf(this.assetValidator.validate(asset)));
            if (AssetFormats.affectsBinaryUpToDate(asset.getFormat())) {
                ModuleItem pkg = asset.getModule();
                pkg.updateBinaryUpToDate(false);
                RuleBaseCache.getInstance().remove(pkg.getUUID());
            }
            asset.getModule().updateBinaryUpToDate(false);
            asset.checkin("Update binary");
            this.rulesRepository.save();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="{packageName}/assets/{assetName}/")
    public void deleteAsset(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem ai = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            ModuleItem module = ai.getModule();
            this.repositoryAssetService.removeAsset(ai.getUUID());
            module.updateBinaryUpToDate(false);
            this.rulesRepository.save();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetVersionsAsFeed(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
            Feed f = new Feed();
            f.setTitle("Version history of " + asset.getName());
            URI base = asset.isHistoricalVersion() ? this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{versionNumber}").build(new Object[]{asset.getModuleName(), asset.getName(), Long.toString(asset.getVersionNumber())}) : this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions").build(new Object[]{asset.getModuleName(), asset.getName()});
            f.setBase(base);
            AssetHistoryIterator it = asset.getHistory();
            while (it.hasNext()) {
                AssetItem historicalAsset = it.next();
                if (historicalAsset.getVersionNumber() == 0L) continue;
                Entry e = new Entry();
                e.setTitle(Long.toString(historicalAsset.getVersionNumber()));
                e.setUpdated(historicalAsset.getLastModified().getTime());
                Link l = new Link();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{versionNumber}").build(new Object[]{asset.getModuleName(), asset.getName(), Long.toString(historicalAsset.getVersionNumber())}));
                e.getLinks().add(l);
                f.getEntries().add(e);
            }
            return f;
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}")
    @Produces(value={"application/atom+xml"})
    @GuvnorDecorators
    public Entry getHistoricalAssetAsEntry(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName, versionNumber);
            return Translator.toAssetEntryAbdera(asset, this.uriInfo);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}/source")
    @Produces(value={"text/plain"})
    public String getHistoricalAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName, versionNumber);
            return asset.getContent();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/versions/{versionNumber}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getHistoricalAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, @PathParam(value="versionNumber") long versionNumber) {
        try {
            AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName, versionNumber);
            String fileName = null;
            String binaryContentAttachmentFileName = asset.getBinaryContentAttachmentFileName();
            fileName = binaryContentAttachmentFileName != null && !"".equals(binaryContentAttachmentFileName) ? binaryContentAttachmentFileName : asset.getName() + "." + asset.getFormat();
            return Response.ok((Object)asset.getBinaryContentAttachment()).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        catch (RuntimeException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getHttpHeader(HttpHeaders headers, String headerName) {
        MultivaluedMap heads = headers.getRequestHeaders();
        for (String key : heads.keySet()) {
            List h;
            if (!headerName.equalsIgnoreCase(key) || (h = (List)heads.get((Object)key)) == null || h.size() <= 0) continue;
            return (String)h.get(0);
        }
        return null;
    }

    @POST
    @Path(value="{packageName}/snapshot/{snapshotName}")
    public void createPackageSnapshot(@PathParam(value="packageName") String packageName, @PathParam(value="snapshotName") String snapshotName) throws SerializationException {
        this.compileModuleIfNeeded(packageName);
        this.repositoryModuleOperations.createModuleSnapshot(packageName, snapshotName, true, "REST API Snapshot", null, null, null, false, null, null, false, null);
    }

    private boolean assetExists(String packageName, String assetName) {
        boolean packageExists = this.rulesRepository.containsModule(packageName);
        if (!packageExists) {
            return false;
        }
        ModuleItem packageItem = this.rulesRepository.loadModule(packageName);
        return packageItem.containsAsset(assetName);
    }

    @POST
    @Path(value="{packageName}/snapshot/{snapshotName}")
    @Consumes(value={"application/xml"})
    public void createPackageSnapshotWithOptions(@PathParam(value="packageName") String packageName, @PathParam(value="snapshotName") String snapshotName, SnapshotCreationData moduleData) throws SerializationException {
        this.compileModuleIfNeeded(packageName);
        this.repositoryModuleOperations.createModuleSnapshot(packageName, snapshotName, true, "REST API Snapshot", moduleData.getBuildMode(), moduleData.getStatusOperator(), moduleData.getStatusDescriptionValue(), moduleData.getEnableStatusSelector(), moduleData.getCategoryOperator(), moduleData.getCategoryValue(), moduleData.getEnableCategorySelector(), moduleData.getCustomSelectorConfigName());
    }

    @POST
    @Path(value="{packageName}/assets")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml"})
    public Asset createAssetFromBinaryAndJAXB(@PathParam(value="packageName") String packageName, @MultipartForm AssetMultipartForm assetMultipartForm) {
        if (assetMultipartForm == null || assetMultipartForm.getAsset() == null || assetMultipartForm.getAsset().getMetadata() == null) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)"Request must contain asset and metadata").build());
        }
        String assetName = assetMultipartForm.getAsset().getTitle();
        if (assetName == null) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)"Asset name must be specified (Asset.metadata.title)").build());
        }
        AssetItem ai = this.rulesRepository.loadModule(packageName).addAsset(assetName, assetMultipartForm.getAsset().getDescription());
        ai.checkout();
        ai.updateBinaryContentAttachmentFileName(assetMultipartForm.getAsset().getBinaryContentAttachmentFileName());
        ai.updateFormat(assetMultipartForm.getAsset().getMetadata().getFormat());
        ai.updateBinaryContentAttachment(assetMultipartForm.getBinary());
        ai.getModule().updateBinaryUpToDate(false);
        ai.updateValid(Boolean.valueOf(this.assetValidator.validate(ai)));
        ai.checkin(assetMultipartForm.getAsset().getMetadata().getCheckInComment());
        this.rulesRepository.save();
        return assetMultipartForm.getAsset();
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml"})
    public Asset updateAssetFromBinaryAndJAXB(@PathParam(value="packageName") String packageName, @MultipartForm AssetMultipartForm assetMultipartForm, @PathParam(value="assetName") String assetName) {
        if (assetMultipartForm == null || assetMultipartForm.getAsset() == null || assetMultipartForm.getAsset().getMetadata() == null) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)"Request must contain asset and metadata").build());
        }
        if (!this.assetExists(packageName, assetName)) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)("Asset [" + assetName + "] does not exist in package [" + packageName + "]")).build());
        }
        AssetItem ai = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
        ai.checkout();
        ai.updateDescription(assetMultipartForm.getAsset().getDescription());
        ai.updateBinaryContentAttachmentFileName(assetMultipartForm.getAsset().getBinaryContentAttachmentFileName());
        ai.updateFormat(assetMultipartForm.getAsset().getMetadata().getFormat());
        ai.updateBinaryContentAttachment(assetMultipartForm.getBinary());
        ai.getModule().updateBinaryUpToDate(false);
        ai.updateValid(Boolean.valueOf(this.assetValidator.validate(ai)));
        ai.checkin(assetMultipartForm.getAsset().getMetadata().getCheckInComment());
        this.rulesRepository.save();
        return assetMultipartForm.getAsset();
    }

    private DateFormat createDateFormat() {
        return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    }

    private Calendar convertToGmt(Calendar cal) {
        Date date = cal.getTime();
        TimeZone tz = cal.getTimeZone();
        long msFromEpochGmt = date.getTime();
        int offsetFromUTC = tz.getOffset(msFromEpochGmt);
        Calendar gmtCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmtCal.setTime(date);
        gmtCal.add(14, offsetFromUTC);
        return gmtCal;
    }
}

