/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.maven;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.server.maven.parser.MavenDependencyTreeParser;

public final class ArtifactDependencySupport {
    private static Collection<MavenArtifact> dependencyTree = null;
    private static Collection<MavenArtifact> dependencyList = null;

    private ArtifactDependencySupport() {
    }

    public static synchronized Collection<MavenArtifact> getDependencyTree() {
        if (dependencyTree == null) {
            ArtifactDependencySupport.buildRuntimeDependencyTree();
        }
        return dependencyTree;
    }

    public static synchronized Collection<MavenArtifact> getDependencyList() {
        if (dependencyList == null) {
            ArtifactDependencySupport.buildRuntimeDependencyTree();
        }
        return dependencyList;
    }

    private static synchronized void buildRuntimeDependencyTree() {
        MavenDependencyTreeParser parser = new MavenDependencyTreeParser();
        MavenDependencyTreeParser.Pair<Collection<MavenArtifact>, Collection<MavenArtifact>> pair = parser.buildDependencyTreeAndList(ArtifactDependencySupport.getStreamToParse());
        dependencyTree = new ArrayList<MavenArtifact>(pair.getV1());
        dependencyList = new ArrayList<MavenArtifact>(pair.getV2());
    }

    private static InputStream getStreamToParse() {
        return ArtifactDependencySupport.class.getClassLoader().getResourceAsStream("org/drools/guvnor/server/maven/dependency.tree");
    }
}

