/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.server.security.CapabilityCalculator;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleType;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Credentials;
import org.jboss.seam.security.Identity;
import org.picketlink.idm.api.Credential;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SecurityServiceImpl
implements SecurityService {
    public static final String GUEST_LOGIN = "guest";
    private static final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private static final String[] serializationProperties = new String[]{"drools.serialization.private.keyStoreURL", "drools.serialization.private.keyStorePwd", "drools.serialization.private.keyAlias", "drools.serialization.private.keyPwd", "drools.serialization.public.keyStoreURL", "drools.serialization.public.keyStorePwd"};
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;
    @Inject
    private Identity identity;
    @Inject
    private Credentials credentials;

    @Override
    public boolean login(String userName, String password) {
        char[] bannedChars;
        if (userName == null || userName.trim().equals("")) {
            userName = "admin";
        }
        log.info("Logging in user [" + userName + "]");
        for (char bannedChar : bannedChars = new char[]{'\'', '*', '[', ']'}) {
            if (userName.indexOf(bannedChar) < 0) continue;
            log.error("Not a valid name character " + bannedChar);
            return false;
        }
        this.credentials.setUsername(userName);
        this.credentials.setCredential((Credential)new PasswordCredential(password));
        this.identity.login();
        if (!this.identity.isLoggedIn()) {
            log.error("Unable to login.");
        }
        return this.identity.isLoggedIn();
    }

    @Override
    public void logout() {
        this.identity.logout();
    }

    @Override
    public UserSecurityContext getCurrentUser() {
        this.tryAutoLoginAsGuest();
        String userName = this.identity.isLoggedIn() ? this.credentials.getUsername() : null;
        boolean isAdministrator = userName == null ? false : this.getUserCapabilities().contains((Object)Capability.SHOW_ADMIN);
        return new UserSecurityContext(userName, isAdministrator);
    }

    private void tryAutoLoginAsGuest() {
        if (!this.identity.isLoggedIn()) {
            this.credentials.setUsername(GUEST_LOGIN);
            this.identity.login();
        }
    }

    @Override
    public List<Capability> getUserCapabilities() {
        if (this.identity.hasRole(RoleType.ADMIN.getName(), null, null)) {
            return CapabilityCalculator.grantAllCapabilities();
        }
        if (!this.roleBasedPermissionResolver.isEnableRoleBasedAuthorization()) {
            return CapabilityCalculator.grantAllCapabilities();
        }
        List<RoleBasedPermission> permissions = this.roleBasedPermissionManager.getRoleBasedPermission();
        if (permissions.size() == 0) {
            this.identity.logout();
            throw new AuthorizationException("This user has no permissions setup.");
        }
        if (this.invalidSecuritySerializationSetup()) {
            this.identity.logout();
            throw new AuthorizationException(" Configuration error - Please refer to the Administration Guide section on installation. You must configure a key store before proceding.  ");
        }
        return new CapabilityCalculator().calcCapabilities(permissions);
    }

    private boolean invalidSecuritySerializationSetup() {
        String serializationSign = System.getProperty("drools.serialization.sign");
        if (serializationSign != null && serializationSign.equalsIgnoreCase("true")) {
            for (String nextProp : serializationProperties) {
                String nextPropVal = System.getProperty(nextProp);
                if (nextPropVal != null && !nextPropVal.trim().equals("")) continue;
                return true;
            }
        }
        return false;
    }
}

