/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.impl.AutoBeanCodexImpl;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittableSimpleMap<K, V>
implements Map<K, V>,
HasSplittable {
    private final Splittable data;
    private final AutoBeanCodexImpl.Coder keyCoder;
    private final AutoBeanCodexImpl.EncodeState state;
    private final AutoBeanCodexImpl.Coder valueCoder;
    private Splittable reified = StringQuoter.createSplittable();

    public SplittableSimpleMap(Splittable data, AutoBeanCodexImpl.Coder keyCoder, AutoBeanCodexImpl.Coder valueCoder, AutoBeanCodexImpl.EncodeState state) {
        this.data = data;
        this.keyCoder = keyCoder;
        this.state = state;
        this.valueCoder = valueCoder;
    }

    @Override
    public void clear() {
        for (String key : this.data.getPropertyKeys()) {
            Splittable.NULL.assign(this.data, key);
            this.reified.setReified(key, null);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        String encodedKey = this.encodedKey(key);
        return !this.data.isUndefined(encodedKey) || this.reified.isReified(encodedKey);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){
            final List<String> keys;
            {
                this.keys = SplittableSimpleMap.this.data.getPropertyKeys();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<String> keyIterator;
                    String encodedKey;
                    {
                        this.keyIterator = keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.encodedKey = this.keyIterator.next();
                        return new Map.Entry<K, V>(){
                            final K key;
                            final V value;
                            {
                                this.key = SplittableSimpleMap.this.keyCoder.decode(SplittableSimpleMap.this.state, StringQuoter.split(StringQuoter.quote(encodedKey)));
                                this.value = SplittableSimpleMap.this.valueCoder.decode(SplittableSimpleMap.this.state, SplittableSimpleMap.this.data.get(encodedKey));
                            }

                            @Override
                            public K getKey() {
                                return this.key;
                            }

                            @Override
                            public V getValue() {
                                return this.value;
                            }

                            @Override
                            public V setValue(V newValue) {
                                return SplittableSimpleMap.this.put(this.key, newValue);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        Splittable.NULL.assign(SplittableSimpleMap.this.data, this.encodedKey);
                        SplittableSimpleMap.this.reified.setReified(this.encodedKey, null);
                    }
                };
            }

            @Override
            public int size() {
                return this.keys.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        String encodedKey = this.encodedKey(key);
        return this.getRaw(encodedKey);
    }

    @Override
    public Splittable getSplittable() {
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.data.getPropertyKeys().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){
            final List<String> keys;
            {
                this.keys = SplittableSimpleMap.this.data.getPropertyKeys();
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    final Iterator<String> it;
                    String lastEncodedKey;
                    {
                        this.it = keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public K next() {
                        this.lastEncodedKey = this.it.next();
                        Object toReturn = SplittableSimpleMap.this.keyCoder.decode(SplittableSimpleMap.this.state, StringQuoter.split(StringQuoter.quote(this.lastEncodedKey)));
                        return toReturn;
                    }

                    @Override
                    public void remove() {
                        Splittable.NULL.assign(SplittableSimpleMap.this.data, this.lastEncodedKey);
                        SplittableSimpleMap.this.reified.setReified(this.lastEncodedKey, null);
                    }
                };
            }

            @Override
            public int size() {
                return this.keys.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        V toReturn = this.get(key);
        String encodedKey = this.encodedKey(key);
        this.reified.setReified(encodedKey, value);
        Splittable encodedValue = this.valueCoder.extractSplittable(this.state, value);
        if (encodedValue == null) {
            this.reified.setReified("__unsplittableValues", true);
        } else {
            encodedValue.assign(this.data, encodedKey);
        }
        return toReturn;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V toReturn = this.get(key);
        String encodedKey = this.encodedKey(key);
        this.reified.setReified(encodedKey, null);
        Splittable.NULL.assign(this.data, encodedKey);
        return toReturn;
    }

    @Override
    public int size() {
        return this.data.getPropertyKeys().size();
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            final List<String> keys;
            {
                this.keys = SplittableSimpleMap.this.data.getPropertyKeys();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final Iterator<String> it;
                    String lastEncodedKey;
                    {
                        this.it = keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public V next() {
                        this.lastEncodedKey = this.it.next();
                        return SplittableSimpleMap.this.getRaw(this.lastEncodedKey);
                    }

                    @Override
                    public void remove() {
                        Splittable.NULL.assign(SplittableSimpleMap.this.data, this.lastEncodedKey);
                        SplittableSimpleMap.this.reified.setReified(this.lastEncodedKey, null);
                    }
                };
            }

            @Override
            public int size() {
                return this.keys.size();
            }
        };
    }

    private String encodedKey(Object key) {
        return this.keyCoder.extractSplittable(this.state, key).asString();
    }

    private V getRaw(String encodedKey) {
        if (this.reified.isReified(encodedKey)) {
            Object toReturn = this.reified.getReified(encodedKey);
            return (V)toReturn;
        }
        if (this.data.isNull(encodedKey)) {
            return null;
        }
        Splittable value = this.data.get(encodedKey);
        Object toReturn = this.valueCoder.decode(this.state, value);
        this.reified.setReified(encodedKey, toReturn);
        return (V)toReturn;
    }
}

