/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.ViewId;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class View
implements Comparable<View>,
Streamable,
Iterable<Address> {
    protected ViewId vid;
    protected List<Address> members;

    public View() {
    }

    public View(ViewId vid, List<Address> members) {
        this.vid = vid;
        this.members = new ArrayList<Address>(members);
    }

    public View(Address creator, long id, List<Address> members) {
        this(new ViewId(creator, id), members);
    }

    public static View create(Address coord, long id, Address ... members) {
        return new View(new ViewId(coord, id), Arrays.asList(members));
    }

    public ViewId getVid() {
        return this.vid;
    }

    public ViewId getViewId() {
        return this.vid;
    }

    public Address getCreator() {
        return this.vid.getCreator();
    }

    public Address getCoord() {
        return !this.members.isEmpty() ? this.members.get(0) : null;
    }

    public List<Address> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public List<Address> getMembersRaw() {
        return this.members;
    }

    public boolean containsMember(Address mbr) {
        return mbr != null && this.members.contains(mbr);
    }

    public boolean containsMembers(Address ... mbrs) {
        if (mbrs == null || this.members == null) {
            return false;
        }
        for (Address mbr : mbrs) {
            if (this.containsMember(mbr)) continue;
            return false;
        }
        return true;
    }

    public boolean containsMembers(Collection<Address> mbrs) {
        if (mbrs == null || this.members == null) {
            return false;
        }
        for (Address mbr : mbrs) {
            if (this.containsMember(mbr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(View o) {
        return this.vid.compareTo(o.vid);
    }

    public boolean equals(Object obj) {
        return obj instanceof View && (this == obj || this.compareTo((View)obj) == 0);
    }

    public int hashCode() {
        return this.vid.hashCode();
    }

    public int size() {
        return this.members.size();
    }

    public View copy() {
        return new View(this.vid.copy(), this.members);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.vid).append(" ");
        if (this.members != null) {
            sb.append("[").append(Util.printListWithDelimiter(this.members, ", ", Util.MAX_LIST_PRINT_SIZE)).append("]");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        this.vid.writeTo(out);
        Util.writeAddresses(this.members, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.vid = new ViewId();
        this.vid.readFrom(in);
        this.members = (List)Util.readAddresses(in, ArrayList.class);
    }

    public int serializedSize() {
        return (int)((long)this.vid.serializedSize() + Util.size(this.members));
    }

    @Override
    public Iterator<Address> iterator() {
        return this.members.iterator();
    }
}

