/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.AbstractRuleModellerSelectorPopup;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

public class RuleModellerConditionSelectorPopup
extends AbstractRuleModellerSelectorPopup {
    public RuleModellerConditionSelectorPopup(RuleModel model, RuleModeller ruleModeller, String packageName, Integer position) {
        super(model, ruleModeller, packageName, position);
    }

    @Override
    protected String getPopupTitle() {
        return Constants.INSTANCE.AddAConditionToTheRule();
    }

    public Widget getContent() {
        if (this.position == null) {
            this.positionCbo.addItem(Constants.INSTANCE.Bottom(), String.valueOf(this.model.lhs.length));
            this.positionCbo.addItem(Constants.INSTANCE.Top(), "0");
            for (int i = 1; i < this.model.lhs.length; ++i) {
                this.positionCbo.addItem(Constants.INSTANCE.Line0(i), String.valueOf(i));
            }
        } else {
            this.positionCbo.addItem(String.valueOf(this.position));
            this.positionCbo.setSelectedIndex(0);
        }
        if (this.completions.getDSLConditions().length == 0 && this.completions.getFactTypes().length == 0) {
            this.layoutPanel.addRow((Widget)new HTML("<div class='highlight'>" + Constants.INSTANCE.NoModelTip() + "</div>"));
        }
        if (this.position == null) {
            HorizontalPanel hp0 = new HorizontalPanel();
            hp0.add((Widget)new HTML(Constants.INSTANCE.PositionColon()));
            hp0.add((Widget)this.positionCbo);
            hp0.add((Widget)new InfoPopup(Constants.INSTANCE.PositionColon(), Constants.INSTANCE.ConditionPositionExplanation()));
            this.layoutPanel.addRow((Widget)hp0);
        }
        this.choices = this.makeChoicesListBox();
        this.choicesPanel.add((Widget)this.choices);
        this.layoutPanel.addRow((Widget)this.choicesPanel);
        HorizontalPanel hp = new HorizontalPanel();
        Button ok = new Button(Constants.INSTANCE.OK());
        hp.add((Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuleModellerConditionSelectorPopup.this.selectSomething();
            }
        });
        Button cancel = new Button(Constants.INSTANCE.Cancel());
        hp.add((Widget)cancel);
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuleModellerConditionSelectorPopup.this.hide();
            }
        });
        CheckBox chkOnlyDisplayDSLConditions = new CheckBox();
        chkOnlyDisplayDSLConditions.setText(Constants.INSTANCE.OnlyDisplayDSLConditions());
        chkOnlyDisplayDSLConditions.setValue(Boolean.valueOf(this.bOnlyShowDSLConditions));
        chkOnlyDisplayDSLConditions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RuleModellerConditionSelectorPopup.this.bOnlyShowDSLConditions = (Boolean)event.getValue();
                RuleModellerConditionSelectorPopup.this.choicesPanel.setWidget((Widget)RuleModellerConditionSelectorPopup.this.makeChoicesListBox());
            }
        });
        this.layoutPanel.addRow((Widget)chkOnlyDisplayDSLConditions);
        this.layoutPanel.addRow((Widget)hp);
        this.setAfterShow(new Command(){

            public void execute() {
                RuleModellerConditionSelectorPopup.this.choices.setFocus(true);
            }
        });
        return this.layoutPanel;
    }

    private ListBox makeChoicesListBox() {
        this.choices = new ListBox(true);
        this.choices.setPixelSize(this.getChoicesWidth(), this.getChoicesHeight());
        this.choices.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    RuleModellerConditionSelectorPopup.this.selectSomething();
                }
            }
        });
        this.addDSLSentences();
        if (!this.bOnlyShowDSLConditions) {
            this.addFacts();
            this.addExistentialConditionalElements();
            this.addFromConditionalElements();
            this.addFreeFormDrl();
        }
        return this.choices;
    }

    private void addDSLSentences() {
        if (this.completions.getDSLConditions().length > 0) {
            for (int i = 0; i < this.completions.getDSLConditions().length; ++i) {
                final DSLSentence sen = this.completions.getDSLConditions()[i];
                String key = "DSL" + i;
                this.choices.addItem(sen.toString(), key);
                this.cmds.put(key, new Command(){

                    public void execute() {
                        RuleModellerConditionSelectorPopup.this.addNewDSLLhs(sen, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerConditionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addFacts() {
        if (this.completions.getFactTypes().length > 0) {
            this.choices.addItem("..................");
            for (int i = 0; i < this.completions.getFactTypes().length; ++i) {
                final String f = this.completions.getFactTypes()[i];
                String key = "NF" + f;
                this.choices.addItem(f + " ...", key);
                this.cmds.put(key, new Command(){

                    public void execute() {
                        RuleModellerConditionSelectorPopup.this.addNewFact(f, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                        RuleModellerConditionSelectorPopup.this.hide();
                    }
                });
            }
        }
    }

    private void addExistentialConditionalElements() {
        String[] ces = HumanReadable.CONDITIONAL_ELEMENTS;
        this.choices.addItem("..................");
        for (int i = 0; i < ces.length; ++i) {
            final String ce = ces[i];
            String key = "CE" + ce;
            this.choices.addItem(HumanReadable.getCEDisplayName(ce) + " ...", key);
            this.cmds.put(key, new Command(){

                public void execute() {
                    RuleModellerConditionSelectorPopup.this.addNewCE(ce, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerConditionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addFromConditionalElements() {
        String[] fces = HumanReadable.FROM_CONDITIONAL_ELEMENTS;
        this.choices.addItem("..................");
        for (int i = 0; i < fces.length; ++i) {
            final String ce = fces[i];
            String key = "FCE" + ce;
            this.choices.addItem(HumanReadable.getCEDisplayName(ce) + " ...", key);
            this.cmds.put(key, new Command(){

                public void execute() {
                    RuleModellerConditionSelectorPopup.this.addNewFCE(ce, Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerConditionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addFreeFormDrl() {
        if (UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_KNOWLEDGE_BASES_VIEW})) {
            this.choices.addItem("..................");
            this.choices.addItem(Constants.INSTANCE.FreeFormDrl(), "FF");
            this.cmds.put("FF", new Command(){

                public void execute() {
                    RuleModellerConditionSelectorPopup.this.model.addLhsItem((IPattern)new FreeFormLine(), Integer.parseInt(RuleModellerConditionSelectorPopup.this.positionCbo.getValue(RuleModellerConditionSelectorPopup.this.positionCbo.getSelectedIndex())));
                    RuleModellerConditionSelectorPopup.this.hide();
                }
            });
        }
    }

    private void addNewDSLLhs(DSLSentence sentence, int position) {
        this.model.addLhsItem((IPattern)sentence.copy(), position);
    }

    private void addNewFact(String itemText, int position) {
        this.model.addLhsItem((IPattern)new FactPattern(itemText), position);
    }

    private void addNewCE(String s, int position) {
        this.model.addLhsItem((IPattern)new CompositeFactPattern(s), position);
    }

    private void addNewFCE(String type, int position) {
        FromCompositeFactPattern p = null;
        if (type.equals("from")) {
            p = new FromCompositeFactPattern();
        } else if (type.equals("from accumulate")) {
            p = new FromAccumulateCompositeFactPattern();
        } else if (type.equals("from collect")) {
            p = new FromCollectCompositeFactPattern();
        } else if (type.equals("from entry-point")) {
            p = new FromEntryPointFactPattern();
        }
        this.model.addLhsItem((IPattern)p, position);
    }
}

