/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.GenericColumnCommand;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;

public class ActionRetractFactPopup
extends FormStylePopup {
    private ActionRetractFactCol52 editingCol;
    private GuidedDecisionTable52 model;
    private BRLRuleModel rm;

    public ActionRetractFactPopup(GuidedDecisionTable52 model, final GenericColumnCommand refreshGrid, final ActionRetractFactCol52 col, final boolean isNew, boolean isReadOnly) {
        this.rm = new BRLRuleModel(model);
        this.editingCol = this.cloneActionRetractColumn(col);
        this.model = model;
        this.setTitle(Constants.INSTANCE.ColumnConfigurationRetractAFact());
        this.setModal(false);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            final LimitedEntryActionRetractFactCol52 ler = (LimitedEntryActionRetractFactCol52)this.editingCol;
            final ListBox patterns = this.loadBoundFacts(ler.getValue().getStringValue());
            patterns.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                patterns.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int index = patterns.getSelectedIndex();
                        if (index > -1) {
                            ler.getValue().setStringValue(patterns.getValue(index));
                        }
                    }
                });
            }
            this.addAttribute(Constants.INSTANCE.FactToRetractColon(), (Widget)patterns);
        }
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionRetractFactPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (Widget)header);
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (Widget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (null == ActionRetractFactPopup.this.editingCol.getHeader() || "".equals(ActionRetractFactPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
                    return;
                }
                if (isNew) {
                    if (!ActionRetractFactPopup.this.unique(ActionRetractFactPopup.this.editingCol.getHeader())) {
                        Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                        return;
                    }
                } else if (!col.getHeader().equals(ActionRetractFactPopup.this.editingCol.getHeader()) && !ActionRetractFactPopup.this.unique(ActionRetractFactPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                    return;
                }
                refreshGrid.execute((DTColumnConfig52)ActionRetractFactPopup.this.editingCol);
                ActionRetractFactPopup.this.hide();
            }
        });
        this.addAttribute("", (Widget)apply);
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }

    private ActionRetractFactCol52 cloneActionRetractColumn(ActionRetractFactCol52 col) {
        LimitedEntryActionRetractFactCol52 clone = null;
        if (col instanceof LimitedEntryCol) {
            clone = new LimitedEntryActionRetractFactCol52();
            DTCellValue52 dcv = new DTCellValue52(((LimitedEntryCol)col).getValue().getStringValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionRetractFactCol52();
        }
        clone.setHeader(col.getHeader());
        clone.setHideColumn(col.isHideColumn());
        return clone;
    }

    private ListBox loadBoundFacts(String binding) {
        ListBox listBox = new ListBox();
        listBox.addItem(Constants.INSTANCE.Choose());
        List factBindings = this.rm.getLHSBoundFacts();
        for (int index = 0; index < factBindings.size(); ++index) {
            String boundName = (String)factBindings.get(index);
            if ("".equals(boundName)) continue;
            listBox.addItem(boundName);
            if (!boundName.equals(binding)) continue;
            listBox.setSelectedIndex(index + 1);
        }
        listBox.setEnabled(listBox.getItemCount() > 1);
        if (listBox.getItemCount() == 1) {
            listBox.clear();
            listBox.addItem(Constants.INSTANCE.NoPatternBindingsAvailable());
        }
        return listBox;
    }
}

