/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationRetention;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;

public class AbstractAnnotationDefinition
implements AnnotationDefinition {
    protected String className;
    protected List<AnnotationValuePairDefinition> valuePairs = new ArrayList<AnnotationValuePairDefinition>();
    protected boolean objectAnnotation = false;
    protected boolean propertyAnnotation = false;
    protected List<ElementType> targets = new ArrayList<ElementType>();
    protected AnnotationRetention retention = AnnotationRetention.CLASS;

    protected AbstractAnnotationDefinition() {
    }

    protected AbstractAnnotationDefinition(String className) {
        this.className = className;
    }

    protected AbstractAnnotationDefinition(String className, boolean objectAnnotation, boolean propertyAnnotation) {
        this(className);
        this.objectAnnotation = objectAnnotation;
        this.propertyAnnotation = propertyAnnotation;
    }

    @Override
    public List<AnnotationValuePairDefinition> getValuePairs() {
        return this.valuePairs;
    }

    @Override
    public AnnotationValuePairDefinition getValuePair(String valuePairName) {
        if (valuePairName != null) {
            for (AnnotationValuePairDefinition valuePairDefinition : this.valuePairs) {
                if (!valuePairName.equals(valuePairDefinition.getName())) continue;
                return valuePairDefinition;
            }
        }
        return null;
    }

    public void addValuePair(AnnotationValuePairDefinition valuePair) {
        this.valuePairs.add(valuePair);
    }

    @Override
    public boolean isMarker() {
        return this.valuePairs == null || this.valuePairs.size() == 0;
    }

    @Override
    public boolean isNormal() {
        return !this.isMarker() && !this.isSingleValue();
    }

    @Override
    public boolean isSingleValue() {
        return this.valuePairs != null && this.valuePairs.size() == 1;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isTypeAnnotation() {
        return this.targets.contains((Object)ElementType.TYPE);
    }

    @Override
    public boolean isFieldAnnotation() {
        return this.targets.contains((Object)ElementType.FIELD);
    }

    @Override
    public AnnotationRetention getRetention() {
        return this.retention;
    }

    @Override
    public void setRetention(AnnotationRetention retention) {
        this.retention = retention;
    }

    @Override
    public List<ElementType> getTarget() {
        return this.targets;
    }

    @Override
    public void addTarget(ElementType target) {
        if (!this.targets.contains((Object)target)) {
            this.targets.add(target);
        }
    }

    @Override
    public boolean hasValue(String valuePairName) {
        if (valuePairName != null) {
            for (AnnotationValuePairDefinition valuePairDefinition : this.valuePairs) {
                if (!valuePairName.equals(valuePairDefinition.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAnnotationDefinition that = (AbstractAnnotationDefinition)o;
        if (this.objectAnnotation != that.objectAnnotation) {
            return false;
        }
        if (this.propertyAnnotation != that.propertyAnnotation) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.valuePairs != null ? !this.valuePairs.equals(that.valuePairs) : that.valuePairs != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        return this.retention == that.retention;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.valuePairs != null ? this.valuePairs.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.objectAnnotation ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.propertyAnnotation ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

