/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialUserClusterPersistence;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.message.MessageHandler;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.commons.message.MessageType;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class SocialUserClusterMessaging {
    private Gson gson;
    private Type gsonCollectionType;
    private String cluster = "social-user";
    @Inject
    @Named(value="clusterServiceFactory")
    private ClusterServiceFactory clusterServiceFactory;
    @Inject
    @Named(value="socialUserPersistenceAPI")
    private SocialUserPersistenceAPI socialUserCachePersistence;
    private ClusterService clusterService;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
        this.clusterService = this.clusterServiceFactory != null ? this.clusterServiceFactory.build(new MessageHandlerResolver(){

            public String getServiceId() {
                return SocialUserClusterMessaging.this.cluster;
            }

            public MessageHandler resolveHandler(String serviceId, MessageType type) {
                return new MessageHandler(){

                    public Pair<MessageType, Map<String, String>> handleMessage(MessageType type, Map<String, String> content) {
                        String strType;
                        if (type != null && (strType = type.toString()).equals(SocialUserClusterMessage.SOCIAL_USER_UPDATE.name())) {
                            SocialUserClusterMessaging.this.handleUserUpdate(content);
                        }
                        return new Pair((Object)type, content);
                    }
                };
            }
        }) : null;
    }

    private void handleUserUpdate(Map<String, String> content) {
        for (Map.Entry<String, String> entry : content.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(SocialUserClusterMessage.UPDATE_USER.name())) continue;
            SocialUser user = (SocialUser)this.gson.fromJson(entry.getValue(), SocialUser.class);
            SocialUserClusterPersistence socialUserClusterPersistence = (SocialUserClusterPersistence)this.socialUserCachePersistence;
            socialUserClusterPersistence.sync(user);
        }
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
        this.gsonCollectionType = new TypeToken<Collection<SocialActivitiesEvent>>(){}.getType();
    }

    public void notify(SocialUser user) {
        if (this.clusterService == null) {
            return;
        }
        HashMap<String, String> content = new HashMap<String, String>();
        String json = this.gson.toJson((Object)user);
        content.put(SocialUserClusterMessage.UPDATE_USER.name(), json);
        this.clusterService.broadcast(this.cluster, (MessageType)SocialUserClusterMessage.SOCIAL_USER_UPDATE, content);
    }

    private static enum SocialUserClusterMessage implements MessageType
    {
        UPDATE_USER,
        SOCIAL_USER_UPDATE;

    }
}

