/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.RefreshModuleListEvent;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.client.widgets.tables.AdminArchivedPagedTable;

public class ArchivedAssetManager
extends Composite {
    private AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
    private ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private AdminArchivedPagedTable table;
    private ListBox packages = new ListBox(true);
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private Button btnRestorePackage;
    private Button btnDeletePackage;
    private EventBus eventBus;

    public ArchivedAssetManager(ClientFactory clientFactory, EventBus eventBus) {
        this.eventBus = eventBus;
        PrettyFormLayout pf = new PrettyFormLayout();
        VerticalPanel header = new VerticalPanel();
        header.add((Widget)new HTML(this.constants.ArchivedItems()));
        pf.addHeader(GuvnorImages.INSTANCE.Backup(), (Widget)header);
        this.loadPackages();
        Command restoreSelectedAssetCommand = new Command(){

            public void execute() {
                if (ArchivedAssetManager.this.table.getSelectedRowUUIDs() == null) {
                    Window.alert((String)ArchivedAssetManager.this.constants.PleaseSelectAnItemToRestore());
                    return;
                }
                ArchivedAssetManager.this.assetService.archiveAssets(ArchivedAssetManager.this.table.getSelectedRowUUIDs(), false, new GenericCallback<Void>(){

                    public void onSuccess(Void arg0) {
                        Window.alert((String)ArchivedAssetManager.this.constants.ItemRestored());
                        ArchivedAssetManager.this.table.refresh();
                    }
                });
            }
        };
        Command deleteSelectedAssetCommand = new Command(){

            public void execute() {
                if (ArchivedAssetManager.this.table.getSelectedRowUUIDs() == null) {
                    Window.alert((String)ArchivedAssetManager.this.constants.PleaseSelectAnItemToPermanentlyDelete());
                    return;
                }
                if (!Window.confirm((String)ArchivedAssetManager.this.constants.AreYouSureDeletingAsset())) {
                    return;
                }
                ArchivedAssetManager.this.assetService.removeAssets(ArchivedAssetManager.this.table.getSelectedRowUUIDs(), new GenericCallback<Void>(){

                    public void onSuccess(Void arg0) {
                        Window.alert((String)ArchivedAssetManager.this.constants.ItemDeleted());
                        ArchivedAssetManager.this.table.refresh();
                    }
                });
            }
        };
        this.table = new AdminArchivedPagedTable(restoreSelectedAssetCommand, deleteSelectedAssetCommand, clientFactory);
        HorizontalPanel packagesToolbar = new HorizontalPanel();
        this.btnRestorePackage = new Button(this.constants.RestoreSelectedPackage());
        this.btnRestorePackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ArchivedAssetManager.this.packages.getSelectedIndex() == -1) {
                    Window.alert((String)ArchivedAssetManager.this.constants.PleaseSelectAnItemToRestore());
                    return;
                }
                ArchivedAssetManager.this.restorePackage(ArchivedAssetManager.this.packages.getValue(ArchivedAssetManager.this.packages.getSelectedIndex()));
            }
        });
        packagesToolbar.add((Widget)this.btnRestorePackage);
        this.btnDeletePackage = new Button(this.constants.PermanentlyDeletePackage());
        this.btnDeletePackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ArchivedAssetManager.this.packages.getSelectedIndex() == -1) {
                    Window.alert((String)ArchivedAssetManager.this.constants.PleaseSelectAnItemToPermanentlyDelete());
                    return;
                }
                if (Window.confirm((String)ArchivedAssetManager.this.constants.AreYouSurePackageDelete())) {
                    ArchivedAssetManager.this.deletePackage(ArchivedAssetManager.this.packages.getValue(ArchivedAssetManager.this.packages.getSelectedIndex()));
                }
            }
        });
        packagesToolbar.add((Widget)this.btnDeletePackage);
        pf.startSection(this.constants.ArchivedPackagesList());
        pf.addRow((Widget)packagesToolbar);
        pf.addRow((Widget)this.packages);
        pf.endSection();
        pf.startSection(this.constants.ArchivedAssets());
        pf.addRow((Widget)this.table);
        pf.endSection();
        this.initWidget((Widget)pf);
    }

    private void deletePackage(String uuid) {
        this.moduleService.removeModule(uuid, new GenericCallback<Void>(){

            public void onSuccess(Void data) {
                Window.alert((String)ArchivedAssetManager.this.constants.PackageDeleted());
                ArchivedAssetManager.this.packages.clear();
                ArchivedAssetManager.this.loadPackages();
            }
        });
    }

    private void restorePackage(String uuid) {
        this.moduleService.loadModule(uuid, (AsyncCallback<Module>)new GenericCallback<Module>(){

            public void onSuccess(Module cf) {
                cf.setArchived(false);
                ArchivedAssetManager.this.moduleService.saveModule(cf, new GenericCallback<ValidatedResponse>(){

                    public void onSuccess(ValidatedResponse data) {
                        Window.alert((String)ArchivedAssetManager.this.constants.PackageRestored());
                        ArchivedAssetManager.this.packages.clear();
                        ArchivedAssetManager.this.loadPackages();
                        ArchivedAssetManager.this.table.refresh();
                        ArchivedAssetManager.this.eventBus.fireEvent((GwtEvent)new RefreshModuleListEvent());
                    }
                });
            }
        });
    }

    private ListBox loadPackages() {
        this.moduleService.listArchivedModules((AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] configs) {
                for (Module config : configs) {
                    ArchivedAssetManager.this.packages.addItem(config.getName(), config.getUuid());
                }
                if (configs.length == 0) {
                    ArchivedAssetManager.this.packages.addItem(ArchivedAssetManager.this.constants.noArchivedPackages());
                }
                boolean enabled = configs.length != 0;
                ArchivedAssetManager.this.packages.setEnabled(enabled);
                ArchivedAssetManager.this.btnRestorePackage.setEnabled(enabled);
                ArchivedAssetManager.this.btnDeletePackage.setEnabled(enabled);
            }
        });
        return this.packages;
    }
}

