/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRow;
import org.drools.guvnor.client.rpc.SnapshotDiff;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.server.builder.ModuleAssembler;
import org.drools.guvnor.server.builder.ModuleAssemblerConfiguration;
import org.drools.guvnor.server.builder.ModuleAssemblerManager;
import org.drools.guvnor.server.builder.pagerow.SnapshotComparisonPageRowBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.BuilderResultHelper;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.ModuleFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.security.Identity;

@ApplicationScoped
public class RepositoryModuleOperations {
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryModuleOperations.class);
    private static final int MAX_ASSETS_TO_SHOW_IN_MODULE_LIST = 5000;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private Identity identity;

    @Deprecated
    public void setRulesRepositoryForTest(RulesRepository repository) {
        this.rulesRepository = repository;
    }

    protected Module[] listModules(boolean archive, String workspace, RepositoryFilter filter) {
        ArrayList<Module> result = new ArrayList<Module>();
        ModuleIterator modules = this.rulesRepository.listModules();
        this.handleIterateModules(archive, workspace, filter, result, modules);
        this.sortModules(result);
        return result.toArray(new Module[result.size()]);
    }

    private void handleIterateModules(boolean archive, String workspace, RepositoryFilter filter, List<Module> result, ModuleIterator modules) {
        modules.setArchivedIterator(archive);
        while (modules.hasNext()) {
            ModuleItem packageItem = modules.next();
            Module data = new Module();
            data.setUuid(packageItem.getUUID());
            data.setName(packageItem.getName());
            data.setArchived(packageItem.isArchived());
            data.setWorkspaces(packageItem.getWorkspaces());
            this.handleIsModuleListed(archive, workspace, filter, result, data);
            data.subModules = this.listSubModules(packageItem, archive, null, filter);
        }
    }

    private Module[] listSubModules(ModuleItem parentModule, boolean archive, String workspace, RepositoryFilter filter) {
        LinkedList<Module> children = new LinkedList<Module>();
        this.handleIterateModules(archive, workspace, filter, children, parentModule.listSubModules());
        this.sortModules(children);
        return children.toArray(new Module[children.size()]);
    }

    void sortModules(List<Module> result) {
        Collections.sort(result, new Comparator<Module>(){

            @Override
            public int compare(Module d1, Module d2) {
                return d1.getName().compareTo(d2.getName());
            }
        });
    }

    private void handleIsModuleListed(boolean archive, String workspace, RepositoryFilter filter, List<Module> result, Module data) {
        if (!(archive || filter != null && !filter.accept((Object)data, RoleType.PACKAGE_READONLY.getName()) || workspace != null && !this.isWorkspace(workspace, data.getWorkspaces()))) {
            result.add(data);
        } else if (archive && data.isArchived() && (filter == null || filter.accept((Object)data, RoleType.PACKAGE_READONLY.getName())) && (workspace == null || this.isWorkspace(workspace, data.getWorkspaces()))) {
            result.add(data);
        }
    }

    private boolean isWorkspace(String workspace, String[] workspaces) {
        for (String w : workspaces) {
            if (!w.equals(workspace)) continue;
            return true;
        }
        return false;
    }

    protected Module loadGlobalModule() {
        ModuleItem item = this.rulesRepository.loadGlobalArea();
        Module data = ModuleFactory.createModuleWithOutDependencies(item);
        if (data.isSnapshot()) {
            data.setSnapshotName(item.getSnapshotName());
        }
        return data;
    }

    protected String copyModules(String sourceModuleName, String destModuleName) throws SerializationException {
        try {
            log.info("USER:" + this.getCurrentUserName() + " COPYING module [" + sourceModuleName + "] to  module [" + destModuleName + "]");
            String newModuleUUID = this.rulesRepository.copyModule(sourceModuleName, destModuleName);
            this.fixProcessPackageNames(newModuleUUID);
            return newModuleUUID;
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to copy module.", e);
            throw e;
        }
    }

    private void fixProcessPackageNames(String moduleUUID) {
        ModuleItem newModule = this.rulesRepository.loadModuleByUUID(moduleUUID);
        AssetItemIterator assetIterator = newModule.listAssetsByFormat(new String[]{"rf", "bpmn", "bpmn2"});
        while (assetIterator.hasNext()) {
            AssetItem asset = assetIterator.next();
            String assetFormat = asset.getFormat();
            ContentHandler contentHandler = ContentManager.getHandler(assetFormat);
            if (!(contentHandler instanceof ICanHasAttachment)) continue;
            ICanHasAttachment attachmentHandler = (ICanHasAttachment)((Object)contentHandler);
            try {
                attachmentHandler.onAttachmentAdded(asset);
            }
            catch (IOException ioe) {
                log.error("Unable to rename Process [type=" + assetFormat + "] package for asset [" + asset.getName() + "]", ioe);
            }
        }
    }

    protected void removeModule(String uuid) {
        try {
            ModuleItem item = this.rulesRepository.loadModuleByUUID(uuid);
            log.info("USER:" + this.getCurrentUserName() + " REMOVEING module [" + item.getName() + "]");
            item.remove();
            this.rulesRepository.save();
        }
        catch (RulesRepositoryException e) {
            log.error("Unable to remove module.", e);
            throw e;
        }
    }

    protected String renameModule(String uuid, String newName) {
        log.info("USER:" + this.getCurrentUserName() + " RENAMING module [UUID: " + uuid + "] to module [" + newName + "]");
        this.rulesRepository.renameModule(uuid, newName);
        this.fixProcessPackageNames(uuid);
        return uuid;
    }

    protected byte[] exportModules(String moduleName) {
        log.info("USER:" + this.getCurrentUserName() + " export module [name: " + moduleName + "] ");
        try {
            return this.rulesRepository.dumpModuleFromRepositoryXml(moduleName);
        }
        catch (PathNotFoundException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
    }

    protected void importPackages(byte[] byteArray, boolean importAsNew) {
        this.rulesRepository.importPackageToRepository(byteArray, importAsNew);
    }

    protected String createModule(String name, String description, String format) throws RulesRepositoryException {
        log.info("USER: " + this.getCurrentUserName() + " CREATING module [" + name + "]");
        ModuleItem item = this.rulesRepository.createModule(name, description, format);
        return item.getUUID();
    }

    protected String createModule(String name, String description, String format, String[] workspace) throws RulesRepositoryException {
        log.info("USER: " + this.getCurrentUserName() + " CREATING module [" + name + "]");
        ModuleItem item = this.rulesRepository.createModule(name, description, format, workspace, "Initial");
        return item.getUUID();
    }

    protected String createSubModule(String name, String description, String parentNode) throws SerializationException {
        log.info("USER: " + this.getCurrentUserName() + " CREATING subModule [" + name + "], parent [" + parentNode + "]");
        ModuleItem item = this.rulesRepository.createSubModule(name, description, parentNode);
        return item.getUUID();
    }

    protected Module loadModule(ModuleItem packageItem) {
        Module data = ModuleFactory.createModuleWithDependencies(packageItem);
        if (data.isSnapshot()) {
            data.setSnapshotName(packageItem.getSnapshotName());
        }
        return data;
    }

    public void saveModule(Module data) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " SAVING module [" + data.getName() + "]");
        ModuleItem moduleItem = this.rulesRepository.loadModule(data.getName());
        boolean unarchived = !data.isArchived() && moduleItem.isArchived();
        Calendar lastModified = moduleItem.getLastModified();
        DroolsHeader.updateDroolsHeader(data.getHeader(), moduleItem);
        this.updateCategoryRules(data, moduleItem);
        moduleItem.updateExternalURI(data.getExternalURI());
        moduleItem.updateDescription(data.getDescription());
        moduleItem.archiveItem(data.isArchived());
        moduleItem.updateBinaryUpToDate(false);
        if (!data.getFormat().equals("")) {
            moduleItem.updateFormat(data.getFormat());
        }
        RuleBaseCache.getInstance().remove(data.getUuid());
        moduleItem.checkin(data.getDescription());
        if (data.isArchived()) {
            this.handleArchivedForSaveModule(data, moduleItem);
        } else if (unarchived) {
            this.handleUnarchivedForSaveModule(data, moduleItem, lastModified);
        }
    }

    void updateCategoryRules(Module data, ModuleItem item) {
        KeyValueTO keyValueTO = RepositoryModuleOperations.convertMapToCsv(data.getCatRules());
        item.updateCategoryRules(keyValueTO.getKeys(), keyValueTO.getValues());
    }

    private static KeyValueTO convertMapToCsv(Map map) {
        StringBuilder keysBuilder = new StringBuilder();
        StringBuilder valuesBuilder = new StringBuilder();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            if (keysBuilder.length() > 0) {
                keysBuilder.append(",");
            }
            if (valuesBuilder.length() > 0) {
                valuesBuilder.append(",");
            }
            keysBuilder.append(entry.getKey());
            valuesBuilder.append(entry.getValue());
        }
        return new KeyValueTO(keysBuilder.toString(), valuesBuilder.toString());
    }

    void handleArchivedForSaveModule(Module data, ModuleItem item) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.isArchived()) continue;
            assetItem.archiveItem(true);
            assetItem.checkin(data.getDescription());
        }
    }

    void handleUnarchivedForSaveModule(Module data, ModuleItem item, Calendar lastModified) {
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem assetItem = (AssetItem)iter.next();
            if (assetItem.getLastModified().compareTo(lastModified) < 0) continue;
            assetItem.archiveItem(false);
            assetItem.checkin(data.getDescription());
        }
    }

    public void createModuleSnapshot(String moduleName, String snapshotName, boolean replaceExisting, String comment, String buildMode, String statusOperator, String statusValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelector) throws SerializationException {
        this.createModuleSnapshot(moduleName, snapshotName, replaceExisting, comment, false, buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector);
    }

    public void createModuleSnapshot(String moduleName, String snapshotName, boolean replaceExisting, String comment, boolean checkIsBinaryUpToDate, String buildMode, String statusOperator, String statusValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelector) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " CREATING MODULE SNAPSHOT for module: [" + moduleName + "] snapshot name: [" + snapshotName);
        ModuleAssemblerConfiguration assemblerConfiguration = this.createConfiguration(buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector, true);
        ModuleItem p = this.rulesRepository.loadModule(moduleName);
        if (checkIsBinaryUpToDate && !p.isBinaryUpToDate()) {
            throw new SerializationException("Your package has not been built since last change. Please build the package first, then try \"Create snapshot for deployment\" again");
        }
        if (replaceExisting && this.rulesRepository.containsSnapshot(moduleName, snapshotName)) {
            this.rulesRepository.removeModuleSnapshot(moduleName, snapshotName);
        }
        this.rulesRepository.createModuleSnapshot(moduleName, snapshotName);
        ModuleItem item = this.rulesRepository.loadModuleSnapshot(moduleName, snapshotName);
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, assemblerConfiguration);
        List<AssetItem> listAssets = moduleAssembler.getAllNotToIncludeAssets();
        for (AssetItem itemToDelete : listAssets) {
            itemToDelete.remove();
        }
        item.updateCheckinComment(comment);
        this.rulesRepository.save();
    }

    protected void copyOrRemoveSnapshot(String moduleName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        if (delete) {
            log.info("USER:" + this.getCurrentUserName() + " REMOVING SNAPSHOT for module: [" + moduleName + "] snapshot: [" + snapshotName + "]");
            this.rulesRepository.removeModuleSnapshot(moduleName, snapshotName);
        } else {
            if (newSnapshotName.equals("")) {
                throw new SerializationException("Need to have a new snapshot name.");
            }
            log.info("USER:" + this.getCurrentUserName() + " COPYING SNAPSHOT for module: [" + moduleName + "] snapshot: [" + snapshotName + "] to [" + newSnapshotName + "]");
            this.rulesRepository.copyModuleSnapshot(moduleName, snapshotName, newSnapshotName);
        }
    }

    public BuilderResult buildModule(String moduleUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        ModuleItem moduleItem = this.rulesRepository.loadModuleByUUID(moduleUUID);
        try {
            return this.buildModule(moduleItem, force, this.createConfiguration(buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName, false));
        }
        catch (NoClassDefFoundError e) {
            throw new DetailedSerializationException("Unable to find a class that was needed when building the module  [" + e.getMessage() + "]", "Perhaps you are missing them from the model jars, or from the BRMS itself (lib directory).");
        }
        catch (UnsupportedClassVersionError e) {
            throw new DetailedSerializationException("Can not build the module. One or more of the classes that are needed were compiled with an unsupported Java version.", "For example the pojo classes were compiled with Java 1.6 and Guvnor is running on Java 1.5. [" + e.getMessage() + "]");
        }
    }

    private BuilderResult buildModule(ModuleItem item, boolean force, ModuleAssemblerConfiguration moduleAssemblerConfiguration) throws DetailedSerializationException {
        if (!force && item.isBinaryUpToDate()) {
            return BuilderResult.emptyResult();
        }
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, moduleAssemblerConfiguration);
        moduleAssembler.compile();
        if (moduleAssembler.hasErrors()) {
            BuilderResult result = new BuilderResult();
            BuilderResultHelper builderResultHelper = new BuilderResultHelper();
            result.addLines(builderResultHelper.generateBuilderResults(moduleAssembler.getErrors()));
            return result;
        }
        return BuilderResult.emptyResult();
    }

    private ModuleAssemblerConfiguration createConfiguration(String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String selectorConfigName, boolean includeArchivedItems) {
        ModuleAssemblerConfiguration moduleAssemblerConfiguration = new ModuleAssemblerConfiguration();
        moduleAssemblerConfiguration.setBuildMode(buildMode);
        moduleAssemblerConfiguration.setStatusOperator(statusOperator);
        moduleAssemblerConfiguration.setStatusDescriptionValue(statusDescriptionValue);
        moduleAssemblerConfiguration.setEnableStatusSelector(enableStatusSelector);
        moduleAssemblerConfiguration.setCategoryOperator(categoryOperator);
        moduleAssemblerConfiguration.setCategoryValue(category);
        moduleAssemblerConfiguration.setEnableCategorySelector(enableCategorySelector);
        moduleAssemblerConfiguration.setCustomSelectorConfigName(selectorConfigName);
        moduleAssemblerConfiguration.setIncludeArchivedItems(includeArchivedItems);
        return moduleAssemblerConfiguration;
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }

    protected void buildModuleWithoutErrors(ModuleItem moduleItem, boolean force) throws DetailedSerializationException {
        BuilderResult result = this.buildModule(moduleItem, false);
        if (result != null && result.getLines().size() != 0) {
            throw new DetailedSerializationException("Error building module (" + moduleItem.getName() + ").", result.getLines());
        }
    }

    protected BuilderResult buildModule(ModuleItem item, boolean force) throws DetailedSerializationException {
        return this.buildModule(item, force, this.createConfiguration(null, null, null, false, null, null, false, null, false));
    }

    protected String buildModuleSource(String moduleUUID) throws SerializationException {
        ModuleItem item = this.rulesRepository.loadModuleByUUID(moduleUUID);
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, null);
        return moduleAssembler.getCompiledSource();
    }

    protected String[] listRulesInPackage(String packageName) throws SerializationException {
        ModuleItem item = this.rulesRepository.loadModule(packageName);
        ModuleAssembler moduleAssembler = ModuleAssemblerManager.getModuleAssembler(item.getFormat(), item, null);
        ArrayList<String> result = new ArrayList<String>();
        try {
            String drl = moduleAssembler.getCompiledSource();
            if (drl == null || "".equals(drl)) {
                return new String[0];
            }
            this.parseRulesToPackageList(moduleAssembler, result);
            return result.toArray(new String[result.size()]);
        }
        catch (DroolsParserException e) {
            log.error("Unable to list rules in package", e);
            return new String[0];
        }
    }

    protected String[] listImagesInModule(String moduleName) throws SerializationException {
        ModuleItem item = this.rulesRepository.loadModule(moduleName);
        ArrayList<String> retList = new ArrayList<String>();
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem pitem = (AssetItem)iter.next();
            if (!pitem.getFormat().equalsIgnoreCase("png") && !pitem.getFormat().equalsIgnoreCase("gif") && !pitem.getFormat().equalsIgnoreCase("jpg")) continue;
            retList.add(pitem.getName());
        }
        return retList.toArray(new String[0]);
    }

    void parseRulesToPackageList(ModuleAssembler asm, List<String> result) throws DroolsParserException {
        int count = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(asm.getCompiledSource(), "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String line = stringTokenizer.nextToken().trim();
            if (!line.startsWith("rule ")) continue;
            String name = ClassicDRLImporter.getRuleName(line);
            result.add(name);
            if (++count != 5000) continue;
            result.add("More then 5000 rules.");
            break;
        }
    }

    protected SnapshotDiffs compareSnapshots(String moduleName, String firstSnapshotName, String secondSnapshotName) {
        ModuleItem rightModule;
        SnapshotDiffs diffs = new SnapshotDiffs();
        ArrayList<SnapshotDiff> list = new ArrayList<SnapshotDiff>();
        ModuleItem leftModule = this.rulesRepository.loadModuleSnapshot(moduleName, firstSnapshotName);
        if (this.isRightOlderThanLeft(leftModule, rightModule = this.rulesRepository.loadModuleSnapshot(moduleName, secondSnapshotName))) {
            ModuleItem temp = leftModule;
            leftModule = rightModule;
            rightModule = temp;
            diffs.leftName = secondSnapshotName;
            diffs.rightName = firstSnapshotName;
        } else {
            diffs.leftName = firstSnapshotName;
            diffs.rightName = secondSnapshotName;
        }
        Iterator leftExistingIter = leftModule.getAssets();
        while (leftExistingIter.hasNext()) {
            AssetItem left = (AssetItem)leftExistingIter.next();
            if (!this.isModuleItemDeleted(rightModule, left)) continue;
            SnapshotDiff diff = new SnapshotDiff();
            diff.name = left.getName();
            diff.diffType = "TYPE_DELETED";
            diff.leftUuid = left.getUUID();
            list.add(diff);
        }
        Iterator rightExistingIter = rightModule.getAssets();
        while (rightExistingIter.hasNext()) {
            SnapshotDiff diff;
            AssetItem right = (AssetItem)rightExistingIter.next();
            AssetItem left = null;
            if (right != null && leftModule.containsAsset(right.getName())) {
                left = leftModule.loadAsset(right.getName());
            }
            if (right == null || left == null) {
                diff = new SnapshotDiff();
                if (left == null) {
                    diff.name = right.getName();
                    diff.diffType = "TYPE_ADDED";
                    diff.rightUuid = right.getUUID();
                }
                list.add(diff);
                continue;
            }
            if (this.isAssetArchivedOrRestored(right, left)) {
                diff = new SnapshotDiff();
                diff.name = right.getName();
                diff.leftUuid = left.getUUID();
                diff.rightUuid = right.getUUID();
                diff.diffType = left.isArchived() ? "TYPE_RESTORED" : "TYPE_ARCHIVED";
                list.add(diff);
                continue;
            }
            if (!this.isAssetItemUpdated(right, left)) continue;
            diff = new SnapshotDiff();
            diff.name = right.getName();
            diff.leftUuid = left.getUUID();
            diff.rightUuid = right.getUUID();
            diff.diffType = "TYPE_UPDATED";
            list.add(diff);
        }
        diffs.diffs = list.toArray(new SnapshotDiff[list.size()]);
        return diffs;
    }

    private boolean isAssetArchivedOrRestored(AssetItem right, AssetItem left) {
        return right.isArchived() != left.isArchived();
    }

    private boolean isAssetItemUpdated(AssetItem right, AssetItem left) {
        return right.getLastModified().compareTo(left.getLastModified()) != 0;
    }

    private boolean isModuleItemDeleted(ModuleItem rightModuleItem, AssetItem left) {
        return !rightModuleItem.containsAsset(left.getName());
    }

    private boolean isRightOlderThanLeft(ModuleItem leftModuleItem, ModuleItem rightModuleItem) {
        return leftModuleItem.getLastModified().compareTo(rightModuleItem.getLastModified()) > 0;
    }

    protected SnapshotComparisonPageResponse compareSnapshots(SnapshotComparisonPageRequest request) {
        SnapshotComparisonPageResponse response = new SnapshotComparisonPageResponse();
        long start = System.currentTimeMillis();
        SnapshotDiffs diffs = this.compareSnapshots(request.getPackageName(), request.getFirstSnapshotName(), request.getSecondSnapshotName());
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        response.setLeftSnapshotName(diffs.leftName);
        response.setRightSnapshotName(diffs.rightName);
        List<SnapshotComparisonPageRow> rowList = new SnapshotComparisonPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(diffs).build();
        response.setPageRowList(rowList);
        response.setStartRowIndex(request.getStartRowIndex());
        response.setTotalRowSize(diffs.diffs.length);
        response.setTotalRowSizeExact(true);
        response.setLastPage(request.getStartRowIndex() + rowList.size() == diffs.diffs.length);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Compared Snapshots ('" + request.getFirstSnapshotName() + "') and ('" + request.getSecondSnapshotName() + "') in package ('" + request.getPackageName() + "') in " + methodDuration + " ms.");
        return response;
    }

    private static class KeyValueTO {
        private final String keys;
        private final String values;

        public KeyValueTO(String keys, String values) {
            this.keys = keys;
            this.values = values;
        }

        public String getKeys() {
            return this.keys;
        }

        public String getValues() {
            return this.values;
        }
    }
}

